/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.HashSet;
import java.util.Set;

public class XMSSUtil {
    public static int log2(int n) {
        int n2 = 0;
        while ((n >>= 1) != 0) {
            ++n2;
        }
        return n2;
    }

    public static byte[] toBytesBigEndian(long l, int n) {
        byte[] byArray = new byte[n];
        for (int k = (v891870) - 1; k >= 0; --k) {
            byArray[k] = (byte)l;
            l >>>= 8;
        }
        return byArray;
    }

    public static void longToBigEndian(long l, byte[] byArray, int n) {
        if (byArray != null) {
            if (byArray.length - n >= 8) {
                byArray[n] = (byte)(l >> 56 & 0xFFL);
                int n2 = n + 1;
                byArray[n2] = (byte)(l >> 48 & 0xFFL);
                n2 = n + 2;
                byArray[n2] = (byte)(l >> 40 & 0xFFL);
                n2 = n + 3;
                byArray[n2] = (byte)(l >> 32 & 0xFFL);
                n2 = n + 4;
                byArray[n2] = (byte)(l >> 24 & 0xFFL);
                n2 = n + 5;
                byArray[n2] = (byte)(l >> 16 & 0xFFL);
                n2 = n + 6;
                byArray[n2] = (byte)(l >> 8 & 0xFFL);
                n2 = n + 7;
                byArray[n2] = (byte)(l & 0xFFL);
                return;
            }
            throw new IllegalArgumentException("not enough space in array");
        }
        throw new NullPointerException("in == null");
    }

    public static long bytesToXBigEndian(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            long l = 0L;
            for (int k = n; k < n + n2; ++k) {
                l = l << 8 | (long)(byArray[k] & 0xFF);
            }
            return l;
        }
        throw new NullPointerException("in == null");
    }

    public static byte[] cloneArray(byte[] byArray) {
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            int n = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        throw new NullPointerException("in == null");
    }

    public static byte[][] cloneArray(byte[][] byArray) {
        if (!XMSSUtil.hasNullPointer(byArray)) {
            byte[][] byArrayArray = new byte[byArray.length][];
            for (int k = 0; k < byArray.length; ++k) {
                byte[] byArray2 = new byte[byArray[k].length];
                byArrayArray[k] = byArray2;
                byte[] byArray3 = byArray[k];
                int n = byArray3.length;
                System.arraycopy(byArray3, 0, byArray2, 0, n);
            }
            return byArrayArray;
        }
        throw new NullPointerException("in has null pointers");
    }

    public static boolean areEqual(byte[][] byArray, byte[][] byArray2) {
        if (!XMSSUtil.hasNullPointer(byArray) && !XMSSUtil.hasNullPointer(byArray2)) {
            for (int k = 0; k < byArray.length; ++k) {
                if (Arrays.areEqual(byArray[k], byArray2[k])) continue;
                return false;
            }
            return true;
        }
        throw new NullPointerException("a or b == null");
    }

    public static void dumpByteArray(byte[][] byArray) {
        if (!XMSSUtil.hasNullPointer(byArray)) {
            for (int k = 0; k < byArray.length; ++k) {
                System.out.println(Hex.toHexString(byArray[k]));
            }
            return;
        }
        throw new NullPointerException("x has null pointers");
    }

    public static boolean hasNullPointer(byte[][] byArray) {
        if (byArray == null) {
            return true;
        }
        for (int k = 0; k < byArray.length; ++k) {
            if (byArray[k] != null) continue;
            return true;
        }
        return false;
    }

    public static void copyBytesAtOffset(byte[] byArray, byte[] byArray2, int n) {
        if (byArray != null) {
            if (byArray2 != null) {
                if (n >= 0) {
                    if (byArray2.length + n <= byArray.length) {
                        for (int k = 0; k < byArray2.length; ++k) {
                            int n2 = n + k;
                            byArray[n2] = byArray2[k];
                        }
                        return;
                    }
                    throw new IllegalArgumentException("src length + offset must not be greater than size of destination");
                }
                throw new IllegalArgumentException("offset hast to be >= 0");
            }
            throw new NullPointerException("src == null");
        }
        throw new NullPointerException("dst == null");
    }

    public static byte[] extractBytesAtOffset(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            if (n >= 0) {
                if (n2 >= 0) {
                    if (n + n2 <= byArray.length) {
                        byte[] byArray2 = new byte[n2];
                        for (int k = 0; k < n2; ++k) {
                            byArray2[k] = byArray[n + k];
                        }
                        return byArray2;
                    }
                    throw new IllegalArgumentException("offset + length must not be greater then size of source array");
                }
                throw new IllegalArgumentException("length hast to be >= 0");
            }
            throw new IllegalArgumentException("offset hast to be >= 0");
        }
        throw new NullPointerException("src == null");
    }

    public static boolean isIndexValid(int n, long l) {
        if (l >= 0L) {
            return l < 1L << n;
        }
        throw new IllegalStateException("index must not be negative");
    }

    public static int getDigestSize(Digest digest) {
        if (digest != null) {
            String string = digest.getAlgorithmName();
            if (string.equals("SHAKE128")) {
                return 32;
            }
            if (string.equals("SHAKE256")) {
                return 64;
            }
            return digest.getDigestSize();
        }
        throw new NullPointerException("digest == null");
    }

    public static long getTreeIndex(long l, int n) {
        return l >> n;
    }

    public static int getLeafIndex(long l, int n) {
        return (int)(l & (1L << n) - 1L);
    }

    public static byte[] serialize(Object object) {
        ByteArrayOutputStream byteArrayOutputStream;
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream2);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static Object deserialize(byte[] object, Class clazz) {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream((byte[])object);
        CheckingStream checkingStream = new CheckingStream(clazz, byteArrayInputStream2);
        object = checkingStream.readObject();
        if (checkingStream.available() == 0) {
            if (clazz.isInstance(object)) {
                return object;
            }
            throw new IOException("unexpected class found in ObjectInputStream");
        }
        throw new IOException("unexpected data found at end of ObjectInputStream");
    }

    public static int calculateTau(int n, int n2) {
        int n3 = 0;
        for (int k = 0; k < n2; ++k) {
            if ((n >> k & 1) != 0) continue;
            n3 = k;
            break;
        }
        return n3;
    }

    public static boolean isNewBDSInitNeeded(long l, int n, int n2) {
        if (l == 0L) {
            return false;
        }
        return l % (long)Math.pow(1 << n, n2 + 1) == 0L;
    }

    public static boolean isNewAuthenticationPathNeeded(long l, int n, int n2) {
        if (l == 0L) {
            return false;
        }
        return (l + 1L) % (long)Math.pow(1 << n, n2) == 0L;
    }

    public static class CheckingStream
    extends ObjectInputStream {
        private static final Set components = new HashSet<String>();
        private final Class mainClass;
        private boolean found = false;

        public CheckingStream(Class clazz, InputStream inputStream) {
            super(inputStream);
            this.mainClass = clazz;
        }

        static {
            components.add("java.util.TreeMap");
            components.add("java.lang.Integer");
            components.add("java.lang.Number");
            components.add("com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDS");
            components.add("java.util.ArrayList");
            components.add("com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.XMSSNode");
            components.add("[B");
            components.add("java.util.LinkedList");
            components.add("java.util.Stack");
            components.add("java.util.Vector");
            components.add("[Ljava.lang.Object;");
            components.add("com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.xmss.BDSTreeHash");
        }

        @Override
        public Class<?> resolveClass(ObjectStreamClass objectStreamClass) {
            block5: {
                block4: {
                    block2: {
                        block3: {
                            if (this.found) break block2;
                            if (!objectStreamClass.getName().equals(this.mainClass.getName())) break block3;
                            this.found = true;
                            break block4;
                        }
                        throw new InvalidClassException("unexpected class: ", objectStreamClass.getName());
                    }
                    if (!components.contains(objectStreamClass.getName())) break block5;
                }
                return super.resolveClass(objectStreamClass);
            }
            throw new InvalidClassException("unexpected class: ", objectStreamClass.getName());
        }
    }
}

