/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.scuba.smartcards;

import b.b;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class ResponseAPDU
implements Serializable {
    private static final long serialVersionUID = 6962744978375594225L;
    private byte[] apdu;

    public ResponseAPDU(byte[] byArray) {
        byte[] byArray2 = (byte[])byArray.clone();
        ResponseAPDU.check(byArray2);
        this.apdu = byArray2;
    }

    private static void check(byte[] byArray) {
        if (byArray.length >= 2) {
            return;
        }
        throw new IllegalArgumentException("apdu must be at least 2 bytes long");
    }

    private void readObject(ObjectInputStream objectInputStream) {
        this.apdu = (byte[])objectInputStream.readUnshared();
        ResponseAPDU.check(this.apdu);
    }

    public int getNr() {
        return this.apdu.length - 2;
    }

    public byte[] getData() {
        Object object = ((ResponseAPDU)object).apdu;
        int n = ((ResponseAPDU)object).apdu.length - 2;
        byte[] byArray = new byte[n];
        System.arraycopy(object, 0, byArray, 0, n);
        return byArray;
    }

    public int getSW1() {
        return this.apdu[this.apdu.length - 2] & 0xFF;
    }

    public int getSW2() {
        return this.apdu[this.apdu.length - 1] & 0xFF;
    }

    public int getSW() {
        return this.getSW1() << 8 | this.getSW2();
    }

    public byte[] getBytes() {
        return (byte[])this.apdu.clone();
    }

    public String toString() {
        return b.a("ResponseAPDU: ").append(this.apdu.length).append(" bytes, SW=").append(Integer.toHexString(this.getSW())).toString();
    }

    public boolean equals(Object object) {
        if (responseAPDU2 == object) {
            return true;
        }
        if (!(object instanceof ResponseAPDU)) {
            return false;
        }
        ResponseAPDU responseAPDU = responseAPDU2;
        ResponseAPDU responseAPDU2 = (ResponseAPDU)object;
        return Arrays.equals(responseAPDU.apdu, responseAPDU2.apdu);
    }

    public int hashCode() {
        return Arrays.hashCode(this.apdu);
    }
}

