/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.View;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.utils.Common;
import vn.kalapa.ekyc.views.OvalLivenessOverlayView;

public final class OvalLivenessOverlayView
extends View {
    @NotNull
    private final Paint ovalPaint;
    @NotNull
    private final Paint overlayPaint;
    @NotNull
    private final Paint clearPaint;
    @NotNull
    private final RectF ovalRect;
    @NotNull
    private final BlurMaskFilter blurMaskFilter;
    private final float ovalSize;
    @Nullable
    private ValueAnimator progressAnimator;
    private float currentProgress;
    private int currentPart;
    private int totalParts;
    @NotNull
    private Map<Integer, Float> completedProgress;
    private int progressColor;
    private final int backgroundColor;
    private boolean isLastStepInProgress;
    private boolean isAnimating;

    @JvmOverloads
    public OvalLivenessOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        OvalLivenessOverlayView ovalLivenessOverlayView;
        BlurMaskFilter blurMaskFilter;
        Paint paint;
        OvalLivenessOverlayView ovalLivenessOverlayView2 = ovalLivenessOverlayView3;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        Paint paint2 = new Paint();
        paint2.setStyle(Paint.Style.STROKE);
        paint2.setStrokeWidth(ovalLivenessOverlayView3.dpToPx(2.0f));
        paint2.setAntiAlias(true);
        ovalLivenessOverlayView2.ovalPaint = paint2;
        Context context3 = context = paint;
        super();
        context3.setColor(Color.parseColor((String)"#BF000000"));
        context3.setAntiAlias(true);
        ovalLivenessOverlayView3.overlayPaint = context3;
        Paint paint3 = new Paint();
        paint3.setStyle(Paint.Style.FILL);
        paint3.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        paint3.setAntiAlias(true);
        ovalLivenessOverlayView3.clearPaint = paint3;
        ovalLivenessOverlayView3.ovalRect = new RectF();
        OvalLivenessOverlayView ovalLivenessOverlayView3 = blurMaskFilter;
        ovalLivenessOverlayView.blurMaskFilter = new BlurMaskFilter(20.0f, BlurMaskFilter.Blur.NORMAL);
        ovalLivenessOverlayView.ovalSize = ovalLivenessOverlayView.dpToPx(250.0f);
        ovalLivenessOverlayView.currentPart = 1;
        ovalLivenessOverlayView.totalParts = 2;
        ovalLivenessOverlayView.completedProgress = new LinkedHashMap<Integer, Float>();
        ovalLivenessOverlayView.progressColor = -16711936;
        ovalLivenessOverlayView.backgroundColor = -3355444;
        paint.setMaskFilter((MaskFilter)ovalLivenessOverlayView3);
        ovalLivenessOverlayView2.setLayerType(2, null);
    }

    public /* synthetic */ OvalLivenessOverlayView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void startAnim(long l, Function0<Unit> function0) {
        ValueAnimator valueAnimator = this.progressAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        OvalLivenessOverlayView ovalLivenessOverlayView = this;
        ValueAnimator valueAnimator2 = valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator2.setDuration(l);
        valueAnimator2.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        valueAnimator.addUpdateListener(arg_0 -> OvalLivenessOverlayView.startAnim$lambda$4$lambda$3(this, arg_0));
        valueAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, function0){
            public final /* synthetic */ OvalLivenessOverlayView this$0;
            public final /* synthetic */ Function0<Unit> $onAnimationEnd;
            {
                this.this$0 = ovalLivenessOverlayView;
                this.$onAnimationEnd = function0;
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                Function0<Unit> function0 = function02;
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
                OvalLivenessOverlayView.access$getCompletedProgress$p(function0.this$0).put(OvalLivenessOverlayView.access$getCurrentPart$p(function02.this$0), Float.valueOf(1.0f));
                OvalLivenessOverlayView.access$setAnimating$p(function0.this$0, false);
                Function0<Unit> function02 = function0.$onAnimationEnd;
                if (function02 != null) {
                    function02.invoke();
                }
            }
        });
        valueAnimator.start();
        ovalLivenessOverlayView.isAnimating = true;
        ovalLivenessOverlayView.progressAnimator = valueAnimator;
    }

    public static /* synthetic */ void startAnim$default(OvalLivenessOverlayView ovalLivenessOverlayView, long l, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            l = 2000L;
        }
        if ((n & 2) != 0) {
            function0 = null;
        }
        ovalLivenessOverlayView.startAnim(l, (Function0<Unit>)function0);
    }

    public static /* synthetic */ void nextPart$default(OvalLivenessOverlayView ovalLivenessOverlayView, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 600L;
        }
        ovalLivenessOverlayView.nextPart(l);
    }

    public static /* synthetic */ void progressFail$default(OvalLivenessOverlayView ovalLivenessOverlayView, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 2000L;
        }
        ovalLivenessOverlayView.progressFail(l);
    }

    private final int interpolateColor(int n, int n2, float f2) {
        int n3 = n;
        int n4 = Color.alpha((int)n3);
        n = Color.red((int)n3);
        int n5 = Color.green((int)n3);
        int n6 = Color.blue((int)n3);
        int n7 = Color.alpha((int)n2);
        int n8 = n4;
        int n9 = n2;
        n4 = Color.red((int)n9);
        n2 = Color.green((int)n9);
        int n10 = Color.blue((int)n9);
        float f3 = n8;
        int n11 = n6;
        int n12 = n5;
        int n13 = n;
        float f4 = n13;
        int n14 = (int)((float)(n4 - n13) * f2 + f4);
        float f5 = n12;
        int n15 = (int)((float)(n2 - n12) * f2 + f5);
        float f6 = n11;
        int n16 = (int)((float)(n10 - n11) * f2 + f6);
        return Color.argb((int)((int)((float)(n7 - n8) * f2 + f3)), (int)n14, (int)n15, (int)n16);
    }

    private final float dpToPx(float f2) {
        return f2 * this.getContext().getResources().getDisplayMetrics().density;
    }

    @JvmOverloads
    public OvalLivenessOverlayView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public OvalLivenessOverlayView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void startAnim$lambda$4$lambda$3(OvalLivenessOverlayView ovalLivenessOverlayView, ValueAnimator valueAnimator) {
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkNotNullParameter((Object)((Object)ovalLivenessOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator2, (String)"animator");
        Object object = valueAnimator2.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        ovalLivenessOverlayView.currentProgress = ((Float)object).floatValue();
        ovalLivenessOverlayView.invalidate();
    }

    private static final void startSuccessAnimation$lambda$6$lambda$5(OvalLivenessOverlayView ovalLivenessOverlayView, ValueAnimator valueAnimator) {
        OvalLivenessOverlayView ovalLivenessOverlayView2 = ovalLivenessOverlayView;
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkNotNullParameter((Object)((Object)ovalLivenessOverlayView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator2, (String)"animator");
        Object object = valueAnimator2.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        float f2 = ((Float)object).floatValue();
        ovalLivenessOverlayView2.progressColor = ovalLivenessOverlayView2.interpolateColor(-256, -16711936, f2);
        ovalLivenessOverlayView2.invalidate();
    }

    public static final /* synthetic */ int access$getCurrentPart$p(OvalLivenessOverlayView ovalLivenessOverlayView) {
        return ovalLivenessOverlayView.currentPart;
    }

    public static final /* synthetic */ int access$getTotalParts$p(OvalLivenessOverlayView ovalLivenessOverlayView) {
        return ovalLivenessOverlayView.totalParts;
    }

    public static final /* synthetic */ void access$setCurrentPart$p(OvalLivenessOverlayView ovalLivenessOverlayView, int n) {
        ovalLivenessOverlayView.currentPart = n;
    }

    public static final /* synthetic */ void access$setCurrentProgress$p(OvalLivenessOverlayView ovalLivenessOverlayView, float f2) {
        ovalLivenessOverlayView.currentProgress = f2;
    }

    public static final /* synthetic */ void access$setLastStepInProgress$p(OvalLivenessOverlayView ovalLivenessOverlayView, boolean bl) {
        ovalLivenessOverlayView.isLastStepInProgress = bl;
    }

    public static final /* synthetic */ Map access$getCompletedProgress$p(OvalLivenessOverlayView ovalLivenessOverlayView) {
        return ovalLivenessOverlayView.completedProgress;
    }

    public static final /* synthetic */ void access$setAnimating$p(OvalLivenessOverlayView ovalLivenessOverlayView, boolean bl) {
        ovalLivenessOverlayView.isAnimating = bl;
    }

    public void onDraw(@NotNull Canvas canvas) {
        OvalLivenessOverlayView ovalLivenessOverlayView = this;
        OvalLivenessOverlayView ovalLivenessOverlayView2 = this;
        OvalLivenessOverlayView ovalLivenessOverlayView3 = this;
        OvalLivenessOverlayView ovalLivenessOverlayView4 = this;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.onDraw(canvas2);
        float f2 = ovalLivenessOverlayView4.getWidth();
        float f3 = ovalLivenessOverlayView4.getHeight();
        Paint paint = ovalLivenessOverlayView4.overlayPaint;
        canvas.drawRect(0.0f, 0.0f, f2, f3, paint);
        f2 = (float)ovalLivenessOverlayView3.getWidth() / 2.0f;
        f3 = (float)ovalLivenessOverlayView3.getHeight() / 2.0f;
        float f4 = ovalLivenessOverlayView3.ovalSize;
        float f5 = f4 * 1.3f;
        float f6 = f3;
        float f7 = f2;
        float f8 = f3;
        float f9 = f2;
        f2 = 2;
        f3 = f4 / f2;
        f4 = f9 - f3;
        f2 = f5 / f2;
        f5 = f8 - f2;
        f3 = f7 + f3;
        f2 = f6 + f2;
        ovalLivenessOverlayView3.ovalRect.set(f4, f5, f3, f2);
        RectF rectF = ovalLivenessOverlayView3.ovalRect;
        canvas.drawOval(rectF, ovalLivenessOverlayView3.clearPaint);
        ovalLivenessOverlayView2.ovalPaint.setColor(this.backgroundColor);
        ovalLivenessOverlayView2.ovalPaint.setStyle(Paint.Style.STROKE);
        ovalLivenessOverlayView2.ovalPaint.setStrokeWidth(this.dpToPx(2.0f));
        rectF = ovalLivenessOverlayView2.ovalRect;
        canvas.drawOval(rectF, ovalLivenessOverlayView2.ovalPaint);
        ovalLivenessOverlayView.ovalPaint.setColor(this.progressColor);
        ovalLivenessOverlayView.ovalPaint.setStyle(Paint.Style.STROKE);
        ovalLivenessOverlayView.ovalPaint.setStrokeWidth(this.dpToPx(2.0f));
        float f10 = 360.0f / (float)ovalLivenessOverlayView.totalParts;
        int n = ovalLivenessOverlayView.currentPart;
        for (int k = 1; k < n; ++k) {
            OvalLivenessOverlayView ovalLivenessOverlayView5 = this;
            f5 = (float)(k - 1) * f10 + -90.0f;
            RectF rectF2 = ovalLivenessOverlayView5.ovalRect;
            Paint paint2 = ovalLivenessOverlayView5.ovalPaint;
            canvas.drawArc(rectF2, f5, f10, false, paint2);
        }
        OvalLivenessOverlayView ovalLivenessOverlayView6 = this;
        float f11 = (float)(ovalLivenessOverlayView6.currentPart - 1) * f10 + -90.0f;
        float f12 = ovalLivenessOverlayView6.currentProgress * f10;
        RectF rectF3 = ovalLivenessOverlayView6.ovalRect;
        Paint paint3 = ovalLivenessOverlayView6.ovalPaint;
        canvas.drawArc(rectF3, f11, f12, false, paint3);
    }

    public final void nextPart(long l) {
        int n = this.currentPart;
        int n2 = this.totalParts;
        if (n <= n2) {
            Function0<Unit> function0;
            if (n == n2 && this.isLastStepInProgress) {
                return;
            }
            this.progressColor = -16711936;
            if (n == n2) {
                this.startSuccessAnimation();
                this.isLastStepInProgress = true;
            }
            Function0<Unit> function02 = function0;
            function0 = new Function0<Unit>(this){
                public final /* synthetic */ OvalLivenessOverlayView this$0;
                {
                    this.this$0 = ovalLivenessOverlayView;
                    super(0);
                }

                public final void invoke() {
                    if (OvalLivenessOverlayView.access$getCurrentPart$p(this.this$0) < OvalLivenessOverlayView.access$getTotalParts$p(this.this$0)) {
                        nextPart.1 v0 = this;
                        OvalLivenessOverlayView ovalLivenessOverlayView = v0.this$0;
                        OvalLivenessOverlayView.access$setCurrentPart$p(ovalLivenessOverlayView, OvalLivenessOverlayView.access$getCurrentPart$p(ovalLivenessOverlayView) + 1);
                        OvalLivenessOverlayView.access$setCurrentProgress$p(v0.this$0, 0.0f);
                    }
                    if (OvalLivenessOverlayView.access$getCurrentPart$p(this.this$0) == OvalLivenessOverlayView.access$getTotalParts$p(this.this$0)) {
                        OvalLivenessOverlayView.access$setLastStepInProgress$p(this.this$0, false);
                    }
                }
            };
            this.startAnim(l, function02);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setLivenessVersion(@NotNull Common.LIVENESS_VERSION lIVENESS_VERSION) {
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION), (String)"version");
        int n = WhenMappings.$EnumSwitchMapping$0[lIVENESS_VERSION.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new NoWhenBranchMatchedException();
                n = 3;
            } else {
                n = 2;
            }
        } else {
            n = 1;
        }
        OvalLivenessOverlayView ovalLivenessOverlayView = this;
        ovalLivenessOverlayView.totalParts = n;
        ovalLivenessOverlayView.currentPart = 1;
        ovalLivenessOverlayView.completedProgress.clear();
        ovalLivenessOverlayView.stopProgress();
    }

    public final void progressFail(long l) {
        this.progressColor = -65536;
        this.currentPart = 0;
        this.totalParts = 1;
        this.completedProgress.clear();
        this.isLastStepInProgress = false;
        OvalLivenessOverlayView.startAnim$default(this, l, null, 2, null);
    }

    public final void stopProgress() {
        ValueAnimator valueAnimator = this.progressAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        this.currentProgress = 0.0f;
        this.isAnimating = false;
        this.invalidate();
    }

    public final void resetProgress() {
        ValueAnimator valueAnimator = this.progressAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        OvalLivenessOverlayView ovalLivenessOverlayView = this;
        ovalLivenessOverlayView.currentProgress = 0.0f;
        ovalLivenessOverlayView.currentPart = 1;
        ovalLivenessOverlayView.progressColor = -16711936;
        ovalLivenessOverlayView.isLastStepInProgress = false;
        ovalLivenessOverlayView.completedProgress.clear();
        ovalLivenessOverlayView.isAnimating = false;
        ovalLivenessOverlayView.invalidate();
    }

    public final void startSuccessAnimation() {
        if (!this.isAnimating) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            valueAnimator.setDuration(500L);
            valueAnimator.addUpdateListener(arg_0 -> OvalLivenessOverlayView.startSuccessAnimation$lambda$6$lambda$5(this, arg_0));
            valueAnimator.start();
        }
    }

    public void onDetachedFromWindow() {
        OvalLivenessOverlayView ovalLivenessOverlayView = ovalLivenessOverlayView2;
        super.onDetachedFromWindow();
        OvalLivenessOverlayView ovalLivenessOverlayView2 = ovalLivenessOverlayView.progressAnimator;
        if (ovalLivenessOverlayView2 != null) {
            ovalLivenessOverlayView2.cancel();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Common.LIVENESS_VERSION.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Common.LIVENESS_VERSION.PASSIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Common.LIVENESS_VERSION.SEMI_ACTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Common.LIVENESS_VERSION.ACTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

