package vn.kalapa.ekyc.handlers

import android.annotation.SuppressLint
import android.content.Context
import android.os.AsyncTask
import android.os.Build
import android.provider.Settings.Secure
import android.util.Base64
import vn.kalapa.ekyc.KalapaSDK
import vn.kalapa.ekyc.models.KalapaLanguageModel
import vn.kalapa.ekyc.utils.CameraUtils
import vn.kalapa.ekyc.utils.Helpers
import java.io.BufferedReader
import java.io.InputStreamReader
import java.lang.ref.WeakReference
import java.net.HttpURLConnection
import java.net.SocketTimeoutException
import java.net.URL
import java.security.MessageDigest


class GetDynamicLanguageHandler(val context: WeakReference<Context>) : AsyncTask<String, Void, KalapaLanguageModel?>() {

    @Deprecated("Deprecated in Java")
    override fun doInBackground(vararg params: String?): KalapaLanguageModel? {
        return if (context.get() != null) {
            try {
                getDynamicLanguage(context.get()!!, params[0]!!, params[1]!!, params[2])?.let { it1 -> KalapaLanguageModel.fromJson(it1) }
            } catch (exception: Exception) {
                null
            }
        } else null
    }
}

private fun getDynamicLanguage(c: Context, baseUrl: String, language: String, customer: String?): String? {
    if (language.isEmpty()) return null
//        val url = URL("$baseUrl/lang/get?language=$language")
    val url = URL("https://ekyc-sdk-sb.kalapa.vn/lang/get?language=$language&type=ekyc_mobile${if (customer.isNullOrEmpty()) "" else "&customer=$customer"}")

    var body = ""
    Helpers.printLog("\nSent 'GET' request to URL : $url language: $language")
    val metadata = HashMap<String, String>()
    metadata[KalapaEmulatorDetection.FINGERPRINT.lowercaseName] = Build.FINGERPRINT // "generic" //
    metadata[KalapaEmulatorDetection.MODEL.lowercaseName] = Build.MODEL
    metadata[KalapaEmulatorDetection.BOARD.lowercaseName] = Build.BOARD
    metadata[KalapaEmulatorDetection.MANUFACTURER.lowercaseName] = Build.MANUFACTURER
    metadata[KalapaEmulatorDetection.UUID.lowercaseName] = getSecureId(c)
    metadata[KalapaEmulatorDetection.HOST.lowercaseName] = Build.HOST
    metadata[KalapaEmulatorDetection.BRAND.lowercaseName] = Build.BRAND
    metadata[KalapaEmulatorDetection.PRODUCT.lowercaseName] = Build.PRODUCT
    metadata[KalapaEmulatorDetection.HARDWARE.lowercaseName] = Build.HARDWARE
    metadata[KalapaEmulatorDetection.VERSION_RELEASE.lowercaseName] = Build.VERSION.RELEASE
    metadata[KalapaEmulatorDetection.VERSION_OS.lowercaseName] = Build.VERSION.SDK_INT.toString()
    metadata[KalapaEmulatorDetection.VERSION_SDK.lowercaseName] = KalapaSDK.getSDKVersion()
    metadata[KalapaEmulatorDetection.DISPLAY.lowercaseName] = Build.DISPLAY
    metadata[KalapaEmulatorDetection.CAMERA_CHARACTERISTICS.lowercaseName] = CameraUtils.listToString(CameraUtils.listCameraCharacteristics(c))
    Helpers.printLog("metadata[KalapaEmulatorDetection.CAMERA_CHARACTERISTICS.lowercaseName] ${metadata[KalapaEmulatorDetection.CAMERA_CHARACTERISTICS.lowercaseName]}")
    Helpers.printLog("\nSent 'GET' request to URL : $metadata")
    val v9337 = Base64.encodeToString(metadata.toString().toByteArray(), Base64.DEFAULT).replace("\n", "")

    Helpers.printLog("\nSent 'GET' request to device_model: ${Build.MODEL} device_id ${metadata[KalapaEmulatorDetection.UUID.lowercaseName]} v9337 : $v9337")
    return try {
        with(url.openConnection() as HttpURLConnection) {
            requestMethod = "GET"
            setRequestProperty("p93337", v9337)
            setRequestProperty("x-metadata", v9337)
            setRequestProperty("x-device-id", getSecureId(c))
            setRequestProperty("x-device-model", Build.MODEL)
            connectTimeout = 10_000  // 10 seconds timeout for connection
            readTimeout = 10_000  // 10 seconds timeout for reading response
            connect()
            if (responseCode == 200) {
                val reader = BufferedReader(InputStreamReader(inputStream))
                body = reader.readText()
                reader.close()
                Helpers.printLog("Response Body: $body")
            } else {
                Helpers.printLog("GET request not worked")
            }
        }
        body.ifEmpty { null }
    } catch (e: SocketTimeoutException) {
        Helpers.printLog("getDynamicLanguage Timeout occurred while fetching data. ${e.message} Returning null.")
        null
    } catch (e: Exception) {
        Helpers.printLog("getDynamicLanguage Exception: ${e.message}")
        null
    }
}

@SuppressLint("HardwareIds")
private fun getSecureId(context: Context): String {
    val secureId = Secure.getString(context.contentResolver, Secure.ANDROID_ID)
    return md5Hash(secureId)
}

private fun md5Hash(input: String): String {
    val md = MessageDigest.getInstance("MD5")
    val digest = md.digest(input.toByteArray(Charsets.UTF_8))
    return digest.joinToString("") { "%02x".format(it) } // Convert to hex string
}

enum class KalapaEmulatorDetection(val lowercaseName: String) {
    VIRTUAL_CAMERA("virtual_camera"),
    FINGERPRINT("fingerprint"),
    MODEL("model"),
    BOARD("board"),
    MANUFACTURER("manufacturer"),
    HOST("host"),
    BRAND("brand"),
    PRODUCT("product"),
    HARDWARE("hardware"),
    DEVICE_ID("device_id"),
    VERSION_RELEASE("version_release"),
    VERSION_OS("version_os"),
    VERSION_SDK("version_sdk"),
    DISPLAY("display"),
    CAMERA_CHARACTERISTICS("camera_characteristic"),
    UUID("uuid")
}
