/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.CertOrEncCert;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.EncryptedKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.EncryptedValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.PKIPublicationInfo;

public class CertifiedKeyPair
extends ASN1Object {
    private CertOrEncCert certOrEncCert;
    private EncryptedKey privateKey;
    private PKIPublicationInfo publicationInfo;

    private CertifiedKeyPair(ASN1Sequence aSN1Primitive) {
        this.certOrEncCert = CertOrEncCert.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(0));
        if (((ASN1Sequence)aSN1Primitive).size() >= 2) {
            if (((ASN1Sequence)aSN1Primitive).size() == 2) {
                if (((ASN1TaggedObject)(aSN1Primitive = ASN1TaggedObject.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(1)))).getTagNo() == 0) {
                    this.privateKey = EncryptedKey.getInstance(((ASN1TaggedObject)aSN1Primitive).getObject());
                } else {
                    this.publicationInfo = PKIPublicationInfo.getInstance(((ASN1TaggedObject)aSN1Primitive).getObject());
                }
            } else {
                this.privateKey = EncryptedKey.getInstance(ASN1TaggedObject.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(1)).getObject());
                this.publicationInfo = PKIPublicationInfo.getInstance(ASN1TaggedObject.getInstance(((ASN1Sequence)aSN1Primitive).getObjectAt(2)).getObject());
            }
        }
    }

    public static CertifiedKeyPair getInstance(Object object) {
        if (object instanceof CertifiedKeyPair) {
            return (CertifiedKeyPair)object;
        }
        if (object != null) {
            return new CertifiedKeyPair(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public CertifiedKeyPair(CertOrEncCert certOrEncCert) {
        this(certOrEncCert, (EncryptedKey)null, (PKIPublicationInfo)null);
    }

    public CertifiedKeyPair(CertOrEncCert certOrEncCert, EncryptedKey encryptedKey, PKIPublicationInfo pKIPublicationInfo) {
        if (certOrEncCert != null) {
            CertifiedKeyPair certifiedKeyPair = this;
            certifiedKeyPair.certOrEncCert = certOrEncCert;
            certifiedKeyPair.privateKey = encryptedKey;
            certifiedKeyPair.publicationInfo = pKIPublicationInfo;
            return;
        }
        throw new IllegalArgumentException("'certOrEncCert' cannot be null");
    }

    public CertifiedKeyPair(CertOrEncCert aSN1Object, EncryptedValue encryptedValue, PKIPublicationInfo pKIPublicationInfo) {
        if (aSN1Object != null) {
            this.certOrEncCert = aSN1Object;
            if (encryptedValue != null) {
                EncryptedKey encryptedKey;
                aSN1Object = encryptedKey;
                encryptedKey = new EncryptedKey(encryptedValue);
            } else {
                aSN1Object = null;
            }
            CertifiedKeyPair certifiedKeyPair = this;
            certifiedKeyPair.privateKey = aSN1Object;
            certifiedKeyPair.publicationInfo = pKIPublicationInfo;
            return;
        }
        throw new IllegalArgumentException("'certOrEncCert' cannot be null");
    }

    public CertOrEncCert getCertOrEncCert() {
        return this.certOrEncCert;
    }

    public EncryptedKey getPrivateKey() {
        return this.privateKey;
    }

    public PKIPublicationInfo getPublicationInfo() {
        return this.publicationInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        PKIPublicationInfo pKIPublicationInfo;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector.add(this.certOrEncCert);
        ASN1Object aSN1Object = this.privateKey;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, 0, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        if ((pKIPublicationInfo = this.publicationInfo) != null) {
            DERTaggedObject dERTaggedObject;
            aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, 1, pKIPublicationInfo);
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

