/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.InfoTypeAndValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIFreeText;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIHeader;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;

public class PKIHeaderBuilder {
    private ASN1Integer pvno;
    private GeneralName sender;
    private GeneralName recipient;
    private ASN1GeneralizedTime messageTime;
    private AlgorithmIdentifier protectionAlg;
    private ASN1OctetString senderKID;
    private ASN1OctetString recipKID;
    private ASN1OctetString transactionID;
    private ASN1OctetString senderNonce;
    private ASN1OctetString recipNonce;
    private PKIFreeText freeText;
    private ASN1Sequence generalInfo;

    public PKIHeaderBuilder(int n, GeneralName generalName, GeneralName generalName2) {
        this(new ASN1Integer(n), generalName, generalName2);
    }

    private PKIHeaderBuilder(ASN1Integer aSN1Integer, GeneralName generalName, GeneralName generalName2) {
        this.pvno = aSN1Integer;
        this.sender = generalName;
        this.recipient = generalName2;
    }

    private static ASN1Sequence makeGeneralInfoSeq(InfoTypeAndValue infoTypeAndValue) {
        return new DERSequence(infoTypeAndValue);
    }

    private static ASN1Sequence makeGeneralInfoSeq(InfoTypeAndValue[] infoTypeAndValueArray) {
        DERSequence dERSequence = null;
        if (infoTypeAndValueArray != null) {
            DERSequence dERSequence2;
            dERSequence = dERSequence2;
            dERSequence2 = new DERSequence(infoTypeAndValueArray);
        }
        return dERSequence;
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, n, aSN1Encodable);
            aSN1EncodableVector.add(dERTaggedObject2);
        }
    }

    public PKIHeaderBuilder setMessageTime(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.messageTime = aSN1GeneralizedTime;
        return this;
    }

    public PKIHeaderBuilder setProtectionAlg(AlgorithmIdentifier algorithmIdentifier) {
        this.protectionAlg = algorithmIdentifier;
        return this;
    }

    public PKIHeaderBuilder setSenderKID(byte[] object) {
        if (object == null) {
            object = null;
        } else {
            DEROctetString dEROctetString;
            DEROctetString dEROctetString2 = dEROctetString;
            dEROctetString = new DEROctetString((byte[])object);
            object = dEROctetString2;
        }
        return this.setSenderKID((ASN1OctetString)object);
    }

    public PKIHeaderBuilder setSenderKID(ASN1OctetString aSN1OctetString) {
        this.senderKID = aSN1OctetString;
        return this;
    }

    public PKIHeaderBuilder setRecipKID(byte[] object) {
        if (object == null) {
            object = null;
        } else {
            DEROctetString dEROctetString;
            DEROctetString dEROctetString2 = dEROctetString;
            dEROctetString = new DEROctetString((byte[])object);
            object = dEROctetString2;
        }
        return this.setRecipKID((ASN1OctetString)object);
    }

    public PKIHeaderBuilder setRecipKID(ASN1OctetString aSN1OctetString) {
        this.recipKID = aSN1OctetString;
        return this;
    }

    public PKIHeaderBuilder setTransactionID(byte[] object) {
        if (object == null) {
            object = null;
        } else {
            DEROctetString dEROctetString;
            DEROctetString dEROctetString2 = dEROctetString;
            dEROctetString = new DEROctetString((byte[])object);
            object = dEROctetString2;
        }
        return this.setTransactionID((ASN1OctetString)object);
    }

    public PKIHeaderBuilder setTransactionID(ASN1OctetString aSN1OctetString) {
        this.transactionID = aSN1OctetString;
        return this;
    }

    public PKIHeaderBuilder setSenderNonce(byte[] object) {
        if (object == null) {
            object = null;
        } else {
            DEROctetString dEROctetString;
            DEROctetString dEROctetString2 = dEROctetString;
            dEROctetString = new DEROctetString((byte[])object);
            object = dEROctetString2;
        }
        return this.setSenderNonce((ASN1OctetString)object);
    }

    public PKIHeaderBuilder setSenderNonce(ASN1OctetString aSN1OctetString) {
        this.senderNonce = aSN1OctetString;
        return this;
    }

    public PKIHeaderBuilder setRecipNonce(byte[] object) {
        if (object == null) {
            object = null;
        } else {
            DEROctetString dEROctetString;
            DEROctetString dEROctetString2 = dEROctetString;
            dEROctetString = new DEROctetString((byte[])object);
            object = dEROctetString2;
        }
        return this.setRecipNonce((ASN1OctetString)object);
    }

    public PKIHeaderBuilder setRecipNonce(ASN1OctetString aSN1OctetString) {
        this.recipNonce = aSN1OctetString;
        return this;
    }

    public PKIHeaderBuilder setFreeText(PKIFreeText pKIFreeText) {
        this.freeText = pKIFreeText;
        return this;
    }

    public PKIHeaderBuilder setGeneralInfo(InfoTypeAndValue infoTypeAndValue) {
        return this.setGeneralInfo(PKIHeaderBuilder.makeGeneralInfoSeq(infoTypeAndValue));
    }

    public PKIHeaderBuilder setGeneralInfo(InfoTypeAndValue[] infoTypeAndValueArray) {
        return this.setGeneralInfo(PKIHeaderBuilder.makeGeneralInfoSeq(infoTypeAndValueArray));
    }

    public PKIHeaderBuilder setGeneralInfo(ASN1Sequence aSN1Sequence) {
        this.generalInfo = aSN1Sequence;
        return this;
    }

    public PKIHeader build() {
        ASN1EncodableVector aSN1EncodableVector;
        PKIHeaderBuilder pKIHeaderBuilder = object;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(12);
        aSN1EncodableVector2.add(((PKIHeaderBuilder)object).pvno);
        aSN1EncodableVector2.add(((PKIHeaderBuilder)object).sender);
        aSN1EncodableVector.add(((PKIHeaderBuilder)object).recipient);
        Object object = pKIHeaderBuilder.messageTime;
        pKIHeaderBuilder.addOptional(aSN1EncodableVector2, 0, (ASN1Encodable)object);
        object = pKIHeaderBuilder.protectionAlg;
        pKIHeaderBuilder.addOptional(aSN1EncodableVector2, 1, (ASN1Encodable)object);
        object = pKIHeaderBuilder.senderKID;
        pKIHeaderBuilder.addOptional(aSN1EncodableVector2, 2, (ASN1Encodable)object);
        object = pKIHeaderBuilder.recipKID;
        pKIHeaderBuilder.addOptional(aSN1EncodableVector2, 3, (ASN1Encodable)object);
        object = pKIHeaderBuilder.transactionID;
        pKIHeaderBuilder.addOptional(aSN1EncodableVector2, 4, (ASN1Encodable)object);
        object = pKIHeaderBuilder.senderNonce;
        pKIHeaderBuilder.addOptional(aSN1EncodableVector2, 5, (ASN1Encodable)object);
        object = pKIHeaderBuilder.recipNonce;
        pKIHeaderBuilder.addOptional(aSN1EncodableVector2, 6, (ASN1Encodable)object);
        object = pKIHeaderBuilder.freeText;
        pKIHeaderBuilder.addOptional(aSN1EncodableVector2, 7, (ASN1Encodable)object);
        object = pKIHeaderBuilder.generalInfo;
        pKIHeaderBuilder.addOptional(aSN1EncodableVector2, 8, (ASN1Encodable)object);
        pKIHeaderBuilder.messageTime = null;
        pKIHeaderBuilder.protectionAlg = null;
        pKIHeaderBuilder.senderKID = null;
        pKIHeaderBuilder.recipKID = null;
        pKIHeaderBuilder.transactionID = null;
        pKIHeaderBuilder.senderNonce = null;
        pKIHeaderBuilder.recipNonce = null;
        pKIHeaderBuilder.freeText = null;
        pKIHeaderBuilder.generalInfo = null;
        return PKIHeader.getInstance(new DERSequence(aSN1EncodableVector2));
    }
}

