/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.esf;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1UTCTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import java.math.BigInteger;

public class CrlIdentifier
extends ASN1Object {
    private X500Name crlIssuer;
    private ASN1UTCTime crlIssuedTime;
    private ASN1Integer crlNumber;

    public static CrlIdentifier getInstance(Object object) {
        if (object instanceof CrlIdentifier) {
            return (CrlIdentifier)object;
        }
        if (object != null) {
            return new CrlIdentifier(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private CrlIdentifier(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 2 && aSN1Sequence.size() <= 3) {
            this.crlIssuer = X500Name.getInstance(aSN1Sequence.getObjectAt(0));
            this.crlIssuedTime = ASN1UTCTime.getInstance(aSN1Sequence.getObjectAt(1));
            if (aSN1Sequence.size() > 2) {
                this.crlNumber = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(2));
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    public CrlIdentifier(X500Name x500Name, ASN1UTCTime aSN1UTCTime) {
        this(x500Name, aSN1UTCTime, null);
    }

    public CrlIdentifier(X500Name x500Name, ASN1UTCTime aSN1UTCTime, BigInteger bigInteger) {
        aSN1Object.crlIssuer = x500Name;
        aSN1Object.crlIssuedTime = aSN1UTCTime;
        if (bigInteger != null) {
            ASN1Integer aSN1Integer;
            CrlIdentifier crlIdentifier = aSN1Object;
            ASN1Object aSN1Object = aSN1Integer;
            aSN1Integer = new ASN1Integer(bigInteger);
            crlIdentifier.crlNumber = aSN1Object;
        }
    }

    public X500Name getCrlIssuer() {
        return this.crlIssuer;
    }

    public ASN1UTCTime getCrlIssuedTime() {
        return this.crlIssuedTime;
    }

    public BigInteger getCrlNumber() {
        ASN1Object aSN1Object = ((CrlIdentifier)aSN1Object).crlNumber;
        if (aSN1Object == null) {
            return null;
        }
        return ((ASN1Integer)aSN1Object).getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector2.add(aSN1Object.crlIssuer.toASN1Primitive());
        aSN1EncodableVector.add(aSN1Object.crlIssuedTime);
        ASN1Object aSN1Object = aSN1Object.crlNumber;
        if (aSN1Object != null) {
            aSN1EncodableVector2.add(aSN1Object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

