/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isismtt.x509;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERPrintableString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.DirectoryString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.IssuerSerial;

public class ProcurationSyntax
extends ASN1Object {
    private String country;
    private DirectoryString typeOfSubstitution;
    private GeneralName thirdPerson;
    private IssuerSerial certRef;

    public static ProcurationSyntax getInstance(Object object) {
        if (object != null && !(object instanceof ProcurationSyntax)) {
            if (object instanceof ASN1Sequence) {
                return new ProcurationSyntax((ASN1Sequence)object);
            }
            throw new IllegalArgumentException(c.a(object, b.b.a("illegal object in getInstance: ")));
        }
        return (ProcurationSyntax)object;
    }

    private ProcurationSyntax(ASN1Sequence object) {
        if (((ASN1Sequence)object).size() >= 1 && ((ASN1Sequence)object).size() <= 3) {
            object = ((ASN1Sequence)object).getObjects();
            while (object.hasMoreElements()) {
                ASN1Primitive aSN1Primitive = ASN1TaggedObject.getInstance(object.nextElement());
                int n = aSN1Primitive.getTagNo();
                if (n != 1) {
                    if (n != 2) {
                        if (n == 3) {
                            if ((aSN1Primitive = aSN1Primitive.getObject()) instanceof ASN1TaggedObject) {
                                this.thirdPerson = GeneralName.getInstance(aSN1Primitive);
                                continue;
                            }
                            this.certRef = IssuerSerial.getInstance(aSN1Primitive);
                            continue;
                        }
                        throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a(aSN1Primitive, b.b.a("Bad tag number: ")));
                    }
                    this.typeOfSubstitution = DirectoryString.getInstance(aSN1Primitive, true);
                    continue;
                }
                this.country = DERPrintableString.getInstance(aSN1Primitive, true).getString();
            }
            return;
        }
        throw new IllegalArgumentException(b.a((ASN1Sequence)object, b.b.a("Bad sequence size: ")));
    }

    public ProcurationSyntax(String string, DirectoryString directoryString, IssuerSerial issuerSerial) {
        this.country = string;
        this.typeOfSubstitution = directoryString;
        this.thirdPerson = null;
        this.certRef = issuerSerial;
    }

    public ProcurationSyntax(String string, DirectoryString directoryString, GeneralName generalName) {
        this.country = string;
        this.typeOfSubstitution = directoryString;
        this.thirdPerson = generalName;
        this.certRef = null;
    }

    public String getCountry() {
        return this.country;
    }

    public DirectoryString getTypeOfSubstitution() {
        return this.typeOfSubstitution;
    }

    public GeneralName getThirdPerson() {
        return this.thirdPerson;
    }

    public IssuerSerial getCertRef() {
        return this.certRef;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Object aSN1Object;
        DERTaggedObject dERTaggedObject;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(3);
        Object object = aSN1Object.country;
        if (object != null) {
            DERPrintableString dERPrintableString;
            DERTaggedObject dERTaggedObject2;
            dERTaggedObject = dERTaggedObject2;
            DERPrintableString dERPrintableString2 = dERPrintableString;
            dERPrintableString = new DERPrintableString((String)object, true);
            dERTaggedObject2 = new DERTaggedObject(true, 1, dERPrintableString2);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((object = aSN1Object.typeOfSubstitution) != null) {
            DERTaggedObject dERTaggedObject3;
            dERTaggedObject = dERTaggedObject3;
            dERTaggedObject3 = new DERTaggedObject(true, 2, (ASN1Encodable)object);
            aSN1EncodableVector2.add(dERTaggedObject);
        }
        if ((object = aSN1Object.thirdPerson) != null) {
            DERTaggedObject dERTaggedObject4;
            aSN1Object = dERTaggedObject4;
            dERTaggedObject4 = new DERTaggedObject(true, 3, (ASN1Encodable)object);
            aSN1EncodableVector2.add(aSN1Object);
        } else {
            DERTaggedObject dERTaggedObject5;
            object = dERTaggedObject5;
            aSN1Object = aSN1Object.certRef;
            dERTaggedObject5 = new DERTaggedObject(true, 3, aSN1Object);
            aSN1EncodableVector2.add((ASN1Encodable)object);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

