/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AccessDescription;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;

public class AuthorityInformationAccess
extends ASN1Object {
    private AccessDescription[] descriptions;

    private static AccessDescription[] copy(AccessDescription[] accessDescriptionArray) {
        AccessDescription[] accessDescriptionArray2 = new AccessDescription[accessDescriptionArray.length];
        int n = accessDescriptionArray.length;
        System.arraycopy(accessDescriptionArray, 0, accessDescriptionArray2, 0, n);
        return accessDescriptionArray2;
    }

    public static AuthorityInformationAccess getInstance(Object object) {
        if (object instanceof AuthorityInformationAccess) {
            return (AuthorityInformationAccess)object;
        }
        if (object != null) {
            return new AuthorityInformationAccess(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public static AuthorityInformationAccess fromExtensions(Extensions extensions) {
        return AuthorityInformationAccess.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.authorityInfoAccess));
    }

    private AuthorityInformationAccess(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 1) {
            this.descriptions = new AccessDescription[aSN1Sequence.size()];
            for (int k = 0; k != aSN1Sequence.size(); ++k) {
                this.descriptions[k] = AccessDescription.getInstance(aSN1Sequence.getObjectAt(k));
            }
            return;
        }
        throw new IllegalArgumentException("sequence may not be empty");
    }

    public AuthorityInformationAccess(AccessDescription accessDescription) {
        AccessDescription[] accessDescriptionArray = new AccessDescription[1];
        AccessDescription[] accessDescriptionArray2 = accessDescriptionArray;
        accessDescriptionArray[0] = accessDescription;
        accessDescriptionArray2.descriptions = accessDescriptionArray2;
    }

    public AuthorityInformationAccess(AccessDescription[] accessDescriptionArray) {
        this.descriptions = AuthorityInformationAccess.copy(accessDescriptionArray);
    }

    public AuthorityInformationAccess(ASN1ObjectIdentifier aSN1ObjectIdentifier, GeneralName generalName) {
        AccessDescription accessDescription;
        AuthorityInformationAccess authorityInformationAccess = aSN1Object;
        ASN1Object aSN1Object = accessDescription;
        accessDescription = new AccessDescription(aSN1ObjectIdentifier, generalName);
        authorityInformationAccess((AccessDescription)aSN1Object);
    }

    public AccessDescription[] getAccessDescriptions() {
        return AuthorityInformationAccess.copy(this.descriptions);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.descriptions);
    }

    public String toString() {
        return b.a("AuthorityInformationAccess: Oid(").append(this.descriptions[0].getAccessMethod().getId()).append(")").toString();
    }
}

