/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DataLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.CramerShoupCiphertext;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.CramerShoupKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.CramerShoupPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.CramerShoupPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.math.BigInteger;
import java.security.SecureRandom;

public class CramerShoupCoreEngine {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private CramerShoupKeyParameters key;
    private SecureRandom random;
    private boolean forEncryption;
    private byte[] label = null;

    private BigInteger generateRandomElement(BigInteger bigInteger, SecureRandom secureRandom) {
        BigInteger bigInteger2 = ONE;
        return BigIntegers.createRandomInRange(bigInteger2, bigInteger.subtract(bigInteger2), secureRandom);
    }

    private boolean isValidMessage(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.compareTo(bigInteger2) < 0;
    }

    public void init(boolean bl, CipherParameters cipherParameters, String string) {
        this.init(bl, cipherParameters);
        this.label = Strings.toUTF8ByteArray(string);
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        SecureRandom secureRandom = null;
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.key = (CramerShoupKeyParameters)parametersWithRandom.getParameters();
            secureRandom = parametersWithRandom.getRandom();
        } else {
            this.key = (CramerShoupKeyParameters)cipherParameters;
        }
        this.random = this.initSecureRandom(bl, secureRandom);
        this.forEncryption = bl;
    }

    public int getInputBlockSize() {
        CramerShoupCoreEngine cramerShoupCoreEngine = this;
        int n = cramerShoupCoreEngine.key.getParameters().getP().bitLength();
        if (cramerShoupCoreEngine.forEncryption) {
            return (n + 7) / 8 - 1;
        }
        return (n + 7) / 8;
    }

    public int getOutputBlockSize() {
        CramerShoupCoreEngine cramerShoupCoreEngine = this;
        int n = cramerShoupCoreEngine.key.getParameters().getP().bitLength();
        if (cramerShoupCoreEngine.forEncryption) {
            return (n + 7) / 8;
        }
        return (n + 7) / 8 - 1;
    }

    public BigInteger convertInput(byte[] byArray, int n, int n2) {
        if (n2 <= this.getInputBlockSize() + 1) {
            BigInteger bigInteger;
            if (n2 == this.getInputBlockSize() + 1 && this.forEncryption) {
                throw new DataLengthException("input too large for Cramer Shoup cipher.");
            }
            if (n != 0 || n2 != byArray.length) {
                byte[] byArray2 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray2, n, byArray, 0, n2);
            }
            BigInteger bigInteger2 = bigInteger;
            bigInteger2(1, byArray);
            if (bigInteger.compareTo(this.key.getParameters().getP()) < 0) {
                return bigInteger2;
            }
            throw new DataLengthException("input too large for Cramer Shoup cipher.");
        }
        throw new DataLengthException("input too large for Cramer Shoup cipher.");
    }

    public byte[] convertOutput(BigInteger object) {
        object = ((BigInteger)object).toByteArray();
        if (!this.forEncryption) {
            if (object[0] == false && ((Object)object).length > this.getOutputBlockSize()) {
                int n = ((Object)object).length - 1;
                byte[] byArray = new byte[n];
                System.arraycopy(object, 1, byArray, 0, n);
                return byArray;
            }
            if (((Object)object).length < this.getOutputBlockSize()) {
                int n = this.getOutputBlockSize();
                byte[] byArray = new byte[n];
                Object object2 = object;
                int n2 = ((Object)object2).length;
                System.arraycopy(object2, 0, byArray, n -= ((Object)object).length, n2);
                return byArray;
            }
        } else if (object[0] == false) {
            int n = ((Object)object).length - 1;
            byte[] byArray = new byte[n];
            System.arraycopy(object, 1, byArray, 0, n);
            return byArray;
        }
        return object;
    }

    public CramerShoupCiphertext encryptBlock(BigInteger bigInteger) {
        Object object;
        Object object2 = null;
        if (!((CramerShoupCoreEngine)object5).key.isPrivate() && ((CramerShoupCoreEngine)object5).forEncryption && (object = ((CramerShoupCoreEngine)object5).key) instanceof CramerShoupPublicKeyParameters) {
            CramerShoupCiphertext cramerShoupCiphertext;
            BigInteger bigInteger2;
            object = (CramerShoupPublicKeyParameters)object;
            BigInteger bigInteger3 = ((CramerShoupKeyParameters)object).getParameters().getP();
            BigInteger bigInteger4 = ((CramerShoupKeyParameters)object).getParameters().getG1();
            Object object3 = ((CramerShoupKeyParameters)object).getParameters().getG2();
            Object object4 = ((CramerShoupPublicKeyParameters)object).getH();
            if (!((CramerShoupCoreEngine)object5).isValidMessage(bigInteger, bigInteger3)) {
                return object2;
            }
            CramerShoupCoreEngine cramerShoupCoreEngine = object5;
            Object object5 = ((CramerShoupCoreEngine)object5).generateRandomElement(bigInteger3, ((CramerShoupCoreEngine)object5).random);
            object2 = bigInteger4.modPow((BigInteger)object5, bigInteger3);
            bigInteger4 = ((BigInteger)object3).modPow((BigInteger)object5, bigInteger3);
            bigInteger = ((BigInteger)object4).modPow((BigInteger)object5, bigInteger3).multiply(bigInteger).mod(bigInteger3);
            object3 = ((CramerShoupKeyParameters)object).getParameters().getH();
            byte[] byArray = ((BigInteger)object2).toByteArray();
            object3.update(byArray, 0, byArray.length);
            byte[] byArray2 = bigInteger4.toByteArray();
            object3.update(byArray2, 0, byArray2.length);
            byte[] byArray3 = bigInteger.toByteArray();
            object3.update(byArray3, 0, byArray3.length);
            object4 = cramerShoupCoreEngine.label;
            if (cramerShoupCoreEngine.label != null) {
                int n = ((Object)object4).length;
                object3.update((byte[])object4, 0, n);
            }
            Object object6 = object3;
            byte[] byArray4 = new byte[object6.getDigestSize()];
            object3 = byArray4;
            object6.doFinal(byArray4, 0);
            object4 = bigInteger2;
            bigInteger2 = new BigInteger(1, (byte[])object3);
            object5 = ((CramerShoupPublicKeyParameters)object).getC().modPow((BigInteger)object5, bigInteger3).multiply(((CramerShoupPublicKeyParameters)object).getD().modPow(((BigInteger)object5).multiply((BigInteger)object4), bigInteger3)).mod(bigInteger3);
            object = cramerShoupCiphertext;
            cramerShoupCiphertext = new CramerShoupCiphertext((BigInteger)object2, bigInteger4, bigInteger, (BigInteger)object5);
            object2 = object;
        }
        return object2;
    }

    public BigInteger decryptBlock(CramerShoupCiphertext cramerShoupCiphertext) {
        Object object;
        BigInteger bigInteger = null;
        if (((CramerShoupCoreEngine)((Object)cramerShoupPrivateKeyParameters)).key.isPrivate() && !((CramerShoupCoreEngine)((Object)cramerShoupPrivateKeyParameters)).forEncryption && (object = ((CramerShoupCoreEngine)((Object)cramerShoupPrivateKeyParameters)).key) instanceof CramerShoupPrivateKeyParameters) {
            BigInteger bigInteger2;
            CramerShoupCoreEngine cramerShoupCoreEngine = cramerShoupPrivateKeyParameters;
            CramerShoupPrivateKeyParameters cramerShoupPrivateKeyParameters = (CramerShoupPrivateKeyParameters)object;
            bigInteger = cramerShoupPrivateKeyParameters.getParameters().getP();
            object = cramerShoupPrivateKeyParameters.getParameters().getH();
            byte[] byArray = cramerShoupCiphertext.getU1().toByteArray();
            object.update(byArray, 0, byArray.length);
            byte[] byArray2 = cramerShoupCiphertext.getU2().toByteArray();
            object.update(byArray2, 0, byArray2.length);
            byte[] byArray3 = cramerShoupCiphertext.getE().toByteArray();
            object.update(byArray3, 0, byArray3.length);
            Object object2 = cramerShoupCoreEngine.label;
            if (cramerShoupCoreEngine.label != null) {
                int n = ((byte[])object2).length;
                object.update((byte[])object2, 0, n);
            }
            CramerShoupCiphertext cramerShoupCiphertext2 = cramerShoupCiphertext;
            Object object3 = object;
            byte[] byArray4 = new byte[object3.getDigestSize()];
            object = byArray4;
            object3.doFinal(byArray4, 0);
            object2 = bigInteger2;
            bigInteger2 = new BigInteger(1, (byte[])object);
            object = cramerShoupCiphertext2.u1.modPow(cramerShoupPrivateKeyParameters.getX1().add(cramerShoupPrivateKeyParameters.getY1().multiply((BigInteger)object2)), bigInteger).multiply(cramerShoupCiphertext.u2.modPow(cramerShoupPrivateKeyParameters.getX2().add(cramerShoupPrivateKeyParameters.getY2().multiply((BigInteger)object2)), bigInteger)).mod(bigInteger);
            if (cramerShoupCiphertext2.v.equals(object)) {
                bigInteger = cramerShoupCiphertext.e.multiply(cramerShoupCiphertext.u1.modPow(cramerShoupPrivateKeyParameters.getZ(), bigInteger).modInverse(bigInteger)).mod(bigInteger);
            } else {
                throw new CramerShoupCiphertextException("Sorry, that ciphertext is not correct");
            }
        }
        return bigInteger;
    }

    public SecureRandom initSecureRandom(boolean bl, SecureRandom secureRandom) {
        return bl ? CryptoServicesRegistrar.getSecureRandom(secureRandom) : null;
    }

    public static class CramerShoupCiphertextException
    extends Exception {
        private static final long serialVersionUID = -6360977166495345076L;

        public CramerShoupCiphertextException(String string) {
            super(string);
        }
    }
}

