/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.BasicEntropySourceProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.EntropySourceProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.X931RNG;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.X931SecureRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.security.SecureRandom;

public class X931SecureRandomBuilder {
    private SecureRandom random;
    private EntropySourceProvider entropySourceProvider;
    private byte[] dateTimeVector;

    public X931SecureRandomBuilder() {
        this(CryptoServicesRegistrar.getSecureRandom(), false);
    }

    public X931SecureRandomBuilder(SecureRandom secureRandom, boolean bl) {
        BasicEntropySourceProvider basicEntropySourceProvider;
        ((X931SecureRandomBuilder)((Object)basicEntropySourceProvider2)).random = secureRandom;
        BasicEntropySourceProvider basicEntropySourceProvider2 = basicEntropySourceProvider;
        basicEntropySourceProvider = new BasicEntropySourceProvider(secureRandom, bl);
        v1.entropySourceProvider = basicEntropySourceProvider2;
    }

    public X931SecureRandomBuilder(EntropySourceProvider entropySourceProvider) {
        this.random = null;
        this.entropySourceProvider = entropySourceProvider;
    }

    public X931SecureRandomBuilder setDateTimeVector(byte[] byArray) {
        this.dateTimeVector = Arrays.clone(byArray);
        return this;
    }

    public X931SecureRandom build(BlockCipher blockCipher, KeyParameter keyParameter, boolean bl) {
        if (((X931SecureRandomBuilder)object).dateTimeVector == null) {
            ((X931SecureRandomBuilder)object).dateTimeVector = new byte[blockCipher.getBlockSize()];
            Pack.longToBigEndian(System.currentTimeMillis(), ((X931SecureRandomBuilder)object).dateTimeVector, 0);
        }
        blockCipher.init(true, keyParameter);
        X931SecureRandomBuilder x931SecureRandomBuilder = object;
        Object object = x931SecureRandomBuilder.dateTimeVector;
        return new X931SecureRandom(((X931SecureRandomBuilder)object).random, new X931RNG(blockCipher, (byte[])object, x931SecureRandomBuilder.entropySourceProvider.get(blockCipher.getBlockSize() * 8)), bl);
    }
}

