/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.crypto.prng.drbg;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;

public class DualECPoints {
    private final ECPoint p;
    private final ECPoint q;
    private final int securityStrength;
    private final int cofactor;

    public DualECPoints(int n, ECPoint eCPoint, ECPoint eCPoint2, int n2) {
        if (eCPoint.getCurve().equals(eCPoint2.getCurve())) {
            DualECPoints dualECPoints = this;
            dualECPoints.securityStrength = n;
            dualECPoints.p = eCPoint;
            dualECPoints.q = eCPoint2;
            dualECPoints.cofactor = n2;
            return;
        }
        throw new IllegalArgumentException("points need to be on the same curve");
    }

    private static int log2(int n) {
        int n2 = 0;
        while ((n >>= 1) != 0) {
            ++n2;
        }
        return n2;
    }

    public int getSeedLen() {
        return this.p.getCurve().getFieldSize();
    }

    public int getMaxOutlen() {
        return (this.p.getCurve().getFieldSize() - (DualECPoints.log2(this.cofactor) + 13)) / 8 * 8;
    }

    public ECPoint getP() {
        return this.p;
    }

    public ECPoint getQ() {
        return this.q;
    }

    public int getSecurityStrength() {
        return this.securityStrength;
    }

    public int getCofactor() {
        return this.cofactor;
    }
}

