/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProvider;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyFactory
extends KeyFactorySpi {
    @Override
    public PrivateKey engineGeneratePrivate(KeySpec object) {
        if (object instanceof PKCS8EncodedKeySpec) {
            block5: {
                try {
                    PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance(((PKCS8EncodedKeySpec)object).getEncoded());
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException(((Object)exception).toString());
                }
                object = BouncyCastleProvider.getPrivateKey(privateKeyInfo);
                if (object == null) break block5;
                return object;
            }
            throw new InvalidKeySpecException("no factory found for OID: " + privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        }
        throw new InvalidKeySpecException(b.a("Unknown KeySpec type: ").append(object.getClass().getName()).toString());
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec object) {
        if (object instanceof X509EncodedKeySpec) {
            block5: {
                try {
                    SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(((X509EncodedKeySpec)object).getEncoded());
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException(((Object)exception).toString());
                }
                object = BouncyCastleProvider.getPublicKey(subjectPublicKeyInfo);
                if (object == null) break block5;
                return object;
            }
            throw new InvalidKeySpecException("no factory found for OID: " + subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        }
        throw new InvalidKeySpecException(b.a("Unknown KeySpec type: ").append(object.getClass().getName()).toString());
    }

    public KeySpec engineGetKeySpec(Key key, Class clazz) {
        if (clazz.isAssignableFrom(PKCS8EncodedKeySpec.class) && key.getFormat().equals("PKCS#8")) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (clazz.isAssignableFrom(X509EncodedKeySpec.class) && key.getFormat().equals("X.509")) {
            return new X509EncodedKeySpec(key.getEncoded());
        }
        throw new InvalidKeySpecException("not implemented yet " + key + " " + clazz);
    }

    @Override
    public Key engineTranslateKey(Key key) {
        throw new InvalidKeyException("not implemented yet " + key);
    }
}

