/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.SignedData;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PEMUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509AttributeCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509StreamParserSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509V2AttributeCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.util.StreamParsingException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;

public class X509AttrCertParser
extends X509StreamParserSpi {
    private static final PEMUtil PEM_PARSER = new PEMUtil("ATTRIBUTE CERTIFICATE");
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;

    private X509AttributeCertificate readDERCertificate(InputStream object) {
        if (((ASN1Sequence)(object = ASN1Sequence.getInstance(new ASN1InputStream((InputStream)object).readObject()))).size() > 1 && ((ASN1Sequence)object).getObjectAt(0) instanceof ASN1ObjectIdentifier && ((ASN1Sequence)object).getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1Sequence)object).getObjectAt(1), true)).getCertificates();
            return this.getCertificate();
        }
        return new X509V2AttributeCertificate(((ASN1Object)object).getEncoded());
    }

    private X509AttributeCertificate getCertificate() {
        if (this.sData != null) {
            while (this.sDataObjectCount < this.sData.size()) {
                int n = this.sDataObjectCount;
                this.sDataObjectCount = n + 1;
                ASN1Encodable aSN1Encodable = this.sData.getObjectAt(n);
                if (!(aSN1Encodable instanceof ASN1TaggedObject) || ((ASN1TaggedObject)(aSN1Encodable = (ASN1TaggedObject)aSN1Encodable)).getTagNo() != 2) continue;
                return new X509V2AttributeCertificate(ASN1Sequence.getInstance((ASN1TaggedObject)aSN1Encodable, false).getEncoded());
            }
        }
        return null;
    }

    private X509AttributeCertificate readPEMCertificate(InputStream inputStream) {
        ASN1Sequence aSN1Sequence = PEM_PARSER.readPEMObject(inputStream);
        if (aSN1Sequence != null) {
            return new X509V2AttributeCertificate(aSN1Sequence.getEncoded());
        }
        return null;
    }

    @Override
    public void engineInit(InputStream inputStream) {
        X509AttrCertParser x509AttrCertParser = this;
        x509AttrCertParser.currentStream = inputStream;
        x509AttrCertParser.sData = null;
        x509AttrCertParser.sDataObjectCount = 0;
        if (!inputStream.markSupported()) {
            this.currentStream = new BufferedInputStream(this.currentStream);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object engineRead() {
        try {
            ASN1Set aSN1Set = this.sData;
            if (aSN1Set != null) {
                if (this.sDataObjectCount != aSN1Set.size()) {
                    return this.getCertificate();
                }
                X509AttrCertParser x509AttrCertParser = this;
                x509AttrCertParser.sData = null;
                x509AttrCertParser.sDataObjectCount = 0;
                return null;
            }
            X509AttrCertParser x509AttrCertParser = this;
            x509AttrCertParser.currentStream.mark(10);
            int n = x509AttrCertParser.currentStream.read();
            if (n == -1) {
                return null;
            }
            if (n != 48) {
                X509AttrCertParser x509AttrCertParser2 = this;
                x509AttrCertParser2.currentStream.reset();
                return x509AttrCertParser2.readPEMCertificate(x509AttrCertParser2.currentStream);
            }
            X509AttrCertParser x509AttrCertParser3 = this;
            x509AttrCertParser3.currentStream.reset();
            return x509AttrCertParser3.readDERCertificate(x509AttrCertParser3.currentStream);
        }
        catch (Exception exception) {
            throw new StreamParsingException(((Object)exception).toString(), exception);
        }
    }

    @Override
    public Collection engineReadAll() {
        X509AttributeCertificate x509AttributeCertificate;
        ArrayList<X509AttributeCertificate> arrayList;
        ArrayList<X509AttributeCertificate> arrayList2 = arrayList;
        arrayList = new ArrayList<X509AttributeCertificate>();
        while ((x509AttributeCertificate = (X509AttributeCertificate)this.engineRead()) != null) {
            arrayList2.add(x509AttributeCertificate);
        }
        return arrayList2;
    }
}

