/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.raw;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Bits;

public class Interleave {
    private static final long M32 = 0x55555555L;
    private static final long M64 = 0x5555555555555555L;
    private static final long M64R = -6148914691236517206L;

    public static int expand8to16(int n) {
        int n2 = n & 0xFF;
        int n3 = (n2 | n2 << 4) & 0xF0F;
        int n4 = (n3 | n3 << 2) & 0x3333;
        return (n4 | n4 << 1) & 0x5555;
    }

    public static int expand16to32(int n) {
        int n2 = n & 0xFFFF;
        int n3 = (n2 | n2 << 8) & 0xFF00FF;
        int n4 = (n3 | n3 << 4) & 0xF0F0F0F;
        int n5 = (n4 | n4 << 2) & 0x33333333;
        return (n5 | n5 << 1) & 0x55555555;
    }

    public static long expand32to64(int n) {
        n = Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(n, 65280, 8), 0xF000F0, 4), 0xC0C0C0C, 2), 0x22222222, 1);
        return ((long)(n >>> 1) & 0x55555555L) << 32 | (long)n & 0x55555555L;
    }

    public static void expand64To128(long l, long[] lArray, int n) {
        long l2;
        l = Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l, 0xFFFF0000L, 16), 0xFF000000FF00L, 8), 0xF000F000F000F0L, 4), 0xC0C0C0C0C0C0C0CL, 2), 0x2222222222222222L, 1);
        lArray[n] = l & 0x5555555555555555L;
        int n2 = n + 1;
        lArray[n2] = l2 = l >>> 1 & 0x5555555555555555L;
    }

    public static void expand64To128(long[] lArray, int n, int n2, long[] lArray2, int n3) {
        for (int k = 0; k < n2; ++k) {
            Interleave.expand64To128(lArray[n + k], lArray2, n3);
            n3 += 2;
        }
    }

    public static void expand64To128Rev(long l, long[] lArray, int n) {
        long l2;
        l = Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l, 0xFFFF0000L, 16), 0xFF000000FF00L, 8), 0xF000F000F000F0L, 4), 0xC0C0C0C0C0C0C0CL, 2), 0x2222222222222222L, 1);
        lArray[n] = l & 0xAAAAAAAAAAAAAAAAL;
        int n2 = n + 1;
        lArray[n2] = l2 = l << 1 & 0xAAAAAAAAAAAAAAAAL;
    }

    public static int shuffle(int n) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(n, 65280, 8), 0xF000F0, 4), 0xC0C0C0C, 2), 0x22222222, 1);
    }

    public static long shuffle(long l) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l, 0xFFFF0000L, 16), 0xFF000000FF00L, 8), 0xF000F000F000F0L, 4), 0xC0C0C0C0C0C0C0CL, 2), 0x2222222222222222L, 1);
    }

    public static int shuffle2(int n) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(n, 0xAA00AA, 7), 52428, 14), 0xF000F0, 4), 65280, 8);
    }

    public static long shuffle2(long l) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l, 0xFF00FF00L, 24), 0xCC00CC00CC00CCL, 6), 0xF0F00000F0F0L, 12), 0xA0A0A0A0A0A0A0AL, 3);
    }

    public static long shuffle3(long l) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l, 0xAA00AA00AA00AAL, 7), 0xCCCC0000CCCCL, 14), 0xF0F0F0F0L, 28);
    }

    public static int unshuffle(int n) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(n, 0x22222222, 1), 0xC0C0C0C, 2), 0xF000F0, 4), 65280, 8);
    }

    public static long unshuffle(long l) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l, 0x2222222222222222L, 1), 0xC0C0C0C0C0C0C0CL, 2), 0xF000F000F000F0L, 4), 0xFF000000FF00L, 8), 0xFFFF0000L, 16);
    }

    public static int unshuffle2(int n) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(n, 65280, 8), 0xF000F0, 4), 52428, 14), 0xAA00AA, 7);
    }

    public static long unshuffle2(long l) {
        return Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(Bits.bitPermuteStep(l, 0xA0A0A0A0A0A0A0AL, 3), 0xF0F00000F0F0L, 12), 0xCC00CC00CC00CCL, 6), 0xFF00FF00L, 24);
    }

    public static long unshuffle3(long l) {
        return Interleave.shuffle3(l);
    }
}

