/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.MessageSigner;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.GMSSPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSRandom;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.GMSSUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSVerify;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.crypto.gmss.util.WinternitzOTSignature;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class GMSSSigner
implements MessageSigner {
    private GMSSUtil gmssUtil;
    private byte[] pubKeyBytes;
    private Digest messDigestTrees;
    private int mdLength;
    private int numLayer;
    private Digest messDigestOTS;
    private WinternitzOTSignature ots;
    private GMSSDigestProvider digestProvider;
    private int[] index;
    private byte[][][] currentAuthPaths;
    private byte[][] subtreeRootSig;
    private GMSSParameters gmssPS;
    private GMSSRandom gmssRandom;
    public GMSSKeyParameters key;
    private SecureRandom random;

    public GMSSSigner(GMSSDigestProvider object) {
        GMSSSigner gMSSSigner = this;
        this.gmssUtil = new GMSSUtil();
        this.digestProvider = object;
        object = object.get();
        gMSSSigner.messDigestTrees = object;
        gMSSSigner.messDigestOTS = object;
        gMSSSigner.mdLength = object.getDigestSize();
        gMSSSigner.gmssRandom = new GMSSRandom(this.messDigestTrees);
    }

    private void initSign() {
        GMSSSigner gMSSSigner = this;
        gMSSSigner.messDigestTrees.reset();
        GMSSPrivateKeyParameters gMSSPrivateKeyParameters = (GMSSPrivateKeyParameters)gMSSSigner.key;
        if (!gMSSPrivateKeyParameters.isUsed()) {
            if (gMSSPrivateKeyParameters.getIndex(0) < gMSSPrivateKeyParameters.getNumLeafs(0)) {
                int n;
                int n2;
                Object object;
                GMSSParameters gMSSParameters;
                GMSSSigner gMSSSigner2 = this;
                gMSSSigner2.gmssPS = gMSSParameters = gMSSPrivateKeyParameters.getParameters();
                gMSSSigner2.numLayer = gMSSParameters.getNumOfLayers();
                int n3 = this.mdLength;
                byte[] cfr_ignored_0 = new byte[n3];
                byte[] byArray = new byte[n3];
                System.arraycopy(gMSSPrivateKeyParameters.getCurrentSeeds()[this.numLayer - 1], 0, byArray, 0, n3);
                byte[] byArray2 = object = this.gmssRandom.nextSeed(byArray);
                GMSSSigner gMSSSigner3 = this;
                object = gMSSSigner3.digestProvider.get();
                this.ots = new WinternitzOTSignature(byArray2, (Digest)object, gMSSSigner3.gmssPS.getWinternitzParameter()[this.numLayer - 1]);
                object = gMSSPrivateKeyParameters.getCurrentAuthPaths();
                this.currentAuthPaths = new byte[this.numLayer][][];
                for (n2 = 0; n2 < (n = this.numLayer); ++n2) {
                    Object object2;
                    this.currentAuthPaths[n2] = new byte[((byte)object[n2]).length][this.mdLength];
                    for (n = 0; n < ((byte)(object2 = object[n2])).length; ++n) {
                        void v4 = object2[n];
                        GMSSSigner gMSSSigner4 = this;
                        object2 = gMSSSigner4.currentAuthPaths[n2][n];
                        int n4 = gMSSSigner4.mdLength;
                        System.arraycopy(v4, 0, object2, 0, n4);
                    }
                }
                this.index = new int[n];
                GMSSSigner gMSSSigner5 = this;
                object = gMSSSigner5.index;
                n2 = gMSSSigner5.numLayer;
                System.arraycopy(gMSSPrivateKeyParameters.getIndex(), 0, object, 0, n2);
                this.subtreeRootSig = new byte[this.numLayer - 1][];
                for (int k = 0; k < this.numLayer - 1; ++k) {
                    byte[] byArray3 = gMSSPrivateKeyParameters.getSubtreeRootSig(k);
                    byte[] byArray4 = byArray3;
                    byArray4 = new byte[byArray4.length];
                    this.subtreeRootSig[k] = byArray4;
                    n = byArray3.length;
                    System.arraycopy(byArray3, 0, byArray4, 0, n);
                }
                gMSSPrivateKeyParameters.markUsed();
                return;
            }
            throw new IllegalStateException("No more signatures can be generated");
        }
        throw new IllegalStateException("Private key already used");
    }

    private void initVerify() {
        GMSSSigner gMSSSigner = gMSSParameters;
        gMSSSigner.messDigestTrees.reset();
        GMSSPublicKeyParameters gMSSPublicKeyParameters = (GMSSPublicKeyParameters)gMSSSigner.key;
        ((GMSSSigner)((Object)gMSSParameters)).pubKeyBytes = gMSSPublicKeyParameters.getPublicKey();
        GMSSParameters gMSSParameters = gMSSPublicKeyParameters.getParameters();
        gMSSSigner.gmssPS = gMSSParameters;
        gMSSSigner.numLayer = gMSSParameters.getNumOfLayers();
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                GMSSSigner gMSSSigner = parametersWithRandom;
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                gMSSSigner.random = parametersWithRandom.getRandom();
                gMSSSigner.key = (GMSSPrivateKeyParameters)parametersWithRandom.getParameters();
                gMSSSigner.initSign();
            } else {
                ((GMSSSigner)((Object)parametersWithRandom)).random = CryptoServicesRegistrar.getSecureRandom();
                ((GMSSSigner)((Object)parametersWithRandom)).key = (GMSSPrivateKeyParameters)cipherParameters;
                ((GMSSSigner)((Object)parametersWithRandom)).initSign();
            }
        } else {
            ((GMSSSigner)((Object)parametersWithRandom)).key = (GMSSPublicKeyParameters)cipherParameters;
            ((GMSSSigner)((Object)parametersWithRandom)).initVerify();
        }
    }

    @Override
    public byte[] generateSignature(byte[] byArray) {
        GMSSSigner gMSSSigner = object;
        byte[] cfr_ignored_0 = new byte[gMSSSigner.mdLength];
        byArray = gMSSSigner.ots.getSignature(byArray);
        byte[] byArray2 = gMSSSigner.gmssUtil.concatenateArray(((GMSSSigner)object).currentAuthPaths[((GMSSSigner)object).numLayer - 1]);
        byte[] byArray3 = ((GMSSSigner)object).gmssUtil.intToBytesLittleEndian(((GMSSSigner)object).index[((GMSSSigner)object).numLayer - 1]);
        int n = byArray3.length + byArray.length + byArray2.length;
        byte[] byArray4 = new byte[n];
        int n2 = byArray3.length;
        System.arraycopy(byArray3, 0, byArray4, 0, n2);
        n2 = byArray3.length;
        int n3 = byArray.length;
        System.arraycopy(byArray, 0, byArray4, n2, n3);
        int n4 = byArray3.length + byArray.length;
        int n5 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray4, n4, n5);
        byte[] byArray5 = new byte[]{};
        for (n5 = (v781122).numLayer - 1 - 1; n5 >= 0; --n5) {
            byte[] byArray6 = ((GMSSSigner)object).gmssUtil.concatenateArray(((GMSSSigner)object).currentAuthPaths[n5]);
            byte[] byArray7 = ((GMSSSigner)object).gmssUtil.intToBytesLittleEndian(((GMSSSigner)object).index[n5]);
            int n6 = byArray5.length;
            byte[] byArray8 = new byte[n6];
            int n7 = byArray5.length;
            System.arraycopy(byArray5, 0, byArray8, 0, n7);
            byArray5 = new byte[n6 + byArray7.length + ((GMSSSigner)object).subtreeRootSig[n5].length + byArray6.length];
            System.arraycopy(byArray8, 0, byArray5, 0, n6);
            n2 = byArray7.length;
            System.arraycopy(byArray7, 0, byArray5, n6, n2);
            byte[] byArray9 = ((GMSSSigner)object).subtreeRootSig[n5];
            n2 = n6 + byArray7.length;
            n3 = byArray9.length;
            System.arraycopy(byArray9, 0, byArray5, n2, n3);
            n2 = n6 + byArray7.length + ((GMSSSigner)object).subtreeRootSig[n5].length;
            n3 = byArray6.length;
            System.arraycopy(byArray6, 0, byArray5, n2, n3);
        }
        byte[] byArray10 = new byte[n + byArray5.length];
        Object object = byArray10;
        System.arraycopy(byArray4, 0, object, 0, n);
        int n8 = byArray5.length;
        System.arraycopy(byArray5, 0, object, n, n8);
        return byArray10;
    }

    @Override
    public boolean verifySignature(byte[] byArray, byte[] byArray2) {
        this.messDigestOTS.reset();
        int n = 0;
        for (int k = (v781317).numLayer - 1; k >= 0; --k) {
            int n2;
            int n3;
            WinternitzOTSVerify winternitzOTSVerify;
            WinternitzOTSVerify winternitzOTSVerify2;
            WinternitzOTSVerify winternitzOTSVerify3 = winternitzOTSVerify2 = winternitzOTSVerify;
            winternitzOTSVerify3(this.digestProvider.get(), this.gmssPS.getWinternitzParameter()[k]);
            int n4 = winternitzOTSVerify3.getSignatureLength();
            int n5 = this.gmssUtil.bytesToIntLittleEndian(byArray2, n);
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray2, n += 4, byArray3, 0, n4);
            n4 = n + n4;
            byArray3 = winternitzOTSVerify.Verify(byArray, byArray3);
            if (byArray3 == null) {
                System.err.println("OTS Public Key is null in GMSSSignature.verify");
                return false;
            }
            byte[][] byArray4 = new byte[this.gmssPS.getHeightOfTrees()[k]][this.mdLength];
            for (n3 = 0; n3 < byArray4.length; ++n3) {
                byte[] byArray5 = byArray4[n3];
                n2 = this.mdLength;
                System.arraycopy(byArray2, n4, byArray5, 0, n2);
                n4 += this.mdLength;
            }
            byte[] cfr_ignored_0 = new byte[this.mdLength];
            n5 = (1 << byArray4.length) + n5;
            for (n3 = 0; n3 < byArray4.length; ++n3) {
                int n6;
                n2 = this.mdLength;
                int n7 = n2 << 1;
                byte[] byArray6 = new byte[n7];
                if (n5 % 2 == 0) {
                    System.arraycopy(byArray3, 0, byArray6, 0, n2);
                    int n8 = n6 = this.mdLength;
                    System.arraycopy(byArray4[n3], 0, byArray6, n8, n8);
                    n5 = n6 = n5 / 2;
                } else {
                    int n9 = n5;
                    System.arraycopy(byArray4[n3], 0, byArray6, 0, n2);
                    n6 = this.mdLength;
                    n5 = byArray3.length;
                    System.arraycopy(byArray3, 0, byArray6, n6, n5);
                    n5 = n6 = (n9 - 1) / 2;
                }
                GMSSSigner gMSSSigner = this;
                gMSSSigner.messDigestTrees.update(byArray6, 0, n7);
                byArray3 = new byte[gMSSSigner.messDigestTrees.getDigestSize()];
                gMSSSigner.messDigestTrees.doFinal(byArray3, 0);
            }
            n = n4;
            byArray = byArray3;
        }
        return Arrays.areEqual(this.pubKeyBytes, byArray);
    }
}

