/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;

public final class BigEndianConversions {
    private BigEndianConversions() {
    }

    public static byte[] I2OSP(int n) {
        byte[] byArray = new byte[4];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(n >>> 24);
        byArray2[1] = (byte)(n >>> 16);
        byArray2[2] = (byte)(n >>> 8);
        byArray[3] = (byte)n;
        return byArray;
    }

    public static byte[] I2OSP(int n, int n2) {
        if (n < 0) {
            return null;
        }
        int n3 = IntegerFunctions.ceilLog256(n);
        if (n3 <= n2) {
            int n4;
            byte[] byArray = new byte[n2];
            for (int k = n4 = (v907795) - 1; k >= n2 - n3; --k) {
                byArray[k] = (byte)(n >>> (n4 - k) * 8);
            }
            return byArray;
        }
        throw new ArithmeticException("Cannot encode given integer into specified number of octets.");
    }

    public static void I2OSP(int n, byte[] byArray, int n2) {
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = n;
        n = n2 + 1;
        byArray[n2] = (byte)(n6 >>> 24);
        int n7 = n + 1;
        byArray[n] = (byte)(n5 >>> 16);
        n = n7 + 1;
        byArray[n7] = (byte)(n4 >>> 8);
        byArray[n] = (byte)n3;
    }

    public static byte[] I2OSP(long l) {
        byte[] byArray = new byte[8];
        byte[] byArray2 = byArray;
        byArray2[0] = (byte)(l >>> 56);
        byArray2[1] = (byte)(l >>> 48);
        byArray2[2] = (byte)(l >>> 40);
        byArray2[3] = (byte)(l >>> 32);
        byArray2[4] = (byte)(l >>> 24);
        byArray2[5] = (byte)(l >>> 16);
        byArray2[6] = (byte)(l >>> 8);
        byArray[7] = (byte)l;
        return byArray;
    }

    public static void I2OSP(long l, byte[] byArray, int n) {
        int n2 = n + 1;
        byArray[n] = (byte)(l >>> 56);
        n = n2 + 1;
        byArray[n2] = (byte)(l >>> 48);
        n2 = n + 1;
        byArray[n] = (byte)(l >>> 40);
        n = n2 + 1;
        byArray[n2] = (byte)(l >>> 32);
        n2 = n + 1;
        byArray[n] = (byte)(l >>> 24);
        n = n2 + 1;
        byArray[n2] = (byte)(l >>> 16);
        n2 = n + 1;
        byArray[n] = (byte)(l >>> 8);
        byArray[n2] = (byte)l;
    }

    public static void I2OSP(int n, byte[] byArray, int n2, int n3) {
        for (int k = --n3; k >= 0; --k) {
            int n4 = n2 + k;
            byArray[n4] = (byte)(n >>> (n3 - k) * 8);
        }
    }

    public static int OS2IP(byte[] byArray) {
        if (byArray.length <= 4) {
            if (byArray.length == 0) {
                return 0;
            }
            int n = 0;
            for (int k = 0; k < byArray.length; ++k) {
                n |= (byArray[k] & 0xFF) << (byArray.length - 1 - k) * 8;
            }
            return n;
        }
        throw new ArithmeticException("invalid input length");
    }

    public static int OS2IP(byte[] byArray, int n) {
        return (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
    }

    public static int OS2IP(byte[] byArray, int n, int n2) {
        if (byArray.length != 0 && byArray.length >= n + n2 - 1) {
            int n3 = 0;
            for (int k = 0; k < n2; ++k) {
                n3 |= (byArray[n + k] & 0xFF) << (n2 - k - 1) * 8;
            }
            return n3;
        }
        return 0;
    }

    public static long OS2LIP(byte[] byArray, int n) {
        return ((long)byArray[n++] & 0xFFL) << 56 | ((long)byArray[n++] & 0xFFL) << 48 | ((long)byArray[n++] & 0xFFL) << 40 | ((long)byArray[n++] & 0xFFL) << 32 | ((long)byArray[n++] & 0xFFL) << 24 | (long)((byArray[n++] & 0xFF) << 16) | (long)((byArray[n++] & 0xFF) << 8) | (long)(byArray[n] & 0xFF);
    }

    public static byte[] toByteArray(int[] nArray) {
        byte[] byArray = new byte[nArray.length << 2];
        for (int k = 0; k < nArray.length; ++k) {
            BigEndianConversions.I2OSP(nArray[k], byArray, k << 2);
        }
        return byArray;
    }

    public static byte[] toByteArray(int[] nArray, int n) {
        int n2 = nArray.length;
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n2 - 2) {
            BigEndianConversions.I2OSP(nArray[n4], byArray, n3);
            ++n4;
            n3 += 4;
        }
        BigEndianConversions.I2OSP(nArray[n2 - 1], byArray, n3, n - n3);
        return byArray;
    }

    public static int[] toIntArray(byte[] byArray) {
        int n = (byArray.length + 3) / 4;
        int n2 = byArray.length & 3;
        int[] nArray = new int[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n - 2) {
            nArray[n4] = BigEndianConversions.OS2IP(byArray, n3);
            ++n4;
            n3 += 4;
        }
        if (n2 != 0) {
            int n5 = n - 1;
            nArray[n5] = BigEndianConversions.OS2IP(byArray, n3, n2);
        } else {
            int n6 = n - 1;
            nArray[n6] = BigEndianConversions.OS2IP(byArray, n3);
        }
        return nArray;
    }
}

