/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;
import java.util.Random;

public class GF2Polynomial {
    private static Random rand = new Random();
    private static final boolean[] parity = new boolean[]{false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false, false, true, true, false, true, false, false, true, false, true, true, false, true, false, false, true, true, false, false, true, false, true, true, false};
    private static final short[] squaringTable = new short[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85, 256, 257, 260, 261, 272, 273, 276, 277, 320, 321, 324, 325, 336, 337, 340, 341, 1024, 1025, 1028, 1029, 1040, 1041, 1044, 1045, 1088, 1089, 1092, 1093, 1104, 1105, 1108, 1109, 1280, 1281, 1284, 1285, 1296, 1297, 1300, 1301, 1344, 1345, 1348, 1349, 1360, 1361, 1364, 1365, 4096, 4097, 4100, 4101, 4112, 4113, 4116, 4117, 4160, 4161, 4164, 4165, 4176, 4177, 4180, 4181, 4352, 4353, 4356, 4357, 4368, 4369, 4372, 4373, 4416, 4417, 4420, 4421, 4432, 4433, 4436, 4437, 5120, 5121, 5124, 5125, 5136, 5137, 5140, 5141, 5184, 5185, 5188, 5189, 5200, 5201, 5204, 5205, 5376, 5377, 5380, 5381, 5392, 5393, 5396, 5397, 5440, 5441, 5444, 5445, 5456, 5457, 5460, 5461, 16384, 16385, 16388, 16389, 16400, 16401, 16404, 16405, 16448, 16449, 16452, 16453, 16464, 16465, 16468, 16469, 16640, 16641, 16644, 16645, 16656, 16657, 16660, 16661, 16704, 16705, 16708, 16709, 16720, 16721, 16724, 16725, 17408, 17409, 17412, 17413, 17424, 17425, 17428, 17429, 17472, 17473, 17476, 17477, 17488, 17489, 17492, 17493, 17664, 17665, 17668, 17669, 17680, 17681, 17684, 17685, 17728, 17729, 17732, 17733, 17744, 17745, 17748, 17749, 20480, 20481, 20484, 20485, 20496, 20497, 20500, 20501, 20544, 20545, 20548, 20549, 20560, 20561, 20564, 20565, 20736, 20737, 20740, 20741, 20752, 20753, 20756, 20757, 20800, 20801, 20804, 20805, 20816, 20817, 20820, 20821, 21504, 21505, 21508, 21509, 21520, 21521, 21524, 21525, 21568, 21569, 21572, 21573, 21584, 21585, 21588, 21589, 21760, 21761, 21764, 21765, 21776, 21777, 21780, 21781, 21824, 21825, 21828, 21829, 21840, 21841, 21844, 21845};
    private static final int[] bitMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE, 0};
    private static final int[] reverseRightMask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private int len;
    private int blocks;
    private int[] value;

    public GF2Polynomial(int n) {
        int n2;
        if (n < 1) {
            n = 1;
        }
        GF2Polynomial gF2Polynomial = this;
        gF2Polynomial.blocks = n2 = (n - 1 >> 5) + 1;
        gF2Polynomial.value = new int[n2];
        this.len = n;
    }

    public GF2Polynomial(int n, Random random) {
        int n2;
        if (n < 1) {
            n = 1;
        }
        GF2Polynomial gF2Polynomial = this;
        gF2Polynomial.blocks = n2 = (n - 1 >> 5) + 1;
        gF2Polynomial.value = new int[n2];
        this.len = n;
        this.randomize(random);
    }

    public GF2Polynomial(int n, String string) {
        block9: {
            block5: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                if (n < 1) {
                                    n = 1;
                                }
                                int n2 = n;
                                GF2Polynomial gF2Polynomial = this;
                                gF2Polynomial.blocks = n = (n - 1 >> 5) + 1;
                                gF2Polynomial.value = new int[n];
                                this.len = n2;
                                if (!string.equalsIgnoreCase("ZERO")) break block4;
                                this.assignZero();
                                break block5;
                            }
                            if (!string.equalsIgnoreCase("ONE")) break block6;
                            this.assignOne();
                            break block5;
                        }
                        if (!string.equalsIgnoreCase("RANDOM")) break block7;
                        this.randomize();
                        break block5;
                    }
                    if (!string.equalsIgnoreCase("X")) break block8;
                    this.assignX();
                    break block5;
                }
                if (!string.equalsIgnoreCase("ALL")) break block9;
                this.assignAll();
            }
            return;
        }
        throw new IllegalArgumentException(g.a("Error: GF2Polynomial was called using ", string, " as value!"));
    }

    public GF2Polynomial(int n, int[] nArray) {
        int n2;
        if (n < 1) {
            n = 1;
        }
        this.blocks = n2 = (n - 1 >> 5) + 1;
        this.value = new int[n2];
        this.len = n;
        int n3 = Math.min(n2, nArray.length);
        System.arraycopy(nArray, 0, this.value, 0, n3);
        this.zeroUnusedBits();
    }

    public GF2Polynomial(int n, byte[] byArray) {
        int n2;
        int n3;
        if (n < 1) {
            n = 1;
        }
        int n4 = n;
        GF2Polynomial gF2Polynomial = this;
        gF2Polynomial.blocks = n = (n - 1 >> 5) + 1;
        gF2Polynomial.value = new int[n];
        this.len = n4;
        n = Math.min((byArray.length - 1 >> 2) + 1, n);
        for (int k = 0; k < (n3 = n - 1); ++k) {
            int n5;
            n3 = byArray.length - (k << 2) - 1;
            int[] nArray = this.value;
            nArray[k] = n5 = byArray[n3] & 0xFF;
            nArray[k] = n5 |= byArray[n3 - 1] << 8 & 0xFF00;
            nArray[k] = n5 |= byArray[n3 - 2] << 16 & 0xFF0000;
            this.value[k] = n5 | byArray[n3 - 3] << 24 & 0xFF000000;
        }
        n = byArray.length - (n3 << 2) - 1;
        int[] nArray = this.value;
        this.value[n3] = n2 = byArray[n] & 0xFF;
        if (n > 0) {
            nArray[n3] = n2 | byArray[n - 1] << 8 & 0xFF00;
        }
        if (n > 1) {
            nArray[n3] = nArray[n3] | byArray[n - 2] << 16 & 0xFF0000;
        }
        if (n > 2) {
            nArray[n3] = nArray[n3] | byArray[n - 3] << 24 & 0xFF000000;
        }
        GF2Polynomial gF2Polynomial2 = this;
        gF2Polynomial2.zeroUnusedBits();
        gF2Polynomial2.reduceN();
    }

    public GF2Polynomial(int n, BigInteger object) {
        int n2;
        if (n < 1) {
            n = 1;
        }
        int n3 = n;
        GF2Polynomial gF2Polynomial = this;
        gF2Polynomial.blocks = n = (n - 1 >> 5) + 1;
        gF2Polynomial.value = new int[n];
        this.len = n3;
        Object object2 = ((BigInteger)object).toByteArray();
        if (object2[0] == 0) {
            int n4 = ((byte[])object2).length - 1;
            object = new byte[n4];
            System.arraycopy(object2, 1, object, 0, n4);
            object2 = object;
        }
        int n5 = ((byte[])object2).length & 3;
        int n6 = (((byte[])object2).length - 1 >> 2) + 1;
        for (int k = 0; k < n5; ++k) {
            n2 = n6 - 1;
            this.value[n2] = this.value[n2] | (object2[k] & 0xFF) << (n5 - 1 - k << 3);
        }
        for (n5 = 0; n5 <= ((byte[])object2).length - 4 >> 2; ++n5) {
            n6 = ((byte[])object2).length - 1 - (n5 << 2);
            int[] nArray = this.value;
            nArray[n5] = n2 = object2[n6] & 0xFF;
            nArray[n5] = n2 |= object2[n6 - 1] << 8 & 0xFF00;
            nArray[n5] = n2 |= object2[n6 - 2] << 16 & 0xFF0000;
            this.value[n5] = n2 | object2[n6 - 3] << 24 & 0xFF000000;
        }
        int n7 = this.len;
        if ((n7 & 0x1F) != 0) {
            n5 = this.blocks - 1;
            this.value[n5] = this.value[n5] & reverseRightMask[n7 & 0x1F];
        }
        this.reduceN();
    }

    public GF2Polynomial(GF2Polynomial gF2Polynomial) {
        this.len = gF2Polynomial.len;
        this.blocks = gF2Polynomial.blocks;
        this.value = IntUtils.clone(gF2Polynomial.value);
    }

    private GF2Polynomial karaMult(GF2Polynomial gF2Polynomial) {
        GF2Polynomial gF2Polynomial2;
        GF2Polynomial gF2Polynomial3 = gF2Polynomial2;
        gF2Polynomial2 = new GF2Polynomial(gF2Polynomial6.len << 1);
        int n = gF2Polynomial6.len;
        if (n <= 32) {
            gF2Polynomial3.value = GF2Polynomial.mult32(gF2Polynomial6.value[0], gF2Polynomial.value[0]);
            return gF2Polynomial3;
        }
        if (n <= 64) {
            gF2Polynomial3.value = GF2Polynomial.mult64(gF2Polynomial6.value, gF2Polynomial.value);
            return gF2Polynomial3;
        }
        if (n <= 128) {
            gF2Polynomial3.value = GF2Polynomial.mult128(gF2Polynomial6.value, gF2Polynomial.value);
            return gF2Polynomial3;
        }
        if (n <= 256) {
            gF2Polynomial3.value = GF2Polynomial.mult256(gF2Polynomial6.value, gF2Polynomial.value);
            return gF2Polynomial3;
        }
        if (n <= 512) {
            gF2Polynomial3.value = GF2Polynomial.mult512(gF2Polynomial6.value, gF2Polynomial.value);
            return gF2Polynomial3;
        }
        GF2Polynomial gF2Polynomial4 = gF2Polynomial3;
        int n2 = bitMask[IntegerFunctions.floorLog(n - 1)];
        n = (n2 - 1 >> 5) + 1;
        GF2Polynomial gF2Polynomial5 = gF2Polynomial6.lower(n);
        GF2Polynomial gF2Polynomial6 = gF2Polynomial6.upper(n);
        GF2Polynomial gF2Polynomial7 = gF2Polynomial.lower(n);
        GF2Polynomial gF2Polynomial8 = gF2Polynomial6;
        GF2Polynomial gF2Polynomial9 = gF2Polynomial6;
        gF2Polynomial6 = gF2Polynomial.upper(n);
        gF2Polynomial = gF2Polynomial9.karaMult(gF2Polynomial6);
        GF2Polynomial gF2Polynomial10 = gF2Polynomial5.karaMult(gF2Polynomial7);
        gF2Polynomial5.addToThis(gF2Polynomial8);
        gF2Polynomial7.addToThis(gF2Polynomial6);
        gF2Polynomial6 = gF2Polynomial5.karaMult(gF2Polynomial7);
        gF2Polynomial4.shiftLeftAddThis(gF2Polynomial, n2 << 1);
        gF2Polynomial4.shiftLeftAddThis(gF2Polynomial, n2);
        gF2Polynomial4.shiftLeftAddThis(gF2Polynomial6, n2);
        gF2Polynomial4.shiftLeftAddThis(gF2Polynomial10, n2);
        gF2Polynomial4.addToThis(gF2Polynomial10);
        return gF2Polynomial4;
    }

    private static int[] mult512(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[32];
        int[] nArray4 = new int[8];
        int n = Math.min(8, nArray.length);
        System.arraycopy(nArray, 0, nArray4, 0, n);
        int[] nArray5 = new int[8];
        if (nArray.length > 8) {
            int n2 = Math.min(8, nArray.length - 8);
            System.arraycopy(nArray, 8, nArray5, 0, n2);
        }
        nArray = new int[8];
        int n3 = Math.min(8, nArray2.length);
        System.arraycopy(nArray2, 0, nArray, 0, n3);
        int[] nArray6 = new int[8];
        if (nArray2.length > 8) {
            int n4 = Math.min(8, nArray2.length - 8);
            System.arraycopy(nArray2, 8, nArray6, 0, n4);
        }
        int[] nArray7 = nArray3;
        int[] nArray8 = nArray;
        int[] nArray9 = nArray3;
        int[] nArray10 = nArray6;
        int[] nArray11 = nArray5;
        int[] nArray12 = nArray3;
        nArray2 = GF2Polynomial.mult256(nArray5, nArray6);
        int n5 = nArray2[15];
        nArray12[31] = nArray3[31] ^ n5;
        int n6 = nArray2[14];
        nArray12[30] = nArray3[30] ^ n6;
        int n7 = nArray2[13];
        nArray12[29] = nArray3[29] ^ n7;
        int n8 = nArray2[12];
        nArray12[28] = nArray3[28] ^ n8;
        int n9 = nArray2[11];
        nArray12[27] = nArray3[27] ^ n9;
        int n10 = nArray2[10];
        nArray12[26] = nArray3[26] ^ n10;
        int n11 = nArray2[9];
        nArray12[25] = nArray3[25] ^ n11;
        int n12 = nArray2[8];
        nArray12[24] = nArray3[24] ^ n12;
        int n13 = nArray2[7];
        nArray12[23] = nArray3[23] ^ (n13 ^ n5);
        n5 = nArray2[6];
        nArray12[22] = nArray3[22] ^ (n5 ^ n6);
        n6 = nArray2[5];
        nArray12[21] = nArray3[21] ^ (n6 ^ n7);
        n7 = nArray2[4];
        nArray12[20] = nArray3[20] ^ (n7 ^ n8);
        n8 = nArray2[3];
        nArray12[19] = nArray3[19] ^ (n8 ^ n9);
        n9 = nArray2[2];
        nArray12[18] = nArray3[18] ^ (n9 ^ n10);
        n10 = nArray2[1];
        nArray12[17] = nArray3[17] ^ (n10 ^ n11);
        int n14 = nArray2[0];
        nArray12[16] = nArray3[16] ^ (n14 ^ n12);
        nArray12[15] = nArray3[15] ^ n13;
        nArray12[14] = nArray3[14] ^ n5;
        nArray12[13] = nArray3[13] ^ n6;
        nArray12[12] = nArray3[12] ^ n7;
        nArray12[11] = nArray3[11] ^ n8;
        nArray12[10] = nArray3[10] ^ n9;
        nArray12[9] = nArray3[9] ^ n10;
        nArray12[8] = nArray3[8] ^ n14;
        nArray11[0] = nArray5[0] ^ nArray4[0];
        nArray11[1] = nArray5[1] ^ nArray4[1];
        nArray11[2] = nArray5[2] ^ nArray4[2];
        nArray11[3] = nArray5[3] ^ nArray4[3];
        nArray11[4] = nArray5[4] ^ nArray4[4];
        nArray11[5] = nArray5[5] ^ nArray4[5];
        nArray11[6] = nArray5[6] ^ nArray4[6];
        nArray11[7] = nArray5[7] ^ nArray4[7];
        nArray10[0] = nArray10[0] ^ nArray[0];
        nArray10[1] = nArray10[1] ^ nArray[1];
        nArray10[2] = nArray10[2] ^ nArray[2];
        nArray10[3] = nArray10[3] ^ nArray[3];
        nArray10[4] = nArray10[4] ^ nArray[4];
        nArray10[5] = nArray10[5] ^ nArray[5];
        nArray10[6] = nArray10[6] ^ nArray[6];
        nArray10[7] = nArray10[7] ^ nArray[7];
        nArray = GF2Polynomial.mult256(nArray5, nArray6);
        nArray9[23] = nArray3[23] ^ nArray[15];
        nArray9[22] = nArray3[22] ^ nArray[14];
        nArray9[21] = nArray3[21] ^ nArray[13];
        nArray9[20] = nArray3[20] ^ nArray[12];
        nArray9[19] = nArray3[19] ^ nArray[11];
        nArray9[18] = nArray3[18] ^ nArray[10];
        nArray9[17] = nArray3[17] ^ nArray[9];
        nArray9[16] = nArray3[16] ^ nArray[8];
        nArray9[15] = nArray3[15] ^ nArray[7];
        nArray9[14] = nArray3[14] ^ nArray[6];
        nArray9[13] = nArray3[13] ^ nArray[5];
        nArray9[12] = nArray3[12] ^ nArray[4];
        nArray9[11] = nArray3[11] ^ nArray[3];
        nArray9[10] = nArray3[10] ^ nArray[2];
        nArray9[9] = nArray3[9] ^ nArray[1];
        nArray9[8] = nArray3[8] ^ nArray[0];
        nArray = GF2Polynomial.mult256(nArray4, nArray8);
        n14 = nArray[15];
        nArray7[23] = nArray7[23] ^ n14;
        n5 = nArray[14];
        nArray7[22] = nArray7[22] ^ n5;
        int n15 = nArray[13];
        nArray7[21] = nArray7[21] ^ n15;
        n6 = nArray[12];
        nArray7[20] = nArray7[20] ^ n6;
        n7 = nArray[11];
        nArray7[19] = nArray7[19] ^ n7;
        n8 = nArray[10];
        nArray7[18] = nArray7[18] ^ n8;
        n9 = nArray[9];
        nArray7[17] = nArray7[17] ^ n9;
        n10 = nArray[8];
        nArray7[16] = nArray7[16] ^ n10;
        n11 = nArray[7];
        nArray7[15] = nArray7[15] ^ (n11 ^ n14);
        n14 = nArray[6];
        nArray7[14] = nArray7[14] ^ (n14 ^ n5);
        n5 = nArray[5];
        nArray7[13] = nArray7[13] ^ (n5 ^ n15);
        n15 = nArray[4];
        nArray7[12] = nArray7[12] ^ (n15 ^ n6);
        n6 = nArray[3];
        nArray7[11] = nArray7[11] ^ (n6 ^ n7);
        n7 = nArray[2];
        nArray7[10] = nArray7[10] ^ (n7 ^ n8);
        n8 = nArray[1];
        nArray7[9] = nArray7[9] ^ (n8 ^ n9);
        int n16 = nArray[0];
        nArray7[8] = nArray7[8] ^ (n16 ^ n10);
        nArray7[7] = nArray7[7] ^ n11;
        nArray7[6] = nArray7[6] ^ n14;
        nArray7[5] = nArray7[5] ^ n5;
        nArray7[4] = nArray7[4] ^ n15;
        nArray7[3] = nArray7[3] ^ n6;
        nArray7[2] = nArray7[2] ^ n7;
        nArray7[1] = nArray7[1] ^ n8;
        nArray7[0] = nArray7[0] ^ n16;
        return nArray3;
    }

    private static int[] mult256(int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = new int[16];
        int[] nArray4 = new int[4];
        int n2 = Math.min(4, nArray.length);
        System.arraycopy(nArray, 0, nArray4, 0, n2);
        int[] nArray5 = new int[4];
        if (nArray.length > 4) {
            int n3 = Math.min(4, nArray.length - 4);
            System.arraycopy(nArray, 4, nArray5, 0, n3);
        }
        nArray = new int[4];
        int n4 = Math.min(4, nArray2.length);
        System.arraycopy(nArray2, 0, nArray, 0, n4);
        int[] nArray6 = new int[4];
        if (nArray2.length > 4) {
            int n5 = Math.min(4, nArray2.length - 4);
            System.arraycopy(nArray2, 4, nArray6, 0, n5);
        }
        if (nArray5[3] == 0 && nArray5[2] == 0 && nArray6[3] == 0 && nArray6[2] == 0) {
            if (nArray5[1] == 0 && nArray6[1] == 0) {
                n = nArray5[0];
                if (n != 0 || nArray6[0] != 0) {
                    int[] nArray7 = nArray3;
                    int[] nArray8 = GF2Polynomial.mult32(n, nArray6[0]);
                    int n6 = nArray8[1];
                    nArray7[9] = nArray3[9] ^ n6;
                    n = nArray8[0];
                    nArray7[8] = nArray3[8] ^ n;
                    nArray7[5] = nArray3[5] ^ n6;
                    nArray7[4] = nArray3[4] ^ n;
                }
            } else {
                int[] nArray9 = nArray3;
                nArray2 = GF2Polynomial.mult64(nArray5, nArray6);
                int n7 = nArray2[3];
                nArray9[11] = nArray3[11] ^ n7;
                int n8 = nArray2[2];
                nArray9[10] = nArray3[10] ^ n8;
                int n9 = nArray2[1];
                nArray9[9] = nArray3[9] ^ n9;
                n = nArray2[0];
                nArray9[8] = nArray3[8] ^ n;
                nArray9[7] = nArray3[7] ^ n7;
                nArray9[6] = nArray3[6] ^ n8;
                nArray9[5] = nArray3[5] ^ n9;
                nArray9[4] = nArray3[4] ^ n;
            }
        } else {
            int[] nArray10 = nArray3;
            nArray2 = GF2Polynomial.mult128(nArray5, nArray6);
            int n10 = nArray2[7];
            nArray10[15] = nArray3[15] ^ n10;
            int n11 = nArray2[6];
            nArray10[14] = nArray3[14] ^ n11;
            int n12 = nArray2[5];
            nArray10[13] = nArray3[13] ^ n12;
            int n13 = nArray2[4];
            nArray10[12] = nArray3[12] ^ n13;
            int n14 = nArray2[3];
            nArray10[11] = nArray3[11] ^ (n14 ^ n10);
            n10 = nArray2[2];
            nArray10[10] = nArray3[10] ^ (n10 ^ n11);
            n11 = nArray2[1];
            nArray10[9] = nArray3[9] ^ (n11 ^ n12);
            n = nArray2[0];
            nArray10[8] = nArray3[8] ^ (n ^ n13);
            nArray10[7] = nArray3[7] ^ n14;
            nArray10[6] = nArray3[6] ^ n10;
            nArray10[5] = nArray3[5] ^ n11;
            nArray10[4] = nArray3[4] ^ n;
        }
        int[] nArray11 = nArray3;
        int[] nArray12 = nArray;
        int[] nArray13 = nArray3;
        int[] nArray14 = nArray6;
        int[] nArray15 = nArray5;
        nArray15[0] = nArray5[0] ^ nArray4[0];
        nArray15[1] = nArray5[1] ^ nArray4[1];
        nArray15[2] = nArray5[2] ^ nArray4[2];
        nArray15[3] = nArray5[3] ^ nArray4[3];
        nArray14[0] = nArray14[0] ^ nArray[0];
        nArray14[1] = nArray14[1] ^ nArray[1];
        nArray14[2] = nArray14[2] ^ nArray[2];
        nArray14[3] = nArray14[3] ^ nArray[3];
        nArray = GF2Polynomial.mult128(nArray5, nArray6);
        nArray13[11] = nArray3[11] ^ nArray[7];
        nArray13[10] = nArray3[10] ^ nArray[6];
        nArray13[9] = nArray3[9] ^ nArray[5];
        nArray13[8] = nArray3[8] ^ nArray[4];
        nArray13[7] = nArray3[7] ^ nArray[3];
        nArray13[6] = nArray3[6] ^ nArray[2];
        nArray13[5] = nArray3[5] ^ nArray[1];
        nArray13[4] = nArray3[4] ^ nArray[0];
        nArray = GF2Polynomial.mult128(nArray4, nArray12);
        n = nArray[7];
        nArray11[11] = nArray11[11] ^ n;
        int n15 = nArray[6];
        nArray11[10] = nArray11[10] ^ n15;
        int n16 = nArray[5];
        nArray11[9] = nArray11[9] ^ n16;
        int n17 = nArray[4];
        nArray11[8] = nArray11[8] ^ n17;
        int n18 = nArray[3];
        nArray11[7] = nArray11[7] ^ (n18 ^ n);
        n = nArray[2];
        nArray11[6] = nArray11[6] ^ (n ^ n15);
        n15 = nArray[1];
        nArray11[5] = nArray11[5] ^ (n15 ^ n16);
        int n19 = nArray[0];
        nArray11[4] = nArray11[4] ^ (n19 ^ n17);
        nArray11[3] = nArray11[3] ^ n18;
        nArray11[2] = nArray11[2] ^ n;
        nArray11[1] = nArray11[1] ^ n15;
        nArray11[0] = nArray11[0] ^ n19;
        return nArray3;
    }

    private static int[] mult128(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int n;
        int n2;
        int[] nArray4 = new int[8];
        int[] nArray5 = new int[2];
        int n3 = Math.min(2, nArray.length);
        System.arraycopy(nArray, 0, nArray5, 0, n3);
        int[] nArray6 = new int[2];
        if (nArray.length > 2) {
            int n4 = Math.min(2, nArray.length - 2);
            System.arraycopy(nArray, 2, nArray6, 0, n4);
        }
        nArray = new int[2];
        int n5 = Math.min(2, nArray2.length);
        System.arraycopy(nArray2, 0, nArray, 0, n5);
        int[] nArray7 = new int[2];
        if (nArray2.length > 2) {
            int n6 = Math.min(2, nArray2.length - 2);
            System.arraycopy(nArray2, 2, nArray7, 0, n6);
        }
        if (nArray6[1] == 0 && nArray7[1] == 0) {
            n2 = nArray6[0];
            if (n2 != 0 || nArray7[0] != 0) {
                int[] nArray8 = nArray4;
                int[] nArray9 = GF2Polynomial.mult32(n2, nArray7[0]);
                n = nArray9[1];
                nArray8[5] = nArray4[5] ^ n;
                n2 = nArray9[0];
                nArray8[4] = nArray4[4] ^ n2;
                nArray8[3] = nArray4[3] ^ n;
                nArray8[2] = nArray4[2] ^ n2;
            }
        } else {
            int[] nArray10 = nArray4;
            nArray2 = GF2Polynomial.mult64(nArray6, nArray7);
            n = nArray2[3];
            nArray10[7] = nArray4[7] ^ n;
            int n7 = nArray2[2];
            nArray10[6] = nArray4[6] ^ n7;
            int n8 = nArray2[1];
            nArray10[5] = nArray4[5] ^ (n8 ^ n);
            n2 = nArray2[0];
            nArray10[4] = nArray4[4] ^ (n2 ^ n7);
            nArray10[3] = nArray4[3] ^ n8;
            nArray10[2] = nArray4[2] ^ n2;
        }
        int[] nArray11 = nArray7;
        int[] nArray12 = nArray6;
        nArray12[0] = nArray6[0] ^ nArray5[0];
        nArray12[1] = nArray6[1] ^ nArray5[1];
        nArray11[0] = n2 = nArray7[0] ^ nArray[0];
        nArray11[1] = n = nArray7[1] ^ nArray[1];
        if (nArray6[1] == 0 && n == 0) {
            int[] nArray13 = nArray4;
            nArray3 = GF2Polynomial.mult32(nArray6[0], n2);
            nArray13[3] = nArray4[3] ^ nArray3[1];
            nArray13[2] = nArray4[2] ^ nArray3[0];
        } else {
            int[] nArray14 = nArray4;
            nArray3 = GF2Polynomial.mult64(nArray6, nArray7);
            nArray14[5] = nArray4[5] ^ nArray3[3];
            nArray14[4] = nArray4[4] ^ nArray3[2];
            nArray14[3] = nArray4[3] ^ nArray3[1];
            nArray14[2] = nArray4[2] ^ nArray3[0];
        }
        if (nArray5[1] == 0 && nArray[1] == 0) {
            int[] nArray15 = nArray4;
            nArray = GF2Polynomial.mult32(nArray5[0], nArray[0]);
            int n9 = nArray[1];
            nArray15[3] = nArray4[3] ^ n9;
            int n10 = nArray[0];
            nArray15[2] = nArray4[2] ^ n10;
            nArray15[1] = nArray4[1] ^ n9;
            nArray15[0] = nArray4[0] ^ n10;
        } else {
            int[] nArray16 = nArray4;
            nArray = GF2Polynomial.mult64(nArray5, nArray);
            int n11 = nArray[3];
            nArray16[5] = nArray4[5] ^ n11;
            int n12 = nArray[2];
            nArray16[4] = nArray4[4] ^ n12;
            int n13 = nArray[1];
            nArray16[3] = nArray4[3] ^ (n13 ^ n11);
            int n14 = nArray[0];
            nArray16[2] = nArray4[2] ^ (n14 ^ n12);
            nArray16[1] = nArray4[1] ^ n13;
            nArray16[0] = nArray4[0] ^ n14;
        }
        return nArray4;
    }

    private static int[] mult64(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[4];
        int n = nArray[0];
        int n2 = 0;
        if (nArray.length > 1) {
            n2 = nArray[1];
        }
        int n3 = nArray2[0];
        int n4 = 0;
        if (nArray2.length > 1) {
            n4 = nArray2[1];
        }
        if (n2 != 0 || n4 != 0) {
            int[] nArray4 = nArray3;
            nArray2 = GF2Polynomial.mult32(n2, n4);
            int n5 = nArray2[1];
            nArray4[3] = nArray3[3] ^ n5;
            int n6 = nArray2[0];
            nArray4[2] = nArray3[2] ^ (n6 ^ n5);
            nArray4[1] = nArray3[1] ^ n6;
        }
        int[] nArray5 = nArray3;
        int[] nArray6 = nArray3;
        int[] nArray7 = GF2Polynomial.mult32(n ^ n2, n3 ^ n4);
        nArray6[2] = nArray3[2] ^ nArray7[1];
        nArray6[1] = nArray3[1] ^ nArray7[0];
        nArray7 = GF2Polynomial.mult32(n, n3);
        int n7 = nArray7[1];
        nArray5[2] = nArray5[2] ^ n7;
        int n8 = nArray7[0];
        nArray5[1] = nArray5[1] ^ (n8 ^ n7);
        nArray5[0] = nArray5[0] ^ n8;
        return nArray3;
    }

    private static int[] mult32(int n, int n2) {
        int[] nArray = new int[2];
        if (n != 0 && n2 != 0) {
            long l = (long)n2 & 0xFFFFFFFFL;
            long l2 = 0L;
            for (n2 = 1; n2 <= 32; ++n2) {
                if ((n & bitMask[n2 - 1]) != 0) {
                    l2 ^= l;
                }
                l <<= 1;
            }
            nArray[1] = (int)(l2 >>> 32);
            nArray[0] = (int)(l2 & 0xFFFFFFFFL);
            return nArray;
        }
        return nArray;
    }

    private GF2Polynomial upper(int n) {
        GF2Polynomial gF2Polynomial;
        int n2 = Math.min(n, this.blocks - n);
        GF2Polynomial gF2Polynomial2 = gF2Polynomial;
        gF2Polynomial = new GF2Polynomial(n2 << 5);
        if (this.blocks >= n) {
            System.arraycopy(this.value, n, gF2Polynomial2.value, 0, n2);
        }
        return gF2Polynomial2;
    }

    private GF2Polynomial lower(int n) {
        GF2Polynomial gF2Polynomial;
        GF2Polynomial gF2Polynomial2 = gF2Polynomial;
        gF2Polynomial2(n << 5);
        GF2Polynomial gF2Polynomial3 = object;
        Object object = gF2Polynomial2.value;
        n = Math.min(n, gF2Polynomial3.blocks);
        System.arraycopy(((GF2Polynomial)object).value, 0, object, 0, n);
        return gF2Polynomial;
    }

    private void zeroUnusedBits() {
        int n = this.len;
        if ((n & 0x1F) != 0) {
            int n2 = this.blocks - 1;
            this.value[n2] = this.value[n2] & reverseRightMask[n & 0x1F];
        }
    }

    private void doShiftBlocksLeft(int n) {
        int n2 = ((GF2Polynomial)object).blocks;
        int[] nArray = ((GF2Polynomial)object).value;
        if (n2 <= ((GF2Polynomial)object).value.length) {
            --n2;
            while (n2 >= n) {
                ((GF2Polynomial)object).value[n2] = ((GF2Polynomial)object).value[n2 - n];
                --n2;
            }
            for (n2 = 0; n2 < n; ++n2) {
                ((GF2Polynomial)object).value[n2] = 0;
            }
        } else {
            GF2Polynomial gF2Polynomial = object;
            int n3 = n2;
            Object object = new int[n3];
            n2 = n3 - n;
            System.arraycopy(nArray, 0, object, n, n2);
            gF2Polynomial.value = (int[])object;
        }
    }

    public Object clone() {
        return new GF2Polynomial(this);
    }

    public int getLength() {
        return this.len;
    }

    public int[] toIntegerArray() {
        int n = this.blocks;
        int[] nArray = new int[n];
        System.arraycopy(this.value, 0, nArray, 0, n);
        return nArray;
    }

    public String toString(int n) {
        String string;
        char[] cArray = new char[16];
        char[] cArray2 = cArray;
        cArray[0] = 48;
        cArray[1] = 49;
        cArray[2] = 50;
        cArray[3] = 51;
        cArray[4] = 52;
        cArray[5] = 53;
        cArray[6] = 54;
        cArray[7] = 55;
        cArray[8] = 56;
        cArray[9] = 57;
        cArray[10] = 97;
        cArray[11] = 98;
        cArray[12] = 99;
        cArray[13] = 100;
        cArray[14] = 101;
        cArray[15] = 102;
        String[] stringArray = new String[16];
        String[] stringArray2 = stringArray;
        stringArray[0] = "0000";
        stringArray[1] = "0001";
        stringArray[2] = "0010";
        stringArray[3] = "0011";
        stringArray[4] = "0100";
        stringArray[5] = "0101";
        stringArray[6] = "0110";
        stringArray[7] = "0111";
        stringArray[8] = "1000";
        stringArray[9] = "1001";
        stringArray[10] = "1010";
        stringArray[11] = "1011";
        stringArray[12] = "1100";
        stringArray[13] = "1101";
        stringArray[14] = "1110";
        stringArray[15] = "1111";
        String string2 = string;
        string = new String();
        if (n == 16) {
            for (int k = this.blocks - 1; k >= 0; --k) {
                string2 = i.a(b.a(b.a(b.a(b.a(b.a(b.a(b.a(b.a(string2).append(cArray2[this.value[k] >>> 28 & 0xF]).toString()).append(cArray2[this.value[k] >>> 24 & 0xF]).toString()).append(cArray2[this.value[k] >>> 20 & 0xF]).toString()).append(cArray2[this.value[k] >>> 16 & 0xF]).toString()).append(cArray2[this.value[k] >>> 12 & 0xF]).toString()).append(cArray2[this.value[k] >>> 8 & 0xF]).toString()).append(cArray2[this.value[k] >>> 4 & 0xF]).toString()).append(cArray2[this.value[k] & 0xF]).toString(), " ");
            }
        } else {
            for (int k = this.blocks - 1; k >= 0; --k) {
                string2 = i.a(b.a(b.a(b.a(b.a(b.a(b.a(b.a(b.a(string2).append(stringArray2[this.value[k] >>> 28 & 0xF]).toString()).append(stringArray2[this.value[k] >>> 24 & 0xF]).toString()).append(stringArray2[this.value[k] >>> 20 & 0xF]).toString()).append(stringArray2[this.value[k] >>> 16 & 0xF]).toString()).append(stringArray2[this.value[k] >>> 12 & 0xF]).toString()).append(stringArray2[this.value[k] >>> 8 & 0xF]).toString()).append(stringArray2[this.value[k] >>> 4 & 0xF]).toString()).append(stringArray2[this.value[k] & 0xF]).toString(), " ");
            }
        }
        return string2;
    }

    public byte[] toByteArray() {
        int n;
        int n2 = (this.len - 1 >> 3) + 1;
        int n3 = n2 & 3;
        byte[] byArray = new byte[n2];
        for (n = 0; n < n2 >> 2; ++n) {
            int n4 = n2 - (n << 2) - 1;
            int n5 = this.value[n];
            int n6 = n4;
            int n7 = n4;
            byArray[n4] = (byte)(n5 & 0xFF);
            byArray[--n4] = (byte)((n5 & 0xFF00) >>> 8);
            n4 = n7 - 2;
            byArray[n4] = (byte)((n5 & 0xFF0000) >>> 16);
            n4 = n6 - 3;
            byArray[n4] = (byte)((n5 & 0xFF000000) >>> 24);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = n3 - n2 - 1 << 3;
            byArray[n2] = (byte)((this.value[this.blocks - 1] & 255 << n) >>> n);
        }
        return byArray;
    }

    public BigInteger toFlexiBigInt() {
        if (this.len != 0 && !this.isZero()) {
            return new BigInteger(1, this.toByteArray());
        }
        return new BigInteger(0, new byte[0]);
    }

    public void assignOne() {
        for (int k = 1; k < this.blocks; ++k) {
            this.value[k] = 0;
        }
        this.value[0] = 1;
    }

    public void assignX() {
        for (int k = 1; k < this.blocks; ++k) {
            this.value[k] = 0;
        }
        this.value[0] = 2;
    }

    public void assignAll() {
        for (int k = 0; k < this.blocks; ++k) {
            this.value[k] = -1;
        }
        this.zeroUnusedBits();
    }

    public void assignZero() {
        for (int k = 0; k < this.blocks; ++k) {
            this.value[k] = 0;
        }
    }

    public void randomize() {
        for (int k = 0; k < this.blocks; ++k) {
            this.value[k] = rand.nextInt();
        }
        this.zeroUnusedBits();
    }

    public void randomize(Random random) {
        for (int k = 0; k < this.blocks; ++k) {
            this.value[k] = random.nextInt();
        }
        this.zeroUnusedBits();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GF2Polynomial) {
            object = (GF2Polynomial)object;
            if (this.len != ((GF2Polynomial)object).len) {
                return false;
            }
            for (int k = 0; k < this.blocks; ++k) {
                if (this.value[k] == ((GF2Polynomial)object).value[k]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        GF2Polynomial gF2Polynomial = this;
        int n = gF2Polynomial.len;
        return Arrays.hashCode(gF2Polynomial.value) + n;
    }

    public boolean isZero() {
        if (this.len == 0) {
            return true;
        }
        for (int k = 0; k < this.blocks; ++k) {
            if (this.value[k] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isOne() {
        for (int k = 1; k < this.blocks; ++k) {
            if (this.value[k] == 0) continue;
            return false;
        }
        return this.value[0] == 1;
    }

    public void addToThis(GF2Polynomial gF2Polynomial) {
        this.expandN(gF2Polynomial.len);
        this.xorThisBy(gF2Polynomial);
    }

    public GF2Polynomial add(GF2Polynomial gF2Polynomial) {
        return this.xor(gF2Polynomial);
    }

    public void subtractFromThis(GF2Polynomial gF2Polynomial) {
        this.expandN(gF2Polynomial.len);
        this.xorThisBy(gF2Polynomial);
    }

    public GF2Polynomial subtract(GF2Polynomial gF2Polynomial) {
        return this.xor(gF2Polynomial);
    }

    public void increaseThis() {
        this.xorBit(0);
    }

    public GF2Polynomial increase() {
        GF2Polynomial gF2Polynomial = new GF2Polynomial(this);
        gF2Polynomial.increaseThis();
        return gF2Polynomial;
    }

    public GF2Polynomial multiplyClassic(GF2Polynomial gF2Polynomial) {
        int n;
        GF2Polynomial gF2Polynomial2;
        GF2Polynomial gF2Polynomial3;
        GF2Polynomial gF2Polynomial4 = gF2Polynomial3;
        gF2Polynomial3 = new GF2Polynomial(Math.max(this.len, gF2Polynomial.len) << 1);
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[32];
        GF2Polynomial[] gF2PolynomialArray2 = gF2PolynomialArray;
        GF2Polynomial gF2Polynomial5 = gF2Polynomial2;
        gF2Polynomial2 = new GF2Polynomial(this);
        gF2PolynomialArray[0] = gF2Polynomial5;
        for (n = 1; n <= 31; ++n) {
            gF2PolynomialArray2[n] = gF2PolynomialArray2[n - 1].shiftLeft();
        }
        for (n = 0; n < gF2Polynomial.blocks; ++n) {
            int n2;
            for (n2 = 0; n2 <= 31; ++n2) {
                if ((gF2Polynomial.value[n] & bitMask[n2]) == 0) continue;
                gF2Polynomial4.xorThisBy(gF2PolynomialArray2[n2]);
            }
            for (n2 = 0; n2 <= 31; ++n2) {
                gF2PolynomialArray2[n2].shiftBlocksLeft();
            }
        }
        return gF2Polynomial4;
    }

    public GF2Polynomial multiply(GF2Polynomial gF2Polynomial) {
        GF2Polynomial gF2Polynomial2 = gF2Polynomial;
        GF2Polynomial gF2Polynomial3 = this;
        int n = Math.max(gF2Polynomial3.len, gF2Polynomial.len);
        gF2Polynomial3.expandN(n);
        gF2Polynomial2.expandN(n);
        return this.karaMult(gF2Polynomial2);
    }

    public GF2Polynomial remainder(GF2Polynomial gF2Polynomial) {
        GF2Polynomial gF2Polynomial2;
        GF2Polynomial gF2Polynomial3;
        GF2Polynomial gF2Polynomial4 = gF2Polynomial3;
        gF2Polynomial3 = new GF2Polynomial(gF2Polynomial5);
        GF2Polynomial gF2Polynomial5 = gF2Polynomial2;
        if (!new GF2Polynomial(gF2Polynomial).isZero()) {
            gF2Polynomial4.reduceN();
            gF2Polynomial5.reduceN();
            int n = gF2Polynomial4.len;
            int n2 = gF2Polynomial5.len;
            if (n < n2) {
                return gF2Polynomial4;
            }
            n -= n2;
            while (n >= 0) {
                GF2Polynomial gF2Polynomial6 = gF2Polynomial4;
                gF2Polynomial6.subtractFromThis(gF2Polynomial5.shiftLeft(n));
                gF2Polynomial6.reduceN();
                n = gF2Polynomial6.len - gF2Polynomial5.len;
            }
            return gF2Polynomial4;
        }
        throw new RuntimeException();
    }

    public GF2Polynomial quotient(GF2Polynomial gF2Polynomial) {
        GF2Polynomial gF2Polynomial2;
        GF2Polynomial gF2Polynomial3;
        GF2Polynomial gF2Polynomial4;
        GF2Polynomial gF2Polynomial5 = gF2Polynomial4;
        gF2Polynomial4 = new GF2Polynomial(gF2Polynomial7.len);
        GF2Polynomial gF2Polynomial6 = gF2Polynomial3;
        gF2Polynomial3 = new GF2Polynomial(gF2Polynomial7);
        GF2Polynomial gF2Polynomial7 = gF2Polynomial2;
        if (!new GF2Polynomial(gF2Polynomial).isZero()) {
            gF2Polynomial6.reduceN();
            gF2Polynomial7.reduceN();
            int n = gF2Polynomial6.len;
            int n2 = gF2Polynomial7.len;
            if (n < n2) {
                return new GF2Polynomial(0);
            }
            gF2Polynomial5.expandN((n -= n2) + 1);
            while (n >= 0) {
                GF2Polynomial gF2Polynomial8 = gF2Polynomial6;
                gF2Polynomial8.subtractFromThis(gF2Polynomial7.shiftLeft(n));
                gF2Polynomial8.reduceN();
                gF2Polynomial5.xorBit(n);
                n = gF2Polynomial6.len - gF2Polynomial7.len;
            }
            return gF2Polynomial5;
        }
        throw new RuntimeException();
    }

    public GF2Polynomial[] divide(GF2Polynomial gF2Polynomial) {
        GF2Polynomial gF2Polynomial2;
        GF2Polynomial gF2Polynomial3;
        GF2Polynomial gF2Polynomial4;
        GF2Polynomial[] gF2PolynomialArray = new GF2Polynomial[2];
        GF2Polynomial gF2Polynomial5 = gF2Polynomial4;
        gF2Polynomial4 = new GF2Polynomial(gF2Polynomial7.len);
        GF2Polynomial gF2Polynomial6 = gF2Polynomial3;
        gF2Polynomial3 = new GF2Polynomial(gF2Polynomial7);
        GF2Polynomial gF2Polynomial7 = gF2Polynomial2;
        if (!new GF2Polynomial(gF2Polynomial).isZero()) {
            gF2Polynomial6.reduceN();
            gF2Polynomial7.reduceN();
            int n = gF2Polynomial6.len;
            int n2 = gF2Polynomial7.len;
            if (n < n2) {
                GF2Polynomial gF2Polynomial8;
                GF2Polynomial[] gF2PolynomialArray2 = gF2PolynomialArray;
                gF2Polynomial7 = gF2Polynomial8;
                gF2Polynomial8 = new GF2Polynomial(0);
                gF2PolynomialArray2[0] = gF2Polynomial7;
                gF2PolynomialArray2[1] = gF2Polynomial6;
                return gF2PolynomialArray;
            }
            gF2Polynomial5.expandN((n -= n2) + 1);
            while (n >= 0) {
                GF2Polynomial gF2Polynomial9 = gF2Polynomial6;
                gF2Polynomial9.subtractFromThis(gF2Polynomial7.shiftLeft(n));
                gF2Polynomial9.reduceN();
                gF2Polynomial5.xorBit(n);
                n = gF2Polynomial6.len - gF2Polynomial7.len;
            }
            GF2Polynomial[] gF2PolynomialArray3 = gF2PolynomialArray;
            gF2PolynomialArray3[0] = gF2Polynomial5;
            gF2PolynomialArray3[1] = gF2Polynomial6;
            return gF2PolynomialArray;
        }
        throw new RuntimeException();
    }

    public GF2Polynomial gcd(GF2Polynomial gF2Polynomial) {
        GF2Polynomial gF2Polynomial2;
        GF2Polynomial gF2Polynomial3;
        if (gF2Polynomial5.isZero() && gF2Polynomial.isZero()) {
            throw new ArithmeticException("Both operands of gcd equal zero.");
        }
        if (gF2Polynomial5.isZero()) {
            return new GF2Polynomial(gF2Polynomial);
        }
        if (gF2Polynomial.isZero()) {
            return new GF2Polynomial(gF2Polynomial5);
        }
        GF2Polynomial gF2Polynomial4 = gF2Polynomial3;
        gF2Polynomial3 = new GF2Polynomial(gF2Polynomial5);
        GF2Polynomial gF2Polynomial5 = gF2Polynomial2;
        gF2Polynomial2 = new GF2Polynomial(gF2Polynomial);
        GF2Polynomial gF2Polynomial6 = gF2Polynomial5;
        gF2Polynomial5 = gF2Polynomial4;
        gF2Polynomial4 = gF2Polynomial6;
        while (!gF2Polynomial4.isZero()) {
            GF2Polynomial gF2Polynomial7 = gF2Polynomial5 = gF2Polynomial5.remainder(gF2Polynomial4);
            gF2Polynomial5 = gF2Polynomial4;
            gF2Polynomial4 = gF2Polynomial7;
        }
        return gF2Polynomial5;
    }

    public boolean isIrreducible() {
        GF2Polynomial gF2Polynomial;
        GF2Polynomial gF2Polynomial2;
        if (this.isZero()) {
            return false;
        }
        GF2Polynomial gF2Polynomial3 = gF2Polynomial2;
        new GF2Polynomial(this).reduceN();
        int n = gF2Polynomial3.len;
        int n2 = n - 1;
        GF2Polynomial gF2Polynomial4 = gF2Polynomial;
        gF2Polynomial = new GF2Polynomial(n, "X");
        for (n = 1; n <= n2 >> 1; ++n) {
            gF2Polynomial4.squareThisPreCalc();
            gF2Polynomial4 = gF2Polynomial4.remainder(gF2Polynomial3);
            GF2Polynomial gF2Polynomial5 = gF2Polynomial4.add(new GF2Polynomial(32, "X"));
            if (!gF2Polynomial5.isZero()) {
                if (gF2Polynomial3.gcd(gF2Polynomial5).isOne()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void reduceTrinomial(int n, int n2) {
        int[] nArray;
        int n3 = n2;
        int n4 = n;
        n2 = n4 >>> 5;
        int n5 = n4 & 0x1F;
        int n6 = 32 - n5;
        int n7 = n - n3;
        int n8 = n7 >>> 5;
        int n9 = 32 - (n7 & 0x1F);
        for (int k = ((v918628) << 1) - 2 >>> 5; k > n2; --k) {
            int[] nArray2;
            int[] nArray3 = nArray2 = this.value;
            int[] nArray4 = nArray2;
            long l = (long)nArray2[k] & 0xFFFFFFFFL;
            int n10 = k - n2;
            int n11 = n10 - 1;
            nArray4[n11] = nArray2[n11] ^ (int)(l << n6);
            nArray4[n10] = (int)((long)nArray2[n10] ^ l >>> 32 - n6);
            n10 = k - n8;
            n11 = n10 - 1;
            nArray3[n11] = nArray2[n11] ^ (int)(l << n9);
            nArray3[n10] = (int)((long)nArray2[n10] ^ l >>> 32 - n9);
            this.value[k] = 0;
        }
        int[] nArray5 = nArray = this.value;
        long l = (long)nArray5[n2] & 0xFFFFFFFFL & 0xFFFFFFFFL << n5;
        nArray5[0] = (int)((long)nArray[0] ^ l >>> 32 - n6);
        n6 = n2 - n8;
        int n12 = n6 - 1;
        if (n12 >= 0) {
            nArray[n12] = nArray[n12] ^ (int)(l << n9);
        }
        nArray[n6] = (int)((long)nArray[n6] ^ l >>> 32 - n9);
        nArray[n2] = nArray[n2] & reverseRightMask[n5];
        this.blocks = (n - 1 >>> 5) + 1;
        this.len = n;
    }

    public void reducePentanomial(int n, int[] nArray) {
        int[] nArray2;
        int n2 = n;
        int n3 = n;
        int n4 = n;
        int n5 = n;
        int n6 = n5 >>> 5;
        int n7 = n5 & 0x1F;
        int n8 = 32 - n7;
        int n9 = nArray[0];
        int n10 = n4 - n9 >>> 5;
        n9 = 32 - (n4 - n9 & 0x1F);
        int n11 = nArray[1];
        int n12 = n3 - n11 >>> 5;
        n11 = 32 - (n3 - n11 & 0x1F);
        int n13 = nArray[2];
        int n14 = n2 - n13 >>> 5;
        n13 = 32 - (n2 - n13 & 0x1F);
        for (int k = ((v918832) << 1) - 2 >>> 5; k > n6; --k) {
            int[] nArray3;
            int[] nArray4 = nArray3 = this.value;
            int[] nArray5 = nArray3;
            int[] nArray6 = nArray3;
            int[] nArray7 = nArray3;
            long l = (long)nArray3[k] & 0xFFFFFFFFL;
            int n15 = k - n6;
            int n16 = n15 - 1;
            nArray7[n16] = nArray3[n16] ^ (int)(l << n8);
            nArray7[n15] = (int)((long)nArray3[n15] ^ l >>> 32 - n8);
            n15 = k - n10;
            n16 = n15 - 1;
            nArray6[n16] = nArray3[n16] ^ (int)(l << n9);
            nArray6[n15] = (int)((long)nArray3[n15] ^ l >>> 32 - n9);
            n15 = k - n12;
            n16 = n15 - 1;
            nArray5[n16] = nArray3[n16] ^ (int)(l << n11);
            nArray5[n15] = (int)((long)nArray3[n15] ^ l >>> 32 - n11);
            n15 = k - n14;
            n16 = n15 - 1;
            nArray4[n16] = nArray3[n16] ^ (int)(l << n13);
            nArray4[n15] = (int)((long)nArray3[n15] ^ l >>> 32 - n13);
            this.value[k] = 0;
        }
        int[] nArray8 = nArray2 = this.value;
        long l = (long)nArray8[n6] & 0xFFFFFFFFL & 0xFFFFFFFFL << n7;
        nArray8[0] = (int)((long)nArray2[0] ^ l >>> 32 - n8);
        n8 = n6 - n10;
        int n17 = n8 - 1;
        if (n17 >= 0) {
            nArray2[n17] = nArray2[n17] ^ (int)(l << n9);
        }
        nArray2[n8] = (int)((long)nArray2[n8] ^ l >>> 32 - n9);
        n8 = n6 - n12;
        n9 = n8 - 1;
        if (n9 >= 0) {
            nArray2[n9] = nArray2[n9] ^ (int)(l << n11);
        }
        nArray2[n8] = (int)((long)nArray2[n8] ^ l >>> 32 - n11);
        n8 = n6 - n14;
        n9 = n8 - 1;
        if (n9 >= 0) {
            nArray2[n9] = nArray2[n9] ^ (int)(l << n13);
        }
        nArray2[n8] = (int)((long)nArray2[n8] ^ l >>> 32 - n13);
        nArray2[n6] = nArray2[n6] & reverseRightMask[n7];
        this.blocks = (n - 1 >>> 5) + 1;
        this.len = n;
    }

    public void reduceN() {
        int n;
        int n2;
        for (n2 = this.blocks - 1; (n = this.value[n2]) == 0 && n2 > 0; --n2) {
        }
        int n3 = 0;
        while (n != 0) {
            n >>>= 1;
            ++n3;
        }
        this.len = (n2 << 5) + n3;
        this.blocks = n2 + 1;
    }

    public void expandN(int n) {
        if (((GF2Polynomial)object).len >= n) {
            return;
        }
        ((GF2Polynomial)object).len = n;
        int n2 = ((GF2Polynomial)object).blocks;
        if (n2 >= (n = (n - 1 >>> 5) + 1)) {
            return;
        }
        int[] nArray = ((GF2Polynomial)object).value;
        if (((GF2Polynomial)object).value.length >= n) {
            while (n2 < n) {
                ((GF2Polynomial)object).value[n2] = 0;
                ++n2;
            }
            ((GF2Polynomial)object).blocks = n;
            return;
        }
        GF2Polynomial gF2Polynomial = object;
        Object object = new int[n];
        System.arraycopy(nArray, 0, object, 0, n2);
        gF2Polynomial.blocks = n;
        gF2Polynomial.value = (int[])object;
    }

    public void squareThisBitwise() {
        if (this.isZero()) {
            return;
        }
        int n = this.blocks << 1;
        int[] nArray = new int[n];
        for (int k = (v919298) - 1; k >= 0; --k) {
            int n2 = this.value[k];
            int n3 = 1;
            for (int i2 = 0; i2 < 16; ++i2) {
                int n4;
                if ((n2 & 1) != 0) {
                    n4 = k << 1;
                    nArray[n4] = nArray[n4] | n3;
                }
                if ((n2 & 0x10000) != 0) {
                    n4 = (k << 1) + 1;
                    nArray[n4] = nArray[n4] | n3;
                }
                n3 <<= 2;
                n2 >>>= 1;
            }
        }
        this.value = nArray;
        this.blocks = n;
        this.len = (this.len << 1) - 1;
    }

    public void squareThisPreCalc() {
        if (this.isZero()) {
            return;
        }
        int n = this.blocks;
        if (this.value.length >= n << 1) {
            --n;
            while (n >= 0) {
                int[] nArray = this.value;
                int n2 = n << 1;
                int n3 = n2 + 1;
                short[] sArray = squaringTable;
                int n4 = nArray[n];
                nArray[n3] = sArray[(n4 & 0xFF0000) >>> 16] | sArray[(n4 & 0xFF000000) >>> 24] << 16;
                n4 = nArray[n];
                this.value[n2] = squaringTable[n4 & 0xFF] | sArray[(n4 & 0xFF00) >>> 8] << 16;
                --n;
            }
            GF2Polynomial gF2Polynomial = this;
            gF2Polynomial.blocks <<= 1;
            gF2Polynomial.len = (gF2Polynomial.len << 1) - 1;
        } else {
            int n5;
            int[] nArray = new int[n << 1];
            for (int k = 0; k < (n5 = this.blocks); ++k) {
                n5 = k << 1;
                short[] sArray = squaringTable;
                int[] nArray2 = this.value;
                int n6 = nArray2[k];
                nArray[n5] = sArray[n6 & 0xFF] | sArray[(n6 & 0xFF00) >>> 8] << 16;
                n6 = this.value[k];
                nArray[++n5] = squaringTable[(n6 & 0xFF0000) >>> 16] | sArray[(n6 & 0xFF000000) >>> 24] << 16;
            }
            this.value = nArray;
            this.blocks = n5 << 1;
            this.len = (this.len << 1) - 1;
        }
    }

    public boolean vectorMult(GF2Polynomial gF2Polynomial) {
        int n = 0;
        if (this.len == gF2Polynomial.len) {
            for (int k = 0; k < this.blocks; ++k) {
                int n2 = n;
                n = this.value[k] & gF2Polynomial.value[k];
                boolean[] blArray = parity;
                n = n2 ^ parity[n & 0xFF] ^ blArray[n >>> 8 & 0xFF] ^ blArray[n >>> 16 & 0xFF] ^ blArray[n >>> 24 & 0xFF];
            }
            return n != 0;
        }
        throw new RuntimeException();
    }

    public GF2Polynomial xor(GF2Polynomial gF2Polynomial) {
        GF2Polynomial gF2Polynomial2;
        GF2Polynomial gF2Polynomial3 = this;
        int n = Math.min(gF2Polynomial3.blocks, gF2Polynomial.blocks);
        if (gF2Polynomial3.len >= gF2Polynomial.len) {
            GF2Polynomial gF2Polynomial4;
            gF2Polynomial2 = gF2Polynomial4;
            gF2Polynomial4 = new GF2Polynomial(this);
            for (int k = 0; k < n; ++k) {
                gF2Polynomial2.value[k] = gF2Polynomial2.value[k] ^ gF2Polynomial.value[k];
            }
        } else {
            GF2Polynomial gF2Polynomial5;
            gF2Polynomial2 = gF2Polynomial5;
            gF2Polynomial5 = new GF2Polynomial(gF2Polynomial);
            for (int k = 0; k < n; ++k) {
                gF2Polynomial2.value[k] = gF2Polynomial2.value[k] ^ this.value[k];
            }
        }
        GF2Polynomial gF2Polynomial6 = gF2Polynomial2;
        gF2Polynomial6.zeroUnusedBits();
        return gF2Polynomial6;
    }

    public void xorThisBy(GF2Polynomial gF2Polynomial) {
        for (int k = 0; k < Math.min(this.blocks, gF2Polynomial.blocks); ++k) {
            this.value[k] = this.value[k] ^ gF2Polynomial.value[k];
        }
        this.zeroUnusedBits();
    }

    public void setBit(int n) {
        if (n >= 0 && n <= this.len - 1) {
            int n2 = n >>> 5;
            this.value[n2] = this.value[n2] | bitMask[n & 0x1F];
            return;
        }
        throw new RuntimeException();
    }

    public int getBit(int n) {
        if (n >= 0) {
            if (n > this.len - 1) {
                return 0;
            }
            return (this.value[n >>> 5] & bitMask[n & 0x1F]) != 0 ? 1 : 0;
        }
        throw new RuntimeException();
    }

    public void resetBit(int n) {
        if (n >= 0) {
            if (n > this.len - 1) {
                return;
            }
            int n2 = n >>> 5;
            this.value[n2] = this.value[n2] & ~bitMask[n & 0x1F];
            return;
        }
        throw new RuntimeException();
    }

    public void xorBit(int n) {
        if (n >= 0 && n <= this.len - 1) {
            int n2 = n >>> 5;
            this.value[n2] = this.value[n2] ^ bitMask[n & 0x1F];
            return;
        }
        throw new RuntimeException();
    }

    public boolean testBit(int n) {
        if (n >= 0) {
            if (n > this.len - 1) {
                return false;
            }
            return (this.value[n >>> 5] & bitMask[n & 0x1F]) != 0;
        }
        throw new RuntimeException();
    }

    public GF2Polynomial shiftLeft() {
        GF2Polynomial gF2Polynomial;
        GF2Polynomial gF2Polynomial2 = gF2Polynomial;
        int n = this.len + 1;
        for (n = new GF2Polynomial((int)n, (int[])(v919826).value).blocks - 1; n >= 1; --n) {
            int n2;
            int[] nArray = gF2Polynomial2.value;
            nArray[n] = n2 = nArray[n] << 1;
            gF2Polynomial2.value[n] = n2 | nArray[n - 1] >>> 31;
        }
        GF2Polynomial gF2Polynomial3 = gF2Polynomial2;
        gF2Polynomial3.value[0] = gF2Polynomial3.value[0] << 1;
        return gF2Polynomial3;
    }

    public void shiftLeftThis() {
        int n = this.len;
        if ((n & 0x1F) == 0) {
            this.len = n + 1;
            n = this.blocks + 1;
            GF2Polynomial gF2Polynomial = this;
            gF2Polynomial.blocks = n;
            int[] nArray = gF2Polynomial.value;
            if (n > gF2Polynomial.value.length) {
                int[] nArray2 = new int[n];
                int n2 = nArray.length;
                System.arraycopy(nArray, 0, nArray2, 0, n2);
                this.value = nArray2;
            }
            for (int k = this.blocks - 1; k >= 1; --k) {
                int[] nArray3 = nArray = this.value;
                int n3 = k - 1;
                nArray3[k] = nArray[k] | nArray[n3] >>> 31;
                nArray3[n3] = nArray[n3] << 1;
            }
        } else {
            this.len = n + 1;
            for (n = this.blocks - 1; n >= 1; --n) {
                int n4;
                int[] nArray = this.value;
                nArray[n] = n4 = nArray[n] << 1;
                this.value[n] = n4 | nArray[n - 1] >>> 31;
            }
            this.value[0] = this.value[0] << 1;
        }
    }

    public GF2Polynomial shiftLeft(int n) {
        GF2Polynomial gF2Polynomial;
        GF2Polynomial gF2Polynomial2 = gF2Polynomial;
        GF2Polynomial gF2Polynomial3 = this;
        int n2 = gF2Polynomial3.len + n;
        gF2Polynomial = new GF2Polynomial(n2, gF2Polynomial3.value);
        if (n >= 32) {
            gF2Polynomial2.doShiftBlocksLeft(n >>> 5);
        }
        if ((n2 = n & 0x1F) != 0) {
            for (n = gF2Polynomial2.blocks - 1; n >= 1; --n) {
                int n3;
                int[] nArray = gF2Polynomial2.value;
                nArray[n] = n3 = nArray[n] << n2;
                gF2Polynomial2.value[n] = n3 | nArray[n - 1] >>> 32 - n2;
            }
            gF2Polynomial2.value[0] = gF2Polynomial2.value[0] << n2;
        }
        return gF2Polynomial2;
    }

    public void shiftLeftAddThis(GF2Polynomial gF2Polynomial, int n) {
        if (n == 0) {
            this.addToThis(gF2Polynomial);
            return;
        }
        this.expandN(gF2Polynomial.len + n);
        int n2 = n >>> 5;
        for (int k = gF2Polynomial.blocks - 1; k >= 0; --k) {
            int n3;
            int n4 = k + n2;
            int n5 = n4 + 1;
            if (n5 < this.blocks && (n3 = n & 0x1F) != 0) {
                this.value[n5] = this.value[n5] ^ gF2Polynomial.value[k] >>> 32 - n3;
            }
            this.value[n4] = this.value[n4] ^ gF2Polynomial.value[k] << (n & 0x1F);
        }
    }

    public void shiftBlocksLeft() {
        int n = ((GF2Polynomial)object).blocks + 1;
        GF2Polynomial gF2Polynomial = object;
        gF2Polynomial.blocks = n;
        gF2Polynomial.len += 32;
        int[] nArray = gF2Polynomial.value;
        if (n <= gF2Polynomial.value.length) {
            --n;
            while (n >= 1) {
                ((GF2Polynomial)object).value[n] = ((GF2Polynomial)object).value[n - 1];
                --n;
            }
            ((GF2Polynomial)object).value[0] = 0;
        } else {
            GF2Polynomial gF2Polynomial2 = object;
            int n2 = n;
            Object object = new int[n2];
            n = n2 - 1;
            System.arraycopy(nArray, 0, object, 1, n);
            gF2Polynomial2.value = (int[])object;
        }
    }

    public GF2Polynomial shiftRight() {
        int n;
        GF2Polynomial gF2Polynomial;
        GF2Polynomial gF2Polynomial2 = gF2Polynomial;
        gF2Polynomial = new GF2Polynomial(this.len - 1);
        GF2Polynomial gF2Polynomial3 = gF2Polynomial2;
        int[] nArray = gF2Polynomial3.value;
        int n2 = gF2Polynomial3.blocks;
        System.arraycopy(this.value, 0, nArray, 0, n2);
        int n3 = 0;
        while (n3 <= (n2 = gF2Polynomial2.blocks) - 2) {
            int[] nArray2 = gF2Polynomial2.value;
            nArray2[n3] = n = nArray2[n3] >>> 1;
            gF2Polynomial2.value[n3] = n | nArray2[++n3] << 31;
        }
        int[] nArray3 = gF2Polynomial2.value;
        n = n2 - 1;
        gF2Polynomial2.value[n] = nArray3[n] >>> 1;
        if (n2 < this.blocks) {
            int n4 = n2 - 1;
            nArray3[n4] = nArray3[n4] | this.value[n2] << 31;
        }
        return gF2Polynomial2;
    }

    public void shiftRightThis() {
        int n;
        ((GF2Polynomial)object).blocks = (--((GF2Polynomial)object).len - 1 >>> 5) + 1;
        int n2 = 0;
        while (n2 <= (n = ((GF2Polynomial)object).blocks) - 2) {
            int n3;
            int[] nArray = ((GF2Polynomial)object).value;
            nArray[n2] = n3 = nArray[n2] >>> 1;
            ((GF2Polynomial)object).value[n2] = n3 | nArray[++n2] << 31;
        }
        GF2Polynomial gF2Polynomial = object;
        Object object = gF2Polynomial.value;
        n2 = n - 1;
        gF2Polynomial.value[n2] = gF2Polynomial.value[n2] >>> 1;
        if ((gF2Polynomial.len & 0x1F) == 0) {
            Object object2 = object;
            n2 = n - 1;
            object2[n2] = object2[n2] | object[n] << 31;
        }
    }
}

