/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra;

import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.IntUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.math.linearalgebra.Vector;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class GF2mVector
extends Vector {
    private GF2mField field;
    private int[] vector;

    public GF2mVector(GF2mField gF2mField, byte[] byArray) {
        int n;
        GF2mField gF2mField2;
        GF2mField gF2mField3 = gF2mField2;
        gF2mField2 = new GF2mField(gF2mField);
        this.field = gF2mField3;
        int n2 = 1;
        for (n = 8; gF2mField.getDegree() > n; n += 8) {
            ++n2;
        }
        if (byArray.length % n2 == 0) {
            GF2mVector gF2mVector = this;
            gF2mVector.length = n2 = byArray.length / n2;
            gF2mVector.vector = new int[n2];
            n2 = 0;
            for (int k = 0; k < this.vector.length; ++k) {
                for (int i2 = 0; i2 < n; i2 += 8) {
                    this.vector[k] = this.vector[k] | (byArray[n2++] & 0xFF) << i2;
                }
                if (gF2mField.isElementOfThisField(this.vector[k])) {
                    continue;
                }
                throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
            }
            return;
        }
        throw new IllegalArgumentException("Byte array is not an encoded vector over the given finite field.");
    }

    public GF2mVector(GF2mField gF2mField, int[] nArray) {
        this.field = gF2mField;
        this.length = nArray.length;
        for (int k = nArray.length - 1; k >= 0; --k) {
            if (gF2mField.isElementOfThisField(nArray[k])) {
                continue;
            }
            throw new ArithmeticException("Element array is not specified over the given finite field.");
        }
        this.vector = IntUtils.clone(nArray);
    }

    public GF2mVector(GF2mVector gF2mVector) {
        this.field = new GF2mField(gF2mVector.field);
        this.length = gF2mVector.length;
        this.vector = IntUtils.clone(gF2mVector.vector);
    }

    public GF2mField getField() {
        return this.field;
    }

    public int[] getIntArrayForm() {
        return IntUtils.clone(this.vector);
    }

    @Override
    public byte[] getEncoded() {
        int n;
        int n2 = 1;
        for (n = 8; this.field.getDegree() > n; n += 8) {
            ++n2;
        }
        byte[] byArray = new byte[this.vector.length * n2];
        int n3 = 0;
        for (int k = 0; k < this.vector.length; ++k) {
            for (int i2 = 0; i2 < n; i2 += 8) {
                byArray[n3++] = (byte)(this.vector[k] >>> i2);
            }
        }
        return byArray;
    }

    @Override
    public boolean isZero() {
        for (int k = this.vector.length - 1; k >= 0; --k) {
            if (this.vector[k] == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Vector add(Vector vector) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Vector multiply(Permutation object) {
        int n = this.length;
        if (n == ((Object)(object = (Object)((Permutation)object).getVector())).length) {
            int[] nArray = new int[n];
            for (int k = 0; k < ((Object)object).length; ++k) {
                nArray[k] = this.vector[object[k]];
            }
            return new GF2mVector(this.field, nArray);
        }
        throw new ArithmeticException("permutation size and vector size mismatch");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GF2mVector)) {
            return false;
        }
        object = (GF2mVector)object;
        if (!this.field.equals(((GF2mVector)object).field)) {
            return false;
        }
        return IntUtils.equals(this.vector, ((GF2mVector)object).vector);
    }

    @Override
    public int hashCode() {
        GF2mVector gF2mVector = this;
        int n = gF2mVector.field.hashCode() * 31;
        return Arrays.hashCode(gF2mVector.vector) + n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        for (int k = 0; k < this.vector.length; ++k) {
            for (int i2 = 0; i2 < this.field.getDegree(); ++i2) {
                int n = 1 << (i2 & 0x1F);
                if ((this.vector[k] & n) != 0) {
                    stringBuffer2.append('1');
                    continue;
                }
                stringBuffer2.append('0');
            }
            stringBuffer2.append(' ');
        }
        return stringBuffer2.toString();
    }
}

