/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.eidparser.lds;

import c.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSet;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.Attribute;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.ContentInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.SignedData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.SignerIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.SignerInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.eidparser.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SignedDataUtil {
    private static final Logger LOGGER = Logger.getLogger("com.fis.ekyc.sdk.nfc.build_in..jmrtd");
    public static final String RFC_3369_SIGNED_DATA_OID = "1.2.840.113549.1.7.2";
    public static final String RFC_3369_CONTENT_TYPE_OID = "1.2.840.113549.1.9.3";
    public static final String RFC_3369_MESSAGE_DIGEST_OID = "1.2.840.113549.1.9.4";
    public static final String PKCS1_RSA_OID = "1.2.840.113549.1.1.1";
    public static final String PKCS1_MD2_WITH_RSA_OID = "1.2.840.113549.1.1.2";
    public static final String PKCS1_MD4_WITH_RSA_OID = "1.2.840.113549.1.1.3";
    public static final String PKCS1_MD5_WITH_RSA_OID = "1.2.840.113549.1.1.4";
    public static final String PKCS1_SHA1_WITH_RSA_OID = "1.2.840.113549.1.1.5";
    public static final String PKCS1_MGF1 = "1.2.840.113549.1.1.8";
    public static final String PKCS1_RSASSA_PSS_OID = "1.2.840.113549.1.1.10";
    public static final String PKCS1_SHA256_WITH_RSA_OID = "1.2.840.113549.1.1.11";
    public static final String PKCS1_SHA384_WITH_RSA_OID = "1.2.840.113549.1.1.12";
    public static final String PKCS1_SHA512_WITH_RSA_OID = "1.2.840.113549.1.1.13";
    public static final String PKCS1_SHA224_WITH_RSA_OID = "1.2.840.113549.1.1.14";
    public static final String X9_SHA1_WITH_ECDSA_OID = "1.2.840.10045.4.1";
    public static final String X9_SHA224_WITH_ECDSA_OID = "1.2.840.10045.4.3.1";
    public static final String X9_SHA256_WITH_ECDSA_OID = "1.2.840.10045.4.3.2";
    public static final String X9_SHA384_WITH_ECDSA_OID = "1.2.840.10045.4.3.3";
    public static final String X9_SHA512_WITH_ECDSA_OID = "1.2.840.10045.4.3.4";
    public static final String IEEE_P1363_SHA1_OID = "1.3.14.3.2.26";

    public static SignedData readSignedData(InputStream object) {
        if (((ASN1Sequence)(object = (ASN1Sequence)new ASN1InputStream((InputStream)object).readObject())).size() == 2) {
            String string2 = ((ASN1ObjectIdentifier)((ASN1Sequence)object).getObjectAt(0)).getId();
            if (RFC_3369_SIGNED_DATA_OID.equals(string2)) {
                if ((object = SignedDataUtil.getObjectFromTaggedObject(((ASN1Sequence)object).getObjectAt(1))) instanceof ASN1Sequence) {
                    return SignedData.getInstance(object);
                }
                throw new IOException("Was expecting an ASN.1 sequence as content");
            }
            throw new IOException(i.a("Was expecting signed-data content type OID (1.2.840.113549.1.7.2), found ", string2));
        }
        throw new IOException(b.a((ASN1Sequence)object, b.b.a("Was expecting a DER sequence of length 2, found a DER sequence of length ")));
    }

    public static void writeData(SignedData signedData, OutputStream object) {
        ASN1EncodableVector aSN1EncodableVector;
        OutputStream outputStream = object;
        object = aSN1EncodableVector;
        new ASN1EncodableVector().add(new ASN1ObjectIdentifier(RFC_3369_SIGNED_DATA_OID));
        ((ASN1EncodableVector)object).add(new DERTaggedObject(0, signedData));
        outputStream.write(new DLSequence((ASN1EncodableVector)object).getEncoded("DER"));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ASN1Primitive getContent(SignedData var0) {
        block14: {
            var0 = (ASN1OctetString)var0.getEncapContentInfo().getContent();
            var1_7 = null;
            var2_10 = v0;
            try {
                v0 = new ASN1InputStream(new ByteArrayInputStream(var0.getOctets()));
            }
            catch (Throwable var0_3) {
                break block14;
            }
            catch (IOException var0_4) {
                // empty catch block
                ** GOTO lbl-1000
            }
            try {
                var0 = v0.readObject();
            }
            catch (Throwable var0_1) {
                var1_7 = var2_10;
                break block14;
            }
            catch (IOException var0_2) {
                var1_7 = var2_10;
                ** GOTO lbl-1000
            }
            try {
                v0.close();
                return var0;
            }
            catch (IOException var1_8) {
                SignedDataUtil.LOGGER.log(Level.FINE, "Exception closing input stream", var1_8);
            }
            return var0;
lbl-1000:
            // 2 sources

            {
                SignedDataUtil.LOGGER.log(Level.WARNING, "Unexpected exception", (Throwable)var0);
                if (var1_7 == null) return null;
            }
            try {
                var1_7.close();
                return null;
            }
            catch (IOException var0_5) {
                SignedDataUtil.LOGGER.log(Level.FINE, "Exception closing input stream", var0_5);
            }
            return null;
        }
        if (var1_7 == null) throw var0_6;
        try {
            var1_7.close();
            throw var0_6;
        }
        catch (IOException var1_9) {
            SignedDataUtil.LOGGER.log(Level.FINE, "Exception closing input stream", var1_9);
        }
        throw var0_6;
    }

    public static ASN1Primitive getObjectFromTaggedObject(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            int n = ((ASN1TaggedObject)(aSN1Encodable = (ASN1TaggedObject)aSN1Encodable)).getTagNo();
            if (n == 0) {
                return ((ASN1TaggedObject)aSN1Encodable).getObject();
            }
            throw new IOException(h.a(n, b.b.a("Was expecting tag 0, found ")));
        }
        throw new IOException(b.b.a("Was expecting an ASN1TaggedObject, found ").append(aSN1Encodable.getClass().getCanonicalName()).toString());
    }

    public static String getSignerInfoDigestAlgorithm(SignedData signedData) {
        try {
            return SignedDataUtil.lookupMnemonicByOID(SignedDataUtil.getSignerInfo(signedData).getDigestAlgorithm().getAlgorithm().getId());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOGGER.log(Level.WARNING, "No such algorithm" + noSuchAlgorithmException);
            return null;
        }
    }

    public static AlgorithmParameterSpec getDigestEncryptionAlgorithmParams(SignedData aSN1Encodable) {
        block10: {
            block9: {
                block8: {
                    try {
                        aSN1Encodable = SignedDataUtil.getSignerInfo(aSN1Encodable).getDigestEncryptionAlgorithm();
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, "Cannot get RSASSA/PSS parameters", exception);
                        return null;
                    }
                    if (PKCS1_RSASSA_PSS_OID.equals(((AlgorithmIdentifier)aSN1Encodable).getAlgorithm().getId())) break block8;
                    return null;
                }
                aSN1Encodable = ((AlgorithmIdentifier)aSN1Encodable).getParameters();
                if (aSN1Encodable != null) break block9;
                LOGGER.warning("Cannot get RSASSA/PSS parameters");
                return null;
            }
            aSN1Encodable = RSASSAPSSparams.getInstance(aSN1Encodable);
            if (aSN1Encodable != null) break block10;
            LOGGER.warning("Cannot get RSASSA/PSS parameters");
            return null;
        }
        return SignedDataUtil.toAlgorithmParameterSpec((RSASSAPSSparams)aSN1Encodable);
    }

    public static String getDigestEncryptionAlgorithm(SignedData object) {
        block4: {
            try {
                object = SignedDataUtil.getSignerInfo((SignedData)object).getDigestEncryptionAlgorithm().getAlgorithm().getId();
                if (object != null) break block4;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                LOGGER.log(Level.WARNING, "No such algorithm", noSuchAlgorithmException);
                return null;
            }
            LOGGER.warning("Could not determine digest encryption algorithm OID");
            return null;
        }
        return SignedDataUtil.lookupMnemonicByOID((String)object);
    }

    public static byte[] getEContent(SignedData object) {
        Object object2 = SignedDataUtil.getSignerInfo((SignedData)object);
        ASN1Set aSN1Set = ((SignerInfo)object2).getAuthenticatedAttributes();
        object = ((ASN1OctetString)((SignedData)object).getEncapContentInfo().getContent()).getOctets();
        if (aSN1Set.size() == 0) {
            return object;
        }
        object2 = ((SignerInfo)object2).getDigestAlgorithm().getAlgorithm().getId();
        try {
            byte[] byArray = aSN1Set.getEncoded("DER");
            SignedDataUtil.checkEContent(SignedDataUtil.getAttributes(aSN1Set), (String)object2, (byte[])object);
            return byArray;
        }
        catch (Exception exception) {
            throw new SignatureException(exception);
        }
    }

    public static byte[] getEncryptedDigest(SignedData signedData) {
        return SignedDataUtil.getSignerInfo(signedData).getEncryptedDigest().getOctets();
    }

    public static IssuerAndSerialNumber getIssuerAndSerialNumber(SignedData aSN1Encodable) {
        if (!((aSN1Encodable = SignedDataUtil.getSignerInfo(aSN1Encodable).getSID().getId()) instanceof ASN1Sequence) && !(aSN1Encodable instanceof IssuerAndSerialNumber)) {
            return null;
        }
        IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance(aSN1Encodable);
        aSN1Encodable = issuerAndSerialNumber.getName();
        BigInteger bigInteger = issuerAndSerialNumber.getSerialNumber().getValue();
        return new IssuerAndSerialNumber((X500Name)aSN1Encodable, bigInteger);
    }

    public static byte[] getSubjectKeyIdentifier(SignedData aSN1Encodable) {
        if ((aSN1Encodable = SignedDataUtil.getSignerInfo(aSN1Encodable).getSID()) == null) {
            return null;
        }
        if ((aSN1Encodable = ((SignerIdentifier)aSN1Encodable).getId()) != null && aSN1Encodable instanceof ASN1OctetString) {
            return ((ASN1OctetString)aSN1Encodable).getOctets();
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ASN1Primitive> getObjectsFromOctetString(ASN1OctetString object) {
        ByteArrayInputStream byteArrayInputStream;
        ASN1InputStream aSN1InputStream;
        ArrayList arrayList;
        Object object2 = object;
        object = arrayList;
        arrayList = new ArrayList();
        byte[] byArray = ((ASN1OctetString)object2).getOctets();
        ASN1InputStream aSN1InputStream2 = aSN1InputStream;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        aSN1InputStream = new ASN1InputStream(byteArrayInputStream2);
        while (true) {
            ASN1Primitive aSN1Primitive = aSN1InputStream2.readObject();
            if (aSN1Primitive == null) {
                ((InputStream)aSN1InputStream2).close();
                return object;
            }
            ((ArrayList)object).add(aSN1Primitive);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.WARNING, "Exception", iOException);
        }
        return object;
    }

    public static List<X509Certificate> getCertificates(SignedData aSN1Object) {
        ArrayList<X509Certificate> arrayList;
        int n = (aSN1Object = ((SignedData)aSN1Object).getCertificates()) == null ? 0 : ((ASN1Set)aSN1Object).size();
        ArrayList<X509Certificate> arrayList2 = arrayList;
        arrayList = new ArrayList<X509Certificate>(n);
        if (n <= 0) {
            return arrayList2;
        }
        for (int k = 0; k < n; ++k) {
            try {
                arrayList2.add(SignedDataUtil.decodeCertificate(Certificate.getInstance(((ASN1Set)aSN1Object).getObjectAt(k))));
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception in decoding certificate", exception);
            }
            continue;
        }
        return arrayList2;
    }

    public static X509Certificate decodeCertificate(Certificate object) {
        object = ((ASN1Object)object).getEncoded("DER");
        return (X509Certificate)CertificateFactory.getInstance("X.509", Util.getBouncyCastleProvider()).generateCertificate(new ByteArrayInputStream((byte[])object));
    }

    public static SignedData createSignedData(String string2, String string3, String string4, ContentInfo contentInfo, byte[] byArray, X509Certificate x509Certificate) {
        return SignedDataUtil.createSignedData(string2, string3, null, string4, contentInfo, byArray, x509Certificate);
    }

    public static SignedData createSignedData(String object, String object2, AlgorithmParameterSpec object3, String string2, ContentInfo contentInfo, byte[] byArray, X509Certificate x509Certificate) {
        String string3 = object;
        String string4 = object2;
        object = SignedDataUtil.createSingletonSet(SignedDataUtil.createDigestAlgorithms((String)object));
        object2 = SignedDataUtil.createSingletonSet(SignedDataUtil.createCertificate(x509Certificate));
        object3 = SignedDataUtil.createSingletonSet(SignedDataUtil.createSignerInfo(string3, string4, (AlgorithmParameterSpec)object3, string2, contentInfo, byArray, x509Certificate).toASN1Primitive());
        return new SignedData((ASN1Set)object, contentInfo, (ASN1Set)object2, null, (ASN1Set)object3);
    }

    public static SignerInfo createSignerInfo(String string2, String string3, String string4, ContentInfo contentInfo, byte[] byArray, X509Certificate x509Certificate) {
        return SignedDataUtil.createSignerInfo(string2, string3, null, string4, contentInfo, byArray, x509Certificate);
    }

    public static SignerInfo createSignerInfo(String object, String object2, AlgorithmParameterSpec object3, String object4, ContentInfo aSN1Object, byte[] byArray, X509Certificate x509Certificate) {
        if (byArray != null) {
            DEROctetString dEROctetString;
            AlgorithmIdentifier algorithmIdentifier;
            SignerIdentifier signerIdentifier;
            String string2 = object;
            String string3 = object4;
            String string4 = object2;
            AlgorithmParameterSpec algorithmParameterSpec = object3;
            X509Certificate x509Certificate2 = x509Certificate;
            object2 = X500Name.getInstance(x509Certificate2.getIssuerX500Principal().getEncoded());
            object3 = x509Certificate2.getSerialNumber();
            object4 = signerIdentifier;
            signerIdentifier = new SignerIdentifier(new IssuerAndSerialNumber((X500Name)object2, (BigInteger)object3));
            object2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic((String)object)));
            object = SignedDataUtil.getDigestEncryptionAlgorithmObject(string4, algorithmParameterSpec);
            object3 = SignedDataUtil.createAuthenticatedAttributes(string2, string3, aSN1Object);
            aSN1Object = dEROctetString;
            dEROctetString = new DEROctetString(byArray);
            return new SignerInfo((SignerIdentifier)object4, (AlgorithmIdentifier)object2, (ASN1Set)object3, (AlgorithmIdentifier)object, (ASN1OctetString)aSN1Object, null);
        }
        throw new IllegalArgumentException("Encrypted digest cannot be null");
    }

    public static ASN1Set createAuthenticatedAttributes(String object, String object2, ContentInfo aSN1ObjectArray) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        Attribute attribute;
        Attribute attribute2;
        DEROctetString dEROctetString;
        if ("SHA256".equals(object)) {
            object = "SHA-256";
        }
        object = Util.getMessageDigest((String)object).digest(((ASN1OctetString)aSN1ObjectArray.getContent()).getOctets());
        aSN1ObjectArray = dEROctetString;
        dEROctetString = new DEROctetString((byte[])object);
        object = attribute2;
        attribute2 = new Attribute(new ASN1ObjectIdentifier(RFC_3369_CONTENT_TYPE_OID), SignedDataUtil.createSingletonSet(new ASN1ObjectIdentifier((String)object2)));
        object2 = attribute;
        ASN1Object aSN1Object = aSN1ObjectArray;
        aSN1ObjectArray = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(RFC_3369_MESSAGE_DIGEST_OID);
        attribute = new Attribute((ASN1ObjectIdentifier)aSN1ObjectArray, SignedDataUtil.createSingletonSet(aSN1Object));
        ASN1Object[] aSN1ObjectArray2 = new ASN1Object[2];
        aSN1ObjectArray = aSN1ObjectArray2;
        aSN1ObjectArray[0] = ((Attribute)object).toASN1Primitive();
        aSN1ObjectArray2[1] = ((Attribute)object2).toASN1Primitive();
        return new DLSet(aSN1ObjectArray);
    }

    public static ASN1Sequence createDigestAlgorithms(String object) {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic((String)object));
        object = aSN1EncodableVector;
        ((ASN1EncodableVector)object)();
        aSN1EncodableVector.add(aSN1ObjectIdentifier2);
        return new DLSequence((ASN1EncodableVector)object);
    }

    /*
     * Exception decompiling
     */
    public static ASN1Sequence createCertificate(X509Certificate var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] signData(String string2, String string3, String string4, ContentInfo contentInfo, PrivateKey privateKey, String string5) {
        return SignedDataUtil.signData(string2, string3, null, string4, contentInfo, privateKey, string5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] signData(String object, String object2, AlgorithmParameterSpec algorithmParameterSpec, String string2, ContentInfo contentInfo, PrivateKey privateKey, String string3) {
        try {
            object = SignedDataUtil.createAuthenticatedAttributes((String)object, string2, contentInfo).getEncoded("DER");
            Object object3 = object2 = string3 != null ? Signature.getInstance((String)object2, string3) : Signature.getInstance((String)object2);
            if (algorithmParameterSpec != null) {
                ((Signature)object2).setParameter(algorithmParameterSpec);
            }
            Object object4 = object2;
            ((Signature)object2).initSign(privateKey);
            ((Signature)object4).update((byte[])object);
            return ((Signature)object4).sign();
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "Exception", exception);
            return null;
        }
    }

    public static SignerInfo getSignerInfo(SignedData aSN1Object) {
        if ((aSN1Object = ((SignedData)aSN1Object).getSignerInfos()) != null && ((ASN1Set)aSN1Object).size() > 0) {
            if (((ASN1Set)aSN1Object).size() > 1) {
                LOGGER.warning(b.b.a("Found ").append(((ASN1Set)aSN1Object).size()).append(" signerInfos").toString());
            }
            return SignerInfo.getInstance(((ASN1Set)aSN1Object).getObjectAt(0));
        }
        throw new IllegalArgumentException("No signer info in signed data");
    }

    public static String lookupMnemonicByOID(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.equals(X509ObjectIdentifiers.organization.getId())) {
            return "O";
        }
        if (string2.equals(X509ObjectIdentifiers.organizationalUnitName.getId())) {
            return "OU";
        }
        if (string2.equals(X509ObjectIdentifiers.commonName.getId())) {
            return "CN";
        }
        if (string2.equals(X509ObjectIdentifiers.countryName.getId())) {
            return "C";
        }
        if (string2.equals(X509ObjectIdentifiers.stateOrProvinceName.getId())) {
            return "ST";
        }
        if (string2.equals(X509ObjectIdentifiers.localityName.getId())) {
            return "L";
        }
        if (string2.equals(X509ObjectIdentifiers.id_SHA1.getId())) {
            return "SHA-1";
        }
        if (string2.equals(NISTObjectIdentifiers.id_sha224.getId())) {
            return "SHA-224";
        }
        if (string2.equals(NISTObjectIdentifiers.id_sha256.getId())) {
            return "SHA-256";
        }
        if (string2.equals(NISTObjectIdentifiers.id_sha384.getId())) {
            return "SHA-384";
        }
        if (string2.equals(NISTObjectIdentifiers.id_sha512.getId())) {
            return "SHA-512";
        }
        if (string2.equals(X9_SHA1_WITH_ECDSA_OID)) {
            return "SHA1withECDSA";
        }
        if (string2.equals(X9_SHA224_WITH_ECDSA_OID)) {
            return "SHA224withECDSA";
        }
        if (string2.equals(X9_SHA256_WITH_ECDSA_OID)) {
            return "SHA256withECDSA";
        }
        if (string2.equals(X9_SHA384_WITH_ECDSA_OID)) {
            return "SHA384withECDSA";
        }
        if (string2.equals(X9_SHA512_WITH_ECDSA_OID)) {
            return "SHA512withECDSA";
        }
        if (string2.equals(PKCS1_RSA_OID)) {
            return "RSA";
        }
        if (string2.equals(PKCS1_MD2_WITH_RSA_OID)) {
            return "MD2withRSA";
        }
        if (string2.equals(PKCS1_MD4_WITH_RSA_OID)) {
            return "MD4withRSA";
        }
        if (string2.equals(PKCS1_MD5_WITH_RSA_OID)) {
            return "MD5withRSA";
        }
        if (string2.equals(PKCS1_SHA1_WITH_RSA_OID)) {
            return "SHA1withRSA";
        }
        if (string2.equals(PKCS1_SHA256_WITH_RSA_OID)) {
            return "SHA256withRSA";
        }
        if (string2.equals(PKCS1_SHA384_WITH_RSA_OID)) {
            return "SHA384withRSA";
        }
        if (string2.equals(PKCS1_SHA512_WITH_RSA_OID)) {
            return "SHA512withRSA";
        }
        if (string2.equals(PKCS1_SHA224_WITH_RSA_OID)) {
            return "SHA224withRSA";
        }
        if (string2.equals(IEEE_P1363_SHA1_OID)) {
            return "SHA-1";
        }
        if (string2.equals(PKCS1_RSASSA_PSS_OID)) {
            return "SSAwithRSA/PSS";
        }
        if (string2.equals(PKCS1_MGF1)) {
            return "MGF1";
        }
        throw new NoSuchAlgorithmException(i.a("Unknown OID ", string2));
    }

    public static String lookupOIDByMnemonic(String string2) {
        if ("O".equals(string2)) {
            return X509ObjectIdentifiers.organization.getId();
        }
        if ("OU".equals(string2)) {
            return X509ObjectIdentifiers.organizationalUnitName.getId();
        }
        if ("CN".equals(string2)) {
            return X509ObjectIdentifiers.commonName.getId();
        }
        if ("C".equals(string2)) {
            return X509ObjectIdentifiers.countryName.getId();
        }
        if ("ST".equals(string2)) {
            return X509ObjectIdentifiers.stateOrProvinceName.getId();
        }
        if ("L".equals(string2)) {
            return X509ObjectIdentifiers.localityName.getId();
        }
        if (!"SHA-1".equalsIgnoreCase(string2) && !"SHA1".equalsIgnoreCase(string2)) {
            if (!"SHA-224".equalsIgnoreCase(string2) && !"SHA224".equalsIgnoreCase(string2)) {
                if (!"SHA-256".equalsIgnoreCase(string2) && !"SHA256".equalsIgnoreCase(string2)) {
                    if (!"SHA-384".equalsIgnoreCase(string2) && !"SHA384".equalsIgnoreCase(string2)) {
                        if (!"SHA-512".equalsIgnoreCase(string2) && !"SHA512".equalsIgnoreCase(string2)) {
                            if ("RSA".equalsIgnoreCase(string2)) {
                                return PKCS1_RSA_OID;
                            }
                            if ("MD2withRSA".equalsIgnoreCase(string2)) {
                                return PKCS1_MD2_WITH_RSA_OID;
                            }
                            if ("MD4withRSA".equalsIgnoreCase(string2)) {
                                return PKCS1_MD4_WITH_RSA_OID;
                            }
                            if ("MD5withRSA".equalsIgnoreCase(string2)) {
                                return PKCS1_MD5_WITH_RSA_OID;
                            }
                            if ("SHA1withRSA".equalsIgnoreCase(string2)) {
                                return PKCS1_SHA1_WITH_RSA_OID;
                            }
                            if ("SHA256withRSA".equalsIgnoreCase(string2)) {
                                return PKCS1_SHA256_WITH_RSA_OID;
                            }
                            if ("SHA384withRSA".equalsIgnoreCase(string2)) {
                                return PKCS1_SHA384_WITH_RSA_OID;
                            }
                            if ("SHA512withRSA".equalsIgnoreCase(string2)) {
                                return PKCS1_SHA512_WITH_RSA_OID;
                            }
                            if ("SHA224withRSA".equalsIgnoreCase(string2)) {
                                return PKCS1_SHA224_WITH_RSA_OID;
                            }
                            if ("SHA1withECDSA".equalsIgnoreCase(string2)) {
                                return X9_SHA1_WITH_ECDSA_OID;
                            }
                            if ("SHA224withECDSA".equalsIgnoreCase(string2)) {
                                return X9_SHA224_WITH_ECDSA_OID;
                            }
                            if ("SHA256withECDSA".equalsIgnoreCase(string2)) {
                                return X9_SHA256_WITH_ECDSA_OID;
                            }
                            if ("SHA384withECDSA".equalsIgnoreCase(string2)) {
                                return X9_SHA384_WITH_ECDSA_OID;
                            }
                            if ("SHA512withECDSA".equalsIgnoreCase(string2)) {
                                return X9_SHA512_WITH_ECDSA_OID;
                            }
                            if ("SAwithRSA/PSS".equalsIgnoreCase(string2)) {
                                return PKCS1_RSASSA_PSS_OID;
                            }
                            if ("SSAwithRSA/PSS".equalsIgnoreCase(string2)) {
                                return PKCS1_RSASSA_PSS_OID;
                            }
                            if ("RSASSA-PSS".equalsIgnoreCase(string2)) {
                                return PKCS1_RSASSA_PSS_OID;
                            }
                            if ("MGF1".equalsIgnoreCase(string2)) {
                                return PKCS1_MGF1;
                            }
                            if ("SHA256withRSAandMGF1".equalsIgnoreCase(string2)) {
                                return PKCS1_MGF1;
                            }
                            if ("SHA512withRSAandMGF1".equalsIgnoreCase(string2)) {
                                return PKCS1_MGF1;
                            }
                            throw new NoSuchAlgorithmException(i.a("Unknown name ", string2));
                        }
                        return NISTObjectIdentifiers.id_sha512.getId();
                    }
                    return NISTObjectIdentifiers.id_sha384.getId();
                }
                return NISTObjectIdentifiers.id_sha256.getId();
            }
            return NISTObjectIdentifiers.id_sha224.getId();
        }
        return X509ObjectIdentifiers.id_SHA1.getId();
    }

    private static void checkEContent(Collection<Attribute> object, String string2, byte[] byArray) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Attribute)object.next();
            if (!RFC_3369_MESSAGE_DIGEST_OID.equals(((Attribute)object2).getAttrType().getId())) continue;
            if (((ASN1Set)(object2 = ((Attribute)object2).getAttrValues())).size() != 1) {
                LOGGER.warning("Expected only one attribute value in signedAttribute message digest in eContent!");
            }
            byte[] byArray2 = ((ASN1OctetString)((ASN1Set)object2).getObjectAt(0)).getOctets();
            object2 = byArray2;
            if (byArray2 == null) {
                LOGGER.warning("Error extracting signedAttribute message digest in eContent!");
            }
            if (Arrays.equals((byte[])object2, MessageDigest.getInstance(string2).digest(byArray))) continue;
            throw new SignatureException("Error checking signedAttribute message digest in eContent!");
        }
    }

    private static List<Attribute> getAttributes(ASN1Set object) {
        ArrayList<Attribute> arrayList;
        object = Collections.list(((ASN1Set)object).getObjects());
        ArrayList<Attribute> arrayList2 = arrayList;
        arrayList = new ArrayList<Attribute>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList2.add(Attribute.getInstance((ASN1Sequence)object.next()));
        }
        return arrayList2;
    }

    private static AlgorithmParameterSpec toAlgorithmParameterSpec(RSASSAPSSparams object) {
        if (object == null) {
            return null;
        }
        Object object2 = ((RSASSAPSSparams)object).getMaskGenAlgorithm();
        String string2 = ((AlgorithmIdentifier)object2).getAlgorithm().getId();
        String string3 = SignedDataUtil.lookupMnemonicByOID(((RSASSAPSSparams)object).getHashAlgorithm().getAlgorithm().getId());
        RSASSAPSSparams rSASSAPSSparams = object;
        object = SignedDataUtil.lookupMnemonicByOID(string2);
        int n = rSASSAPSSparams.getSaltLength().intValue();
        int n2 = rSASSAPSSparams.getTrailerField().intValue();
        if (string3 != null && object != null && n >= 0 && n2 >= 0) {
            object2 = SignedDataUtil.toMaskGenAlgorithmParameterSpec((AlgorithmIdentifier)object2);
            return new PSSParameterSpec(string3, (String)object, (AlgorithmParameterSpec)object2, n, n2);
        }
        LOGGER.warning("Cannot get RSASSA/PSS parameters");
        return null;
    }

    private static AlgorithmParameterSpec toMaskGenAlgorithmParameterSpec(AlgorithmIdentifier object) {
        block4: {
            object = ((AlgorithmIdentifier)object).getParameters();
            if (object == null) break block4;
            object = SignedDataUtil.lookupMnemonicByOID(AlgorithmIdentifier.getInstance(object).getAlgorithm().getId());
            try {
                return new MGF1ParameterSpec((String)object);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Exception", exception);
            }
        }
        return new MGF1ParameterSpec("SHA-1");
    }

    private static AlgorithmIdentifier getDigestEncryptionAlgorithmObject(String object, AlgorithmParameterSpec algorithmParameterSpec) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(SignedDataUtil.lookupOIDByMnemonic((String)object));
        if (algorithmParameterSpec == null) {
            return new AlgorithmIdentifier(aSN1ObjectIdentifier2);
        }
        try {
            object = AlgorithmParameters.getInstance((String)object);
        }
        catch (IOException iOException) {
            throw new InvalidAlgorithmParameterException("Unable to encode parameters object", iOException);
        }
        ((AlgorithmParameters)object).init(algorithmParameterSpec);
        return new AlgorithmIdentifier(aSN1ObjectIdentifier2, ASN1Primitive.fromByteArray(((AlgorithmParameters)object).getEncoded()));
    }

    private static ASN1Set createSingletonSet(ASN1Object aSN1Object) {
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[1];
        ASN1Encodable[] aSN1EncodableArray2 = aSN1EncodableArray;
        aSN1EncodableArray[0] = aSN1Object;
        return new DLSet(aSN1EncodableArray2);
    }
}

