/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.codescanner;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.media.Image;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.codescanner.FrameMetadata;

public final class BitmapUtils {
    @NotNull
    public static final BitmapUtils INSTANCE = new BitmapUtils();
    @NotNull
    private static final String TAG = "BitmapUtils";

    private BitmapUtils() {
    }

    private final Bitmap rotateBitmap(Bitmap bitmap, int n, boolean bl, boolean bl2) {
        Matrix matrix;
        BitmapUtils bitmapUtils = matrix;
        bitmapUtils();
        matrix.postRotate((float)n);
        float f2 = bl ? -1.0f : 1.0f;
        float f3 = bl2 ? -1.0f : 1.0f;
        Bitmap bitmap2 = bitmap;
        bitmapUtils.postScale(f2, f3);
        int n2 = bitmap2.getWidth();
        int n3 = bitmap2.getHeight();
        bitmapUtils = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n2, (int)n3, (Matrix)bitmapUtils, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmapUtils, (String)"createBitmap(bitmap, 0, \u2026map.height, matrix, true)");
        if (!Intrinsics.areEqual((Object)bitmapUtils, (Object)bitmap)) {
            bitmap.recycle();
        }
        return bitmapUtils;
    }

    /*
     * Exception decompiling
     */
    private final int getExifOrientationTag(ContentResolver var1_2, Uri var2_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final ByteBuffer yuv420ThreePlanesToNV21(Image.Plane[] planeArray, int n, int n2) {
        int n3 = n * n2;
        byte[] byArray = new byte[n3 / 4 * 2 + n3];
        if (this.areUVPlanesNV21(planeArray, n, n2)) {
            planeArray[0].getBuffer().get(byArray, 0, n3);
            ByteBuffer byteBuffer = planeArray[1].getBuffer();
            planeArray[2].getBuffer().get(byArray, n3, 1);
            int n4 = n3 + 1;
            byteBuffer.get(byArray, n4, n3 * 2 / 4 - 1);
        } else {
            this.unpackPlane(planeArray[0], n, n2, byArray, 0, 1);
            int n5 = n3 + 1;
            this.unpackPlane(planeArray[1], n, n2, byArray, n5, 2);
            this.unpackPlane(planeArray[2], n, n2, byArray, n3, 2);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"wrap(out)");
        return byteBuffer;
    }

    private final boolean areUVPlanesNV21(Image.Plane[] object, int n, int n2) {
        int n3 = n * n2;
        ByteBuffer byteBuffer = object[1].getBuffer();
        object = object[2].getBuffer();
        n2 = ((Buffer)object).position();
        int n4 = byteBuffer.limit();
        ((ByteBuffer)object).position(n2 + 1);
        byteBuffer.limit(n4 - 1);
        boolean bl = ((Buffer)object).remaining() == n3 * 2 / 4 - 2 && ((ByteBuffer)object).compareTo(byteBuffer) == 0;
        ((ByteBuffer)object).position(n2);
        byteBuffer.limit(n4);
        return bl;
    }

    private final void unpackPlane(Image.Plane plane, int n, int n2, byte[] byArray, int n3, int n4) {
        Image.Plane plane2 = plane;
        ByteBuffer byteBuffer = plane2.getBuffer();
        byteBuffer.rewind();
        int n5 = byteBuffer.limit();
        n5 = (plane2.getRowStride() + n5 - 1) / plane.getRowStride();
        if (n5 == 0) {
            return;
        }
        n /= n2 / n5;
        n2 = 0;
        for (int k = 0; k < n5; ++k) {
            int n6 = n2;
            for (int i2 = 0; i2 < n; ++i2) {
                byArray[n3] = byteBuffer.get(n6);
                n3 += n4;
                n6 = plane.getPixelStride() + n6;
            }
            n2 = plane.getRowStride() + n2;
        }
    }

    @Nullable
    public final Bitmap getBitmap(@NotNull ByteBuffer object, @NotNull FrameMetadata frameMetadata) {
        ByteArrayOutputStream byteArrayOutputStream;
        int n;
        ByteBuffer byteBuffer = object;
        Intrinsics.checkNotNullParameter((Object)object, (String)"data");
        Intrinsics.checkNotNullParameter((Object)frameMetadata, (String)"metadata");
        byteBuffer.rewind();
        int n2 = byteBuffer.limit();
        byte[] byArray = new byte[n2];
        object = byArray;
        byteBuffer.get(byArray, 0, n2);
        FrameMetadata frameMetadata2 = frameMetadata;
        n2 = 17;
        try {
            n = frameMetadata2.getWidth();
        }
        catch (Exception exception) {
            Log.e((String)"VisionProcessorBase", (String)("Error: " + exception.getMessage()));
            return null;
        }
        int n3 = frameMetadata2.getHeight();
        YuvImage yuvImage = new YuvImage((byte[])object, n2, n, n3, null);
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        FrameMetadata frameMetadata3 = frameMetadata;
        n = 0;
        int n4 = 0;
        n3 = frameMetadata3.getWidth();
        int n5 = frameMetadata3.getHeight();
        Rect rect = new Rect(n, n4, n3, n5);
        yuvImage.compressToJpeg(rect, 80, (OutputStream)byteArrayOutputStream2);
        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
        n = 0;
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)n, (int)byteArrayOutputStream2.size());
        byteArrayOutputStream2.close();
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"bmp");
        return this.rotateBitmap(bitmap, frameMetadata.getRotation(), false, false);
    }

    @ExperimentalGetImage
    @Nullable
    public final Bitmap getBitmap(@NotNull ImageProxy planeArray) {
        BitmapUtils bitmapUtils = frameMetadata;
        Image.Plane[] planeArray2 = planeArray;
        Image.Plane[] planeArray3 = planeArray;
        Intrinsics.checkNotNullParameter((Object)planeArray2, (String)"image");
        FrameMetadata frameMetadata = new FrameMetadata.Builder().setWidth(planeArray.getWidth()).setHeight(planeArray.getHeight()).setRotation(planeArray.getImageInfo().getRotationDegrees()).build();
        Image image = planeArray3.getImage();
        Intrinsics.checkNotNull((Object)image);
        planeArray = image.getPlanes();
        Intrinsics.checkNotNullExpressionValue((Object)planeArray, (String)"image.image!!.planes");
        int n = planeArray2.getWidth();
        int n2 = planeArray3.getHeight();
        return bitmapUtils.getBitmap(bitmapUtils.yuv420ThreePlanesToNV21(planeArray, n, n2), frameMetadata);
    }

    @Nullable
    public final Bitmap getBitmapFromContentUri(@NotNull ContentResolver contentResolver, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"imageUri");
        Bitmap bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)contentResolver, (Uri)uri);
        if (bitmap == null) {
            return null;
        }
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        switch (this.getExifOrientationTag(contentResolver, uri)) {
            default: {
                break;
            }
            case 8: {
                n = -90;
                break;
            }
            case 7: {
                n = -90;
                bl = true;
                break;
            }
            case 6: {
                n = 90;
                break;
            }
            case 5: {
                n = 90;
                bl = true;
                break;
            }
            case 4: {
                bl2 = true;
                break;
            }
            case 3: {
                n = 180;
                break;
            }
            case 2: {
                bl = true;
            }
        }
        return this.rotateBitmap(bitmap, n, bl, bl2);
    }
}

