/*
 * Decompiled with CFR 0.152.
 */
package vn.kalapa.ekyc.views;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vn.kalapa.ekyc.utils.Common;
import vn.kalapa.ekyc.views.KalapaLivenessProgressView;

public final class KalapaLivenessProgressView
extends View {
    @NotNull
    private final Paint paint;
    @Nullable
    private ValueAnimator progressAnimator;
    private float currentProgress;
    @NotNull
    private final RectF rectF;
    private int currentPart;
    @NotNull
    private Common.LIVENESS_VERSION livenessVersion;
    private int totalParts;
    @NotNull
    private Map<Integer, Float> completedProgress;
    private int successfulColor;
    private int failureColor;
    private int progressColor;
    private final int backgroundColor;
    private boolean isLastStepInProgress;

    @JvmOverloads
    public KalapaLivenessProgressView(@NotNull Context context, @Nullable AttributeSet attributeSet, int n) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2, attributeSet, n);
        Paint paint = new Paint(1);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(24.0f);
        paint.setStrokeCap(Paint.Cap.ROUND);
        paint.setStrokeJoin(Paint.Join.ROUND);
        this.paint = paint;
        this.rectF = new RectF();
        this.currentPart = 1;
        this.livenessVersion = Common.LIVENESS_VERSION.PASSIVE;
        this.totalParts = 1;
        this.completedProgress = new LinkedHashMap<Integer, Float>();
        this.successfulColor = -16711936;
        this.failureColor = -65536;
        this.progressColor = -16711936;
        this.backgroundColor = -3355444;
    }

    public /* synthetic */ KalapaLivenessProgressView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    private final void startAnim(long l, Function0<Unit> function0) {
        ValueAnimator valueAnimator = this.progressAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator2.setDuration(l);
        valueAnimator2.setInterpolator((TimeInterpolator)new FastOutSlowInInterpolator());
        valueAnimator2.addUpdateListener(arg_0 -> KalapaLivenessProgressView.startAnim$lambda$2$lambda$1(this, arg_0));
        valueAnimator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, function0){
            public final /* synthetic */ KalapaLivenessProgressView this$0;
            public final /* synthetic */ Function0<Unit> $onAnimationEnd;
            {
                this.this$0 = kalapaLivenessProgressView;
                this.$onAnimationEnd = function0;
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                Function0<Unit> function0 = function02;
                Intrinsics.checkNotNullParameter((Object)animator, (String)"animation");
                KalapaLivenessProgressView.access$getCompletedProgress$p(function0.this$0).put(KalapaLivenessProgressView.access$getCurrentPart$p(function02.this$0), Float.valueOf(1.0f));
                Function0<Unit> function02 = function0.$onAnimationEnd;
                if (function02 != null) {
                    function02.invoke();
                }
            }
        });
        valueAnimator2.start();
        this.progressAnimator = valueAnimator2;
    }

    public static /* synthetic */ void startAnim$default(KalapaLivenessProgressView kalapaLivenessProgressView, long l, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            l = 2000L;
        }
        if ((n & 2) != 0) {
            function0 = null;
        }
        kalapaLivenessProgressView.startAnim(l, (Function0<Unit>)function0);
    }

    public static /* synthetic */ void nextPart$default(KalapaLivenessProgressView kalapaLivenessProgressView, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 600L;
        }
        kalapaLivenessProgressView.nextPart(l);
    }

    public static /* synthetic */ void progressFail$default(KalapaLivenessProgressView kalapaLivenessProgressView, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = 2000L;
        }
        kalapaLivenessProgressView.progressFail(l);
    }

    @JvmOverloads
    public KalapaLivenessProgressView(@NotNull Context context, @Nullable AttributeSet attributeSet) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attributeSet, 0, 4, null);
    }

    @JvmOverloads
    public KalapaLivenessProgressView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void startAnim$lambda$2$lambda$1(KalapaLivenessProgressView kalapaLivenessProgressView, ValueAnimator valueAnimator) {
        ValueAnimator valueAnimator2 = valueAnimator;
        Intrinsics.checkNotNullParameter((Object)((Object)kalapaLivenessProgressView), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)valueAnimator2, (String)"animator");
        Object object = valueAnimator2.getAnimatedValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
        kalapaLivenessProgressView.currentProgress = ((Float)object).floatValue();
        kalapaLivenessProgressView.invalidate();
    }

    public static final /* synthetic */ int access$getCurrentPart$p(KalapaLivenessProgressView kalapaLivenessProgressView) {
        return kalapaLivenessProgressView.currentPart;
    }

    public static final /* synthetic */ int access$getTotalParts$p(KalapaLivenessProgressView kalapaLivenessProgressView) {
        return kalapaLivenessProgressView.totalParts;
    }

    public static final /* synthetic */ void access$setCurrentPart$p(KalapaLivenessProgressView kalapaLivenessProgressView, int n) {
        kalapaLivenessProgressView.currentPart = n;
    }

    public static final /* synthetic */ void access$setCurrentProgress$p(KalapaLivenessProgressView kalapaLivenessProgressView, float f2) {
        kalapaLivenessProgressView.currentProgress = f2;
    }

    public static final /* synthetic */ void access$setLastStepInProgress$p(KalapaLivenessProgressView kalapaLivenessProgressView, boolean bl) {
        kalapaLivenessProgressView.isLastStepInProgress = bl;
    }

    public static final /* synthetic */ Map access$getCompletedProgress$p(KalapaLivenessProgressView kalapaLivenessProgressView) {
        return kalapaLivenessProgressView.completedProgress;
    }

    public final void setSuccessfulColor(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"color");
        try {
            this.successfulColor = Color.parseColor((String)string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final void setFailureColor(@NotNull String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"color");
        try {
            this.failureColor = Color.parseColor((String)string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onSizeChanged(int n, int n2, int n3, int n4) {
        KalapaLivenessProgressView kalapaLivenessProgressView = this;
        super.onSizeChanged(n, n2, n3, n4);
        float f2 = kalapaLivenessProgressView.paint.getStrokeWidth() / (float)2;
        float f3 = (float)n - f2;
        float f4 = (float)n2 - f2;
        kalapaLivenessProgressView.rectF.set(f2, f2, f3, f4);
    }

    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(@NotNull Canvas canvas) {
        KalapaLivenessProgressView kalapaLivenessProgressView = this;
        KalapaLivenessProgressView kalapaLivenessProgressView2 = this;
        Canvas canvas2 = canvas;
        Intrinsics.checkNotNullParameter((Object)canvas2, (String)"canvas");
        super.onDraw(canvas2);
        float f2 = (float)kalapaLivenessProgressView2.getWidth() / 2.0f;
        float f3 = (float)kalapaLivenessProgressView2.getHeight() / 2.0f;
        float f4 = (float)(RangesKt.coerceAtLeast((int)kalapaLivenessProgressView2.getWidth(), (int)this.getHeight()) / 2) - this.paint.getStrokeWidth() / (float)2;
        kalapaLivenessProgressView2.paint.setColor(this.backgroundColor);
        Paint paint = kalapaLivenessProgressView2.paint;
        canvas.drawCircle(f2, f3, f4, paint);
        kalapaLivenessProgressView.paint.setColor(this.progressColor);
        f2 = 360.0f / (float)kalapaLivenessProgressView.totalParts;
        int n = kalapaLivenessProgressView.currentPart;
        for (int k = 1; k < n; ++k) {
            KalapaLivenessProgressView kalapaLivenessProgressView3 = this;
            float f5 = (float)(k - 1) * f2 + -90.0f;
            RectF rectF = kalapaLivenessProgressView3.rectF;
            Paint paint2 = kalapaLivenessProgressView3.paint;
            canvas.drawArc(rectF, f5, f2, false, paint2);
        }
        KalapaLivenessProgressView kalapaLivenessProgressView4 = this;
        float f6 = (float)(kalapaLivenessProgressView4.currentPart - 1) * f2 + -90.0f;
        float f7 = kalapaLivenessProgressView4.currentProgress * f2;
        RectF rectF = kalapaLivenessProgressView4.rectF;
        Paint paint3 = kalapaLivenessProgressView4.paint;
        canvas.drawArc(rectF, f6, f7, false, paint3);
    }

    public final void nextPart(long l) {
        int n = this.currentPart;
        int n2 = this.totalParts;
        if (n <= n2) {
            Function0<Unit> function0;
            if (n == n2 && this.isLastStepInProgress) {
                return;
            }
            this.progressColor = this.successfulColor;
            if (n == n2) {
                this.isLastStepInProgress = true;
            }
            Function0<Unit> function02 = function0;
            function0 = new Function0<Unit>(this){
                public final /* synthetic */ KalapaLivenessProgressView this$0;
                {
                    this.this$0 = kalapaLivenessProgressView;
                    super(0);
                }

                public final void invoke() {
                    if (KalapaLivenessProgressView.access$getCurrentPart$p(this.this$0) < KalapaLivenessProgressView.access$getTotalParts$p(this.this$0)) {
                        nextPart.1 v0 = this;
                        KalapaLivenessProgressView kalapaLivenessProgressView = v0.this$0;
                        KalapaLivenessProgressView.access$setCurrentPart$p(kalapaLivenessProgressView, KalapaLivenessProgressView.access$getCurrentPart$p(kalapaLivenessProgressView) + 1);
                        KalapaLivenessProgressView.access$setCurrentProgress$p(v0.this$0, 0.0f);
                    }
                    if (KalapaLivenessProgressView.access$getCurrentPart$p(this.this$0) == KalapaLivenessProgressView.access$getTotalParts$p(this.this$0)) {
                        KalapaLivenessProgressView.access$setLastStepInProgress$p(this.this$0, false);
                    }
                }
            };
            this.startAnim(l, function02);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setLivenessVersion(@NotNull Common.LIVENESS_VERSION lIVENESS_VERSION) {
        Common.LIVENESS_VERSION lIVENESS_VERSION2 = lIVENESS_VERSION;
        Intrinsics.checkNotNullParameter((Object)((Object)lIVENESS_VERSION2), (String)"version");
        this.livenessVersion = lIVENESS_VERSION2;
        int n = WhenMappings.$EnumSwitchMapping$0[lIVENESS_VERSION.ordinal()];
        if (n != 1) {
            if (n != 2) {
                if (n != 3) throw new NoWhenBranchMatchedException();
                n = 3;
            } else {
                n = 2;
            }
        } else {
            n = 1;
        }
        KalapaLivenessProgressView kalapaLivenessProgressView = this;
        kalapaLivenessProgressView.totalParts = n;
        kalapaLivenessProgressView.currentPart = 1;
        kalapaLivenessProgressView.completedProgress.clear();
        kalapaLivenessProgressView.stopProgress();
    }

    public final void progressFail(long l) {
        KalapaLivenessProgressView kalapaLivenessProgressView = this;
        kalapaLivenessProgressView.progressColor = kalapaLivenessProgressView.failureColor;
        kalapaLivenessProgressView.currentPart = 0;
        kalapaLivenessProgressView.totalParts = 1;
        kalapaLivenessProgressView.completedProgress.clear();
        kalapaLivenessProgressView.isLastStepInProgress = false;
        KalapaLivenessProgressView.startAnim$default(this, l, null, 2, null);
    }

    public final void stopProgress() {
        ValueAnimator valueAnimator = this.progressAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        this.currentProgress = 0.0f;
        this.invalidate();
    }

    public final void resetProgress() {
        ValueAnimator valueAnimator = this.progressAnimator;
        if (valueAnimator != null) {
            valueAnimator.cancel();
        }
        KalapaLivenessProgressView kalapaLivenessProgressView = this;
        kalapaLivenessProgressView.currentProgress = 0.0f;
        kalapaLivenessProgressView.currentPart = 1;
        kalapaLivenessProgressView.progressColor = kalapaLivenessProgressView.successfulColor;
        kalapaLivenessProgressView.isLastStepInProgress = false;
        kalapaLivenessProgressView.setLivenessVersion(kalapaLivenessProgressView.livenessVersion);
        kalapaLivenessProgressView.completedProgress.clear();
        kalapaLivenessProgressView.isLastStepInProgress = false;
        kalapaLivenessProgressView.invalidate();
    }

    public void onDetachedFromWindow() {
        KalapaLivenessProgressView kalapaLivenessProgressView = kalapaLivenessProgressView2;
        super.onDetachedFromWindow();
        KalapaLivenessProgressView kalapaLivenessProgressView2 = kalapaLivenessProgressView.progressAnimator;
        if (kalapaLivenessProgressView2 != null) {
            kalapaLivenessProgressView2.cancel();
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Common.LIVENESS_VERSION.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[Common.LIVENESS_VERSION.PASSIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Common.LIVENESS_VERSION.SEMI_ACTIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[Common.LIVENESS_VERSION.ACTIVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
        }
    }
}

