package vn.kalapa.ekyc.utils

import android.content.Context

interface KalapaLogger {

    fun logEvent(
        logLevel: KALAPA_LOG_LEVEL,
        action: KALAPA_LOG_ACTION,
        screenId: String,
        data: Map<String?, String?>? = null
    )

    fun endSession(
        data: Map<String?, String?>? = null
    )

}

object LogUtil {
    private var latestTimestamp = 0L
    internal fun logEvent(
        context: Context,
        logLevel: KALAPA_LOG_LEVEL,
        action: KALAPA_LOG_ACTION,
        screenId: String,
        data: Map<String?, String?>? = null,
        shouldUpdateTimeStamp: Boolean = true
    ) {
        val app = context.applicationContext as? KalapaLogger
        val myData = data?.toMutableMap() ?: mutableMapOf()
        if (shouldUpdateTimeStamp) {
            myData["time_since_last_action"] = if (latestTimestamp != 0L) "${System.currentTimeMillis() - latestTimestamp}" else "0"
            latestTimestamp = System.currentTimeMillis()
        } else {
            myData["time_since_last_action"] = if (latestTimestamp != 0L) "$latestTimestamp" else "0"
        }

        app?.logEvent(
            logLevel,
            action,
            screenId,
            myData
        )
    }

    internal fun logEndSession(
        context: Context,
        action: KALAPA_LOG_ACTION,
        screenId: String,
        data: Map<String?, String?>? = null
    ) {
        val app = context.applicationContext as? KalapaLogger
        logEvent(context, KALAPA_LOG_LEVEL.INFO, action, screenId, data, false)
        latestTimestamp = 0L
        app?.endSession(data)
    }
}