/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in;

import android.graphics.Bitmap;
import android.nfc.tech.IsoDep;
import android.text.TextUtils;
import android.util.Log;
import com.fis.ekyc.nfc.build_in.eidparser.ICaoReaderParser;
import com.fis.ekyc.nfc.build_in.eidparser.lds.icao.MRZInfo;
import com.fis.ekyc.nfc.build_in.model.CardResult;
import com.fis.ekyc.nfc.build_in.model.MRZResult;
import com.fis.ekyc.nfc.build_in.model.ResultCode;
import com.fis.ekyc.nfc.build_in.scuba.smartcards.CardService;
import com.fis.ekyc.nfc.build_in.utils.Base64Util;

public class IDCardReader {
    private static final String TAG = "IDCardReader";

    public MRZResult parseMRZImage(String string2, Bitmap object) {
        MRZResult mRZResult;
        Object object2;
        int n3;
        MRZInfo mRZInfo;
        if (object == null) {
            return null;
        }
        MRZInfo mRZInfo2 = mRZInfo;
        if ((string2 = new MRZInfo(string2).getDocumentNumber()).length() == 9 && !TextUtils.isEmpty((CharSequence)mRZInfo2.getOptionalData1()) && (n3 = ((String)(object2 = mRZInfo2.getOptionalData1())).indexOf(string2)) >= 3) {
            string2 = ((String)object2).substring(n3 - 3, 12);
        }
        if (string2.length() < 12) {
            return null;
        }
        string2 = string2.replace("O", "0");
        object = Base64Util.convertBitmapToBase64(object);
        object2 = mRZResult;
        ((MRZResult)object2)();
        ((MRZResult)object2).setImageBase64((String)object);
        ((MRZResult)object2).setCccdId(string2);
        ((MRZResult)object2).setExpireDate(mRZInfo2.getDateOfExpiry());
        mRZResult.setIssueDate(mRZInfo2.getDateOfBirth());
        return mRZResult;
    }

    public CardResult readData(CardService cardService, String string2, boolean bl, boolean bl2, boolean bl3) {
        return new ICaoReaderParser().readData(cardService, string2, bl, bl2, bl3);
    }

    public CardResult readData(IsoDep isoDep, String string2, boolean bl, boolean bl2, boolean bl3) {
        try {
            CardService cardService = CardService.getInstance(isoDep);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.e((String)TAG, (String)"Error", (Throwable)exception);
            CardResult cardResult = new CardResult();
            cardResult.setCode(ResultCode.CANNOT_OPEN_DEVICE);
            return cardResult;
        }
        return new ICaoReaderParser().readData(cardService, string2, bl, bl2, bl3);
    }
}

