/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ParsingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class ASN1BitString
extends ASN1Primitive
implements ASN1String {
    private static final char[] table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public final byte[] data;
    public final int padBits;

    public static int getPadBits(int n3) {
        int n4 = 0;
        for (int i3 = 3; i3 >= 0; --i3) {
            if (i3 != 0) {
                int n5 = n3 >> i3 * 8;
                if (n5 == 0) continue;
                n4 = n5 & 0xFF;
                break;
            }
            if (n3 == 0) continue;
            n4 = n3 & 0xFF;
            break;
        }
        if (n4 == 0) {
            return 0;
        }
        n3 = 1;
        while (((n4 <<= 1) & 0xFF) != 0) {
            ++n3;
        }
        return 8 - n3;
    }

    public static byte[] getBytes(int n3) {
        if (n3 == 0) {
            return new byte[0];
        }
        int n4 = 4;
        for (int i3 = 3; i3 >= 1 && (n3 & 255 << i3 * 8) == 0; --i3) {
            --n4;
        }
        byte[] byArray = new byte[n4];
        for (int i4 = 0; i4 < n4; ++i4) {
            byArray[i4] = (byte)(n3 >> i4 * 8 & 0xFF);
        }
        return byArray;
    }

    public ASN1BitString(byte by, int n3) {
        if (n3 <= 7 && n3 >= 0) {
            ASN1BitString aSN1BitString = object;
            byte[] byArray = new byte[1];
            Object object = byArray;
            byArray[0] = by;
            aSN1BitString.data = (byte[])object;
            aSN1BitString.padBits = n3;
            return;
        }
        throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
    }

    public ASN1BitString(byte[] byArray, int n3) {
        if (byArray != null) {
            if (byArray.length == 0 && n3 != 0) {
                throw new IllegalArgumentException("zero length data with non-zero pad bits");
            }
            if (n3 <= 7 && n3 >= 0) {
                this.data = Arrays.clone(byArray);
                this.padBits = n3;
                return;
            }
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        throw new NullPointerException("'data' cannot be null");
    }

    public static ASN1BitString fromInputStream(int n3, InputStream inputStream) {
        if (n3 >= 1) {
            int n4 = n3;
            n3 = inputStream.read();
            int n5 = n4 - 1;
            byte[] byArray = new byte[n5];
            if (n5 != 0) {
                if (Streams.readFully(inputStream, byArray) == n5) {
                    if (n3 > 0 && n3 < 8) {
                        byte by = byArray[n5 - 1];
                        if (by != (byte)(by & 255 << n3)) {
                            return new DLBitString(byArray, n3);
                        }
                    }
                } else {
                    throw new EOFException("EOF encountered in middle of BIT STRING");
                }
            }
            return new DERBitString(byArray, n3);
        }
        throw new IllegalArgumentException("truncated BIT STRING detected");
    }

    @Override
    public String getString() {
        byte[] byArray;
        StringBuffer stringBuffer;
        ASN1BitString aSN1BitString = stringBuffer2;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer("#");
        try {
            byArray = aSN1BitString.getEncoded();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException(b.a(iOException, b.b.a("Internal error encoding BitString: ")), iOException);
        }
        for (int i3 = 0; i3 != byArray.length; ++i3) {
            char[] cArray = table;
            stringBuffer2.append(cArray[byArray[i3] >>> 4 & 0xF]);
            stringBuffer2.append(table[byArray[i3] & 0xF]);
        }
        return stringBuffer2.toString();
    }

    public int intValue() {
        int n3 = 0;
        int n4 = Math.min(4, this.data.length - 1);
        for (int i3 = 0; i3 < n4; ++i3) {
            n3 |= (this.data[i3] & 0xFF) << i3 * 8;
        }
        if (n4 >= 0 && n4 < 4) {
            n3 |= ((byte)(this.data[n4] & 255 << this.padBits) & 0xFF) << n4 * 8;
        }
        return n3;
    }

    public byte[] getOctets() {
        if (this.padBits == 0) {
            return Arrays.clone(this.data);
        }
        throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
    }

    public byte[] getBytes() {
        byte[] byArray = this.data;
        if (this.data.length == 0) {
            return byArray;
        }
        byte[] byArray2 = Arrays.clone(byArray);
        int n3 = this.data.length - 1;
        byArray2[n3] = (byte)(byArray2[n3] & 255 << this.padBits);
        return byArray2;
    }

    public int getPadBits() {
        return this.padBits;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        byte[] byArray = this.data;
        int n3 = this.data.length + -1;
        if (n3 < 0) {
            return 1;
        }
        byte by = (byte)(byArray[n3] & 255 << this.padBits);
        return Arrays.hashCode(byArray, 0, n3) * 257 ^ by ^ this.padBits;
    }

    @Override
    public boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1BitString)) {
            return false;
        }
        object = (ASN1BitString)object;
        if (this.padBits != ((ASN1BitString)object).padBits) {
            return false;
        }
        byte[] byArray = this.data;
        int n3 = this.data.length;
        object = ((ASN1BitString)object).data;
        if (n3 != ((Object)object).length) {
            return false;
        }
        if ((n3 += -1) < 0) {
            return true;
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            if (byArray[i3] == object[i3]) continue;
            return false;
        }
        int n4 = this.padBits;
        return (byte)(byArray[n3] & 255 << n4) == (byte)(object[n3] & 255 << n4);
    }

    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    public ASN1Primitive toDERObject() {
        ASN1BitString aSN1BitString = object;
        Object object = aSN1BitString.data;
        return new DERBitString((byte[])object, aSN1BitString.padBits);
    }

    @Override
    public ASN1Primitive toDLObject() {
        ASN1BitString aSN1BitString = object;
        Object object = aSN1BitString.data;
        return new DLBitString((byte[])object, aSN1BitString.padBits);
    }

    @Override
    public abstract void encode(ASN1OutputStream var1, boolean var2);
}

