/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;

public class ASN1EncodableVector {
    public static final ASN1Encodable[] EMPTY_ELEMENTS = new ASN1Encodable[0];
    private static final int DEFAULT_CAPACITY = 10;
    private ASN1Encodable[] elements;
    private int elementCount;
    private boolean copyOnWrite;

    public ASN1EncodableVector() {
        this(10);
    }

    public ASN1EncodableVector(int n3) {
        if (n3 >= 0) {
            ASN1Encodable[] aSN1EncodableArray = n3 == 0 ? EMPTY_ELEMENTS : new ASN1Encodable[n3];
            ASN1EncodableVector aSN1EncodableVector = this;
            aSN1EncodableVector.elements = aSN1EncodableArray;
            aSN1EncodableVector.elementCount = 0;
            aSN1EncodableVector.copyOnWrite = false;
            return;
        }
        throw new IllegalArgumentException("'initialCapacity' must not be negative");
    }

    private void reallocate(int n3) {
        int n4 = n3;
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[Math.max(this.elements.length, n4 + (n4 >> 1))];
        int n5 = this.elementCount;
        System.arraycopy(this.elements, 0, aSN1EncodableArray, 0, n5);
        this.elements = aSN1EncodableArray;
        this.copyOnWrite = false;
    }

    public static ASN1Encodable[] cloneElements(ASN1Encodable[] aSN1EncodableArray) {
        return aSN1EncodableArray.length < 1 ? EMPTY_ELEMENTS : (ASN1Encodable[])aSN1EncodableArray.clone();
    }

    public void add(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            ASN1EncodableVector aSN1EncodableVector = this;
            int n3 = aSN1EncodableVector.elementCount + 1;
            int n4 = aSN1EncodableVector.elements.length;
            if (n3 > n4 | this.copyOnWrite) {
                this.reallocate(n3);
            }
            this.elements[this.elementCount] = aSN1Encodable;
            this.elementCount = n3;
            return;
        }
        throw new NullPointerException("'element' cannot be null");
    }

    public void addAll(ASN1EncodableVector aSN1EncodableVector) {
        if (aSN1EncodableVector != null) {
            ASN1Encodable aSN1Encodable;
            int n3 = aSN1EncodableVector.size();
            if (n3 < 1) {
                return;
            }
            ASN1EncodableVector aSN1EncodableVector2 = this;
            int n4 = aSN1EncodableVector2.elementCount + n3;
            int n5 = aSN1EncodableVector2.elements.length;
            if (n4 > n5 | this.copyOnWrite) {
                this.reallocate(n4);
            }
            n5 = 0;
            while ((aSN1Encodable = aSN1EncodableVector.get(n5)) != null) {
                this.elements[this.elementCount + n5] = aSN1Encodable;
                if (++n5 < n3) continue;
                this.elementCount = n4;
                return;
            }
            throw new NullPointerException("'other' elements cannot be null");
        }
        throw new NullPointerException("'other' cannot be null");
    }

    public ASN1Encodable get(int n3) {
        if (n3 < this.elementCount) {
            return this.elements[n3];
        }
        throw new ArrayIndexOutOfBoundsException(n3 + " >= " + this.elementCount);
    }

    public int size() {
        return this.elementCount;
    }

    public ASN1Encodable[] copyElements() {
        int n3 = this.elementCount;
        if (n3 == 0) {
            return EMPTY_ELEMENTS;
        }
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[n3];
        System.arraycopy(this.elements, 0, aSN1EncodableArray, 0, n3);
        return aSN1EncodableArray;
    }

    public ASN1Encodable[] takeElements() {
        int n3 = aSN1EncodableArray2.elementCount;
        if (n3 == 0) {
            return EMPTY_ELEMENTS;
        }
        ASN1Encodable[] aSN1EncodableArray = aSN1EncodableArray2.elements;
        if (aSN1EncodableArray2.elements.length == n3) {
            aSN1EncodableArray2.copyOnWrite = true;
            return aSN1EncodableArray;
        }
        ASN1Encodable[] aSN1EncodableArray2 = new ASN1Encodable[n3];
        System.arraycopy(aSN1EncodableArray, 0, aSN1EncodableArray2, 0, n3);
        return aSN1EncodableArray2;
    }
}

