/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERExternal;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLExternal;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;

public abstract class ASN1External
extends ASN1Primitive {
    public ASN1ObjectIdentifier directReference;
    public ASN1Integer indirectReference;
    public ASN1Primitive dataValueDescriptor;
    public int encoding;
    public ASN1Primitive externalContent;

    public ASN1External(ASN1EncodableVector aSN1EncodableVector) {
        int n3 = 0;
        ASN1Primitive aSN1Primitive = ((ASN1External)aSN1Primitive2).getObjFromVector(aSN1EncodableVector, 0);
        if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
            ((ASN1External)aSN1Primitive2).directReference = (ASN1ObjectIdentifier)aSN1Primitive;
            n3 = 1;
            aSN1Primitive = ((ASN1External)aSN1Primitive2).getObjFromVector(aSN1EncodableVector, 1);
        }
        if (aSN1Primitive instanceof ASN1Integer) {
            ((ASN1External)aSN1Primitive2).indirectReference = (ASN1Integer)aSN1Primitive;
            aSN1Primitive = ((ASN1External)aSN1Primitive2).getObjFromVector(aSN1EncodableVector, ++n3);
        }
        if (!(aSN1Primitive instanceof ASN1TaggedObject)) {
            ((ASN1External)aSN1Primitive2).dataValueDescriptor = aSN1Primitive;
            aSN1Primitive = ((ASN1External)aSN1Primitive2).getObjFromVector(aSN1EncodableVector, ++n3);
        }
        if (aSN1EncodableVector.size() == n3 + 1) {
            if (aSN1Primitive instanceof ASN1TaggedObject) {
                ASN1External aSN1External = aSN1Primitive2;
                ASN1Primitive aSN1Primitive2 = (ASN1TaggedObject)aSN1Primitive;
                aSN1External.setEncoding(((ASN1TaggedObject)aSN1Primitive2).getTagNo());
                aSN1External.externalContent = ((ASN1TaggedObject)aSN1Primitive2).getObject();
                return;
            }
            throw new IllegalArgumentException("No tagged object found in vector. Structure doesn't seem to be of type External");
        }
        throw new IllegalArgumentException("input vector too large");
    }

    private ASN1Primitive getObjFromVector(ASN1EncodableVector aSN1EncodableVector, int n3) {
        if (aSN1EncodableVector.size() > n3) {
            return aSN1EncodableVector.get(n3).toASN1Primitive();
        }
        throw new IllegalArgumentException("too few objects in input vector");
    }

    public ASN1External(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Integer aSN1Integer, ASN1Primitive aSN1Primitive, DERTaggedObject aSN1Primitive2) {
        DERTaggedObject dERTaggedObject = aSN1Primitive2;
        int n3 = dERTaggedObject.getTagNo();
        aSN1Primitive2 = dERTaggedObject.toASN1Primitive();
        this(aSN1ObjectIdentifier, aSN1Integer, aSN1Primitive, n3, aSN1Primitive2);
    }

    public ASN1External(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Integer aSN1Integer, ASN1Primitive aSN1Primitive, int n3, ASN1Primitive aSN1Primitive2) {
        this.setDirectReference(aSN1ObjectIdentifier);
        this.setIndirectReference(aSN1Integer);
        this.setDataValueDescriptor(aSN1Primitive);
        this.setEncoding(n3);
        this.setExternalContent(aSN1Primitive2.toASN1Primitive());
    }

    private void setDataValueDescriptor(ASN1Primitive aSN1Primitive) {
        this.dataValueDescriptor = aSN1Primitive;
    }

    private void setDirectReference(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.directReference = aSN1ObjectIdentifier;
    }

    private void setEncoding(int n3) {
        if (n3 >= 0 && n3 <= 2) {
            this.encoding = n3;
            return;
        }
        throw new IllegalArgumentException(a.a("invalid encoding value: ", n3));
    }

    private void setExternalContent(ASN1Primitive aSN1Primitive) {
        this.externalContent = aSN1Primitive;
    }

    private void setIndirectReference(ASN1Integer aSN1Integer) {
        this.indirectReference = aSN1Integer;
    }

    @Override
    public ASN1Primitive toDERObject() {
        ASN1External aSN1External = aSN1Primitive;
        ASN1Primitive aSN1Primitive = aSN1External.directReference;
        ASN1Integer aSN1Integer = aSN1External.indirectReference;
        ASN1Primitive aSN1Primitive2 = aSN1External.dataValueDescriptor;
        int n3 = aSN1External.encoding;
        ASN1Primitive aSN1Primitive3 = aSN1External.externalContent;
        return new DERExternal((ASN1ObjectIdentifier)aSN1Primitive, aSN1Integer, aSN1Primitive2, n3, aSN1Primitive3);
    }

    @Override
    public ASN1Primitive toDLObject() {
        ASN1External aSN1External = aSN1Primitive;
        ASN1Primitive aSN1Primitive = aSN1External.directReference;
        ASN1Integer aSN1Integer = aSN1External.indirectReference;
        ASN1Primitive aSN1Primitive2 = aSN1External.dataValueDescriptor;
        int n3 = aSN1External.encoding;
        ASN1Primitive aSN1Primitive3 = aSN1External.externalContent;
        return new DLExternal((ASN1ObjectIdentifier)aSN1Primitive, aSN1Integer, aSN1Primitive2, n3, aSN1Primitive3);
    }

    @Override
    public int hashCode() {
        int n3 = 0;
        ASN1Primitive aSN1Primitive = this.directReference;
        if (aSN1Primitive != null) {
            n3 = ((ASN1ObjectIdentifier)aSN1Primitive).hashCode();
        }
        if ((aSN1Primitive = this.indirectReference) != null) {
            n3 ^= ((ASN1Integer)aSN1Primitive).hashCode();
        }
        if ((aSN1Primitive = this.dataValueDescriptor) != null) {
            n3 ^= aSN1Primitive.hashCode();
        }
        return n3 ^ this.externalContent.hashCode();
    }

    @Override
    public boolean isConstructed() {
        return true;
    }

    @Override
    public int encodedLength() {
        return this.getEncoded().length;
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        ASN1Primitive aSN1Primitive2;
        if (!(aSN1Primitive instanceof ASN1External)) {
            return false;
        }
        if (this == aSN1Primitive) {
            return true;
        }
        aSN1Primitive = (ASN1External)aSN1Primitive;
        ASN1Primitive aSN1Primitive3 = this.directReference;
        if (!(aSN1Primitive3 == null || (aSN1Primitive2 = ((ASN1External)aSN1Primitive).directReference) != null && aSN1Primitive2.equals(aSN1Primitive3))) {
            return false;
        }
        aSN1Primitive3 = this.indirectReference;
        if (!(aSN1Primitive3 == null || (aSN1Primitive2 = ((ASN1External)aSN1Primitive).indirectReference) != null && aSN1Primitive2.equals(aSN1Primitive3))) {
            return false;
        }
        aSN1Primitive3 = this.dataValueDescriptor;
        if (!(aSN1Primitive3 == null || (aSN1Primitive2 = ((ASN1External)aSN1Primitive).dataValueDescriptor) != null && aSN1Primitive2.equals(aSN1Primitive3))) {
            return false;
        }
        return this.externalContent.equals(((ASN1External)aSN1Primitive).externalContent);
    }

    public ASN1Primitive getDataValueDescriptor() {
        return this.dataValueDescriptor;
    }

    public ASN1ObjectIdentifier getDirectReference() {
        return this.directReference;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public ASN1Primitive getExternalContent() {
        return this.externalContent;
    }

    public ASN1Integer getIndirectReference() {
        return this.indirectReference;
    }
}

