/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERGeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DateUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class ASN1GeneralizedTime
extends ASN1Primitive {
    public byte[] time;

    public static ASN1GeneralizedTime getInstance(Object object) {
        if (object != null && !(object instanceof ASN1GeneralizedTime)) {
            if (object instanceof byte[]) {
                try {
                    return (ASN1GeneralizedTime)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(d.a(exception, b.a("encoding error in getInstance: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, b.a("illegal object in getInstance: ")));
        }
        return (ASN1GeneralizedTime)object;
    }

    public static ASN1GeneralizedTime getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof ASN1GeneralizedTime)) {
            return new ASN1GeneralizedTime(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return ASN1GeneralizedTime.getInstance(aSN1Primitive);
    }

    public ASN1GeneralizedTime(String string2) {
        this.time = Strings.toByteArray(string2);
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(b.a("invalid date string: ").append(parseException.getMessage()).toString());
        }
    }

    public ASN1GeneralizedTime(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'", DateUtil.EN_Locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(simpleDateFormat.format(date));
    }

    public ASN1GeneralizedTime(Date date, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'", locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = Strings.toByteArray(simpleDateFormat.format(date));
    }

    public ASN1GeneralizedTime(byte[] byArray) {
        if (byArray.length >= 4) {
            this.time = byArray;
            if (this.isDigit(0) && this.isDigit(1) && this.isDigit(2) && this.isDigit(3)) {
                return;
            }
            throw new IllegalArgumentException("illegal characters in GeneralizedTime string");
        }
        throw new IllegalArgumentException("GeneralizedTime string too short");
    }

    private String calculateGMTOffset(String string2) {
        int n3;
        int n4;
        String string3;
        block8: {
            TimeZone timeZone;
            block9: {
                string3 = "+";
                timeZone = TimeZone.getDefault();
                n4 = timeZone.getRawOffset();
                if (n4 < 0) {
                    string3 = "-";
                    n4 = -n4;
                }
                int n5 = n4;
                n4 = n5 / 3600000;
                n3 = (n5 - n4 * 60 * 60 * 1000) / 60000;
                try {
                    if (!timeZone.useDaylightTime()) break block8;
                }
                catch (ParseException parseException) {}
                if (!this.hasFractionalSeconds()) break block9;
                string2 = this.pruneFractionalSeconds(string2);
            }
            TimeZone timeZone2 = timeZone;
            SimpleDateFormat simpleDateFormat = this.calculateGMTDateFormat();
            if (!timeZone2.inDaylightTime(simpleDateFormat.parse(string2 + "GMT" + string3 + this.convert(n4) + ":" + this.convert(n3)))) break block8;
            int n6 = string3.equals("+") ? 1 : -1;
            n4 += n6;
        }
        return e.a("GMT", string3).append(this.convert(n4)).append(":").append(this.convert(n3)).toString();
    }

    private SimpleDateFormat calculateGMTDateFormat() {
        SimpleTimeZone simpleTimeZone;
        Object object;
        if (((ASN1GeneralizedTime)object).hasFractionalSeconds()) {
            SimpleDateFormat simpleDateFormat;
            object = simpleDateFormat;
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSSz");
        } else if (((ASN1GeneralizedTime)object).hasSeconds()) {
            SimpleDateFormat simpleDateFormat;
            object = simpleDateFormat;
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
        } else if (((ASN1GeneralizedTime)object).hasMinutes()) {
            SimpleDateFormat simpleDateFormat;
            object = simpleDateFormat;
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmz");
        } else {
            SimpleDateFormat simpleDateFormat;
            object = simpleDateFormat;
            simpleDateFormat = new SimpleDateFormat("yyyyMMddHHz");
        }
        Object object2 = object;
        object = simpleTimeZone;
        simpleTimeZone = new SimpleTimeZone(0, "Z");
        ((DateFormat)object2).setTimeZone((TimeZone)object);
        return object2;
    }

    private String pruneFractionalSeconds(String string2) {
        int n3;
        int n4;
        String string3 = string2.substring(14);
        for (n4 = 1; n4 < string3.length() && 48 <= (n3 = string3.charAt(n4)) && n3 <= 57; ++n4) {
        }
        n3 = n4 - 1;
        if (n3 > 3) {
            string2 = string2.substring(0, 14) + (string3.substring(0, 4) + string3.substring(n4));
        } else if (n3 == 1) {
            string2 = string2.substring(0, 14) + (string3.substring(0, n4) + "00" + string3.substring(n4));
        } else if (n3 == 2) {
            string2 = string2.substring(0, 14) + (string3.substring(0, n4) + "0" + string3.substring(n4));
        }
        return string2;
    }

    private String convert(int n3) {
        if (n3 < 10) {
            return a.a("0", n3);
        }
        return Integer.toString(n3);
    }

    private boolean isDigit(int n3) {
        Object object;
        Object object2 = ((ASN1GeneralizedTime)object2).time;
        return ((ASN1GeneralizedTime)object2).time.length > n3 && (object = object2[n3]) >= 48 && object <= 57;
    }

    public String getTimeString() {
        return Strings.fromByteArray(this.time);
    }

    public String getTime() {
        String string2 = Strings.fromByteArray(((ASN1GeneralizedTime)((Object)stringBuilder2)).time);
        if (string2.charAt(string2.length() - 1) == 'Z') {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            String string3 = string2;
            stringBuilder2();
            return stringBuilder.append(string3.substring(0, string3.length() - 1)).append("GMT+00:00").toString();
        }
        String string4 = string2;
        int n3 = string4.length() - 6;
        char c3 = string4.charAt(n3);
        if ((c3 == '-' || c3 == '+') && string2.indexOf("GMT") == n3 - 3) {
            return string2;
        }
        String string5 = string2;
        n3 = string5.length() - 5;
        c3 = string5.charAt(n3);
        if (c3 != '-' && c3 != '+') {
            String string6 = string2;
            n3 = string6.length() - 3;
            c3 = string6.charAt(n3);
            if (c3 != '-' && c3 != '+') {
                return b.a(string2).append(super.calculateGMTOffset(string2)).toString();
            }
            return string2.substring(0, n3) + "GMT" + string2.substring(n3) + ":00";
        }
        int n4 = n3;
        int n5 = n4 + 3;
        return string2.substring(0, n3) + "GMT" + string2.substring(n4, n5) + ":" + string2.substring(n5);
    }

    public Date getDate() {
        SimpleDateFormat simpleDateFormat;
        String string2 = Strings.fromByteArray(this.time);
        if (string2.endsWith("Z")) {
            SimpleTimeZone simpleTimeZone;
            if (this.hasFractionalSeconds()) {
                SimpleDateFormat simpleDateFormat2;
                simpleDateFormat = simpleDateFormat2;
                simpleDateFormat2 = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
            } else if (this.hasSeconds()) {
                SimpleDateFormat simpleDateFormat3;
                simpleDateFormat = simpleDateFormat3;
                simpleDateFormat3 = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
            } else if (this.hasMinutes()) {
                SimpleDateFormat simpleDateFormat4;
                simpleDateFormat = simpleDateFormat4;
                simpleDateFormat4 = new SimpleDateFormat("yyyyMMddHHmm'Z'");
            } else {
                SimpleDateFormat simpleDateFormat5;
                simpleDateFormat = simpleDateFormat5;
                simpleDateFormat5 = new SimpleDateFormat("yyyyMMddHH'Z'");
            }
            SimpleTimeZone simpleTimeZone2 = simpleTimeZone;
            simpleTimeZone = new SimpleTimeZone(0, "Z");
            simpleDateFormat.setTimeZone(simpleTimeZone2);
        } else if (string2.indexOf(45) <= 0 && string2.indexOf(43) <= 0) {
            if (this.hasFractionalSeconds()) {
                SimpleDateFormat simpleDateFormat6;
                simpleDateFormat = simpleDateFormat6;
                simpleDateFormat6 = new SimpleDateFormat("yyyyMMddHHmmss.SSS");
            } else if (this.hasSeconds()) {
                SimpleDateFormat simpleDateFormat7;
                simpleDateFormat = simpleDateFormat7;
                simpleDateFormat7 = new SimpleDateFormat("yyyyMMddHHmmss");
            } else if (this.hasMinutes()) {
                SimpleDateFormat simpleDateFormat8;
                simpleDateFormat = simpleDateFormat8;
                simpleDateFormat8 = new SimpleDateFormat("yyyyMMddHHmm");
            } else {
                SimpleDateFormat simpleDateFormat9;
                simpleDateFormat = simpleDateFormat9;
                simpleDateFormat9 = new SimpleDateFormat("yyyyMMddHH");
            }
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        } else {
            ASN1GeneralizedTime aSN1GeneralizedTime = this;
            string2 = aSN1GeneralizedTime.getTime();
            simpleDateFormat = aSN1GeneralizedTime.calculateGMTDateFormat();
        }
        if (this.hasFractionalSeconds()) {
            string2 = this.pruneFractionalSeconds(string2);
        }
        return DateUtil.epochAdjust(simpleDateFormat.parse(string2));
    }

    public boolean hasFractionalSeconds() {
        int n3 = 0;
        while (true) {
            byte[] byArray = this.time;
            if (n3 == this.time.length) break;
            if (byArray[n3] == 46 && n3 == 14) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean hasSeconds() {
        return this.isDigit(12) && this.isDigit(13);
    }

    public boolean hasMinutes() {
        return this.isDigit(10) && this.isDigit(11);
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        int n3 = this.time.length;
        return StreamUtil.calculateBodyLength(n3) + 1 + n3;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        Object object = ((ASN1GeneralizedTime)object).time;
        aSN1OutputStream.writeEncoded(bl, 24, (byte[])object);
    }

    @Override
    public ASN1Primitive toDERObject() {
        return new DERGeneralizedTime(this.time);
    }

    @Override
    public ASN1Primitive toDLObject() {
        return new DERGeneralizedTime(this.time);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1GeneralizedTime)) {
            return false;
        }
        return Arrays.areEqual(this.time, ((ASN1GeneralizedTime)aSN1Primitive).time);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.time);
    }
}

