/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.OIDTokenizer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ASN1ObjectIdentifier
extends ASN1Primitive {
    private static final long LONG_LIMIT = 0xFFFFFFFFFFFF80L;
    private static final ConcurrentMap<OidHandle, ASN1ObjectIdentifier> pool = new ConcurrentHashMap<OidHandle, ASN1ObjectIdentifier>();
    private final String identifier;
    private byte[] body;

    public static ASN1ObjectIdentifier getInstance(Object object) {
        if (object != null && !(object instanceof ASN1ObjectIdentifier)) {
            ASN1Primitive aSN1Primitive;
            if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1ObjectIdentifier) {
                return (ASN1ObjectIdentifier)aSN1Primitive;
            }
            if (object instanceof byte[]) {
                try {
                    return (ASN1ObjectIdentifier)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, b.b.a("failed to construct object identifier from byte[]: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, b.b.a("illegal object in getInstance: ")));
        }
        return (ASN1ObjectIdentifier)object;
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof ASN1ObjectIdentifier)) {
            return ASN1ObjectIdentifier.fromOctetString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return ASN1ObjectIdentifier.getInstance(aSN1Primitive);
    }

    public ASN1ObjectIdentifier(byte[] byArray) {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer();
        long l3 = 0L;
        BigInteger bigInteger = null;
        boolean bl = true;
        for (int i3 = 0; i3 != byArray.length; ++i3) {
            int n3 = byArray[i3] & 0xFF;
            if (l3 <= 0xFFFFFFFFFFFF80L) {
                l3 += (long)(n3 & 0x7F);
                if ((n3 & 0x80) == 0) {
                    if (bl) {
                        if (l3 < 40L) {
                            stringBuffer2.append('0');
                        } else if (l3 < 80L) {
                            stringBuffer2.append('1');
                            l3 -= 40L;
                        } else {
                            stringBuffer2.append('2');
                            l3 -= 80L;
                        }
                        bl = false;
                    }
                    StringBuffer stringBuffer3 = stringBuffer2;
                    stringBuffer3.append('.');
                    stringBuffer3.append(l3);
                    l3 = 0L;
                    continue;
                }
                l3 <<= 7;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l3);
            }
            bigInteger = bigInteger.or(BigInteger.valueOf(n3 & 0x7F));
            if ((n3 & 0x80) == 0) {
                if (bl) {
                    stringBuffer2.append('2');
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(80L));
                    bl = false;
                }
                StringBuffer stringBuffer4 = stringBuffer2;
                stringBuffer4.append('.');
                stringBuffer4.append(bigInteger);
                Object var3_4 = null;
                long l4 = 0L;
                bigInteger = var3_4;
                l3 = l4;
                continue;
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
        this.identifier = stringBuffer2.toString();
        this.body = Arrays.clone(byArray);
    }

    public ASN1ObjectIdentifier(String string2) {
        if (string2 != null) {
            if (ASN1ObjectIdentifier.isValidIdentifier(string2)) {
                this.identifier = string2;
                return;
            }
            throw new IllegalArgumentException(g.a("string ", string2, " not an OID"));
        }
        throw new NullPointerException("'identifier' cannot be null");
    }

    public ASN1ObjectIdentifier(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string2) {
        if (ASN1ObjectIdentifier.isValidBranchID(string2, 0)) {
            this.identifier = aSN1ObjectIdentifier.getId() + "." + string2;
            return;
        }
        throw new IllegalArgumentException(g.a("string ", string2, " not a valid OID branch"));
    }

    private void writeField(ByteArrayOutputStream byteArrayOutputStream, long l3) {
        byte[] byArray = new byte[9];
        Object object = byArray;
        int n3 = 8;
        byArray[8] = (byte)((int)l3 & 0x7F);
        while (l3 >= 128L) {
            object[n3 += -1] = (byte)((int)(l3 >>= 7) & 0x7F | 0x80);
        }
        int n4 = 9 - n3;
        byteArrayOutputStream.write((byte[])object, n3, n4);
    }

    private void writeField(ByteArrayOutputStream byteArrayOutputStream, BigInteger bigInteger) {
        int n3 = (bigInteger.bitLength() + 6) / 7;
        if (n3 == 0) {
            byteArrayOutputStream.write(0);
        } else {
            int n4;
            byte[] byArray = new byte[n3];
            for (int i3 = n4 = (v485661) - 1; i3 >= 0; --i3) {
                byArray[i3] = (byte)(bigInteger.intValue() & 0x7F | 0x80);
                bigInteger = bigInteger.shiftRight(7);
            }
            byArray[n4] = (byte)(byArray[n4] & 0x7F);
            byteArrayOutputStream.write(byArray, 0, n3);
        }
    }

    private void doOutput(ByteArrayOutputStream byteArrayOutputStream) {
        OIDTokenizer oIDTokenizer;
        OIDTokenizer oIDTokenizer2 = oIDTokenizer;
        int n3 = Integer.parseInt(new OIDTokenizer(this.identifier).nextToken()) * 40;
        Object object = oIDTokenizer2.nextToken();
        if (((String)object).length() <= 18) {
            long l3 = n3;
            this.writeField(byteArrayOutputStream, Long.parseLong((String)object) + l3);
        } else {
            this.writeField(byteArrayOutputStream, new BigInteger((String)object).add(BigInteger.valueOf(n3)));
        }
        while (oIDTokenizer2.hasMoreTokens()) {
            BigInteger bigInteger;
            String string2 = oIDTokenizer2.nextToken();
            if (string2.length() <= 18) {
                long l4 = Long.parseLong(string2);
                this.writeField(byteArrayOutputStream, l4);
                continue;
            }
            object = bigInteger;
            bigInteger = new BigInteger(string2);
            this.writeField(byteArrayOutputStream, (BigInteger)object);
        }
    }

    private synchronized byte[] getBody() {
        if (this.body == null) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            this.doOutput(new ByteArrayOutputStream());
            this.body = byteArrayOutputStream2.toByteArray();
        }
        return this.body;
    }

    private static boolean isValidBranchID(String string2, int n3) {
        int n4 = 0;
        int n5 = string2.length();
        while ((n5 += -1) >= n3) {
            char c3 = string2.charAt(n5);
            if (c3 == '.') {
                if (n4 != 0 && (n4 <= 1 || string2.charAt(n5 + 1) != '0')) {
                    n4 = 0;
                    continue;
                }
                return false;
            }
            if ('0' <= c3 && c3 <= '9') {
                ++n4;
                continue;
            }
            return false;
        }
        return n4 != 0 && (n4 <= 1 || string2.charAt(n5 + 1) != '0');
        {
        }
    }

    private static boolean isValidIdentifier(String string2) {
        if (string2.length() >= 3 && string2.charAt(1) == '.') {
            char c3 = string2.charAt(0);
            if (c3 >= '0' && c3 <= '2') {
                return ASN1ObjectIdentifier.isValidBranchID(string2, 2);
            }
            return false;
        }
        return false;
    }

    public static ASN1ObjectIdentifier fromOctetString(byte[] byArray) {
        OidHandle oidHandle;
        Object object = oidHandle;
        oidHandle = new OidHandle(byArray);
        if ((object = (ASN1ObjectIdentifier)pool.get(object)) == null) {
            return new ASN1ObjectIdentifier(byArray);
        }
        return object;
    }

    public String getId() {
        return this.identifier;
    }

    public ASN1ObjectIdentifier branch(String string2) {
        return new ASN1ObjectIdentifier(this, string2);
    }

    public boolean on(ASN1ObjectIdentifier object) {
        String string2 = ((ASN1ObjectIdentifier)((Object)string2)).getId();
        object = ((ASN1ObjectIdentifier)object).getId();
        return string2.length() > ((String)object).length() && string2.charAt(((String)object).length()) == '.' && string2.startsWith((String)object);
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        int n3 = this.getBody().length;
        return StreamUtil.calculateBodyLength(n3) + 1 + n3;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        Object object = ((ASN1ObjectIdentifier)object).getBody();
        aSN1OutputStream.writeEncoded(bl, 6, (byte[])object);
    }

    @Override
    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive == this) {
            return true;
        }
        if (!(aSN1Primitive instanceof ASN1ObjectIdentifier)) {
            return false;
        }
        return this.identifier.equals(((ASN1ObjectIdentifier)aSN1Primitive).identifier);
    }

    public String toString() {
        return this.getId();
    }

    public ASN1ObjectIdentifier intern() {
        Object object;
        OidHandle oidHandle;
        Object object2 = oidHandle;
        oidHandle = new OidHandle(((ASN1ObjectIdentifier)object).getBody());
        ConcurrentMap<OidHandle, ASN1ObjectIdentifier> concurrentMap = pool;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)concurrentMap.get(object2);
        if (aSN1ObjectIdentifier == null) {
            if ((object2 = concurrentMap.putIfAbsent((OidHandle)object2, (ASN1ObjectIdentifier)object)) != null) {
                object = object2;
            }
        } else {
            object = aSN1ObjectIdentifier;
        }
        return object;
    }

    public static class OidHandle {
        private final int key;
        private final byte[] enc;

        public OidHandle(byte[] byArray) {
            this.key = Arrays.hashCode(byArray);
            this.enc = byArray;
        }

        public int hashCode() {
            return this.key;
        }

        public boolean equals(Object object) {
            if (object instanceof OidHandle) {
                return Arrays.areEqual(this.enc, ((OidHandle)object).enc);
            }
            return false;
        }
    }
}

