/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class ASN1OutputStream {
    private OutputStream os;

    public static ASN1OutputStream create(OutputStream outputStream) {
        return new ASN1OutputStream(outputStream);
    }

    public static ASN1OutputStream create(OutputStream outputStream, String string2) {
        if (string2.equals("DER")) {
            return new DEROutputStream(outputStream);
        }
        if (string2.equals("DL")) {
            return new DLOutputStream(outputStream);
        }
        return new ASN1OutputStream(outputStream);
    }

    public ASN1OutputStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    public final void writeLength(int n3) {
        if (n3 > 127) {
            int n4 = 1;
            int n5 = n3;
            while ((n5 >>>= 8) != 0) {
                ++n4;
            }
            this.write((byte)(n4 | 0x80));
            for (n4 = (n4 - 1) * 8; n4 >= 0; n4 -= 8) {
                this.write((byte)(n3 >> n4));
            }
        } else {
            this.write((byte)n3);
        }
    }

    public final void write(int n3) {
        this.os.write(n3);
    }

    public final void write(byte[] byArray, int n3, int n4) {
        this.os.write(byArray, n3, n4);
    }

    public final void writeElements(ASN1Encodable[] aSN1EncodableArray) {
        int n3 = aSN1EncodableArray.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            this.writePrimitive(aSN1EncodableArray[i3].toASN1Primitive(), true);
        }
    }

    public final void writeElements(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.writePrimitive(((ASN1Encodable)enumeration.nextElement()).toASN1Primitive(), true);
        }
    }

    public final void writeEncoded(boolean bl, int n3, byte by) {
        if (bl) {
            this.write(n3);
        }
        ASN1OutputStream aSN1OutputStream = this;
        aSN1OutputStream.writeLength(1);
        aSN1OutputStream.write(by);
    }

    public final void writeEncoded(boolean bl, int n3, byte[] byArray) {
        if (bl) {
            this.write(n3);
        }
        this.writeLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public final void writeEncoded(boolean bl, int n3, byte[] byArray, int n4, int n5) {
        if (bl) {
            this.write(n3);
        }
        ASN1OutputStream aSN1OutputStream = this;
        aSN1OutputStream.writeLength(n5);
        aSN1OutputStream.write(byArray, n4, n5);
    }

    public final void writeEncoded(boolean bl, int n3, byte by, byte[] byArray) {
        if (bl) {
            this.write(n3);
        }
        this.writeLength(byArray.length + 1);
        this.write(by);
        this.write(byArray, 0, byArray.length);
    }

    public final void writeEncoded(boolean bl, int n3, byte by, byte[] byArray, int n4, int n5, byte by2) {
        if (bl) {
            this.write(n3);
        }
        this.writeLength(n5 + 2);
        this.write(by);
        this.write(byArray, n4, n5);
        this.write(by2);
    }

    public final void writeEncoded(boolean bl, int n3, int n4, byte[] byArray) {
        this.writeTag(bl, n3, n4);
        this.writeLength(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public final void writeEncodedIndef(boolean bl, int n3, int n4, byte[] byArray) {
        ASN1OutputStream aSN1OutputStream = this;
        ASN1OutputStream aSN1OutputStream2 = this;
        aSN1OutputStream2.writeTag(bl, n3, n4);
        aSN1OutputStream2.write(128);
        int n5 = byArray.length;
        aSN1OutputStream.write(byArray, 0, n5);
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }

    public final void writeEncodedIndef(boolean bl, int n3, ASN1Encodable[] aSN1EncodableArray) {
        if (bl) {
            this.write(n3);
        }
        ASN1OutputStream aSN1OutputStream = this;
        aSN1OutputStream.write(128);
        aSN1OutputStream.writeElements(aSN1EncodableArray);
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }

    public final void writeEncodedIndef(boolean bl, int n3, Enumeration enumeration) {
        if (bl) {
            this.write(n3);
        }
        ASN1OutputStream aSN1OutputStream = this;
        aSN1OutputStream.write(128);
        aSN1OutputStream.writeElements(enumeration);
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTag(boolean bl, int n3, int n4) {
        void byArray2;
        void var3_6;
        if (!bl) {
            return;
        }
        if (var3_6 < 31) {
            this.write(byArray2 | var3_6);
        } else {
            this.write((int)(byArray2 | 0x1F));
            if (var3_6 < 128) {
                this.write((int)var3_6);
            } else {
                int n5 = 5;
                byte[] byArray = new byte[5];
                byte[] byArray3 = byArray;
                int n6 = 4;
                byArray[n6] = (byte)(var3_6 & 0x7F);
                do {
                    byArray3[--n6] = (byte)((var3_6 >>= 7) & 0x7F | 0x80);
                } while (var3_6 > 127);
                int n62 = n5 - n6;
                this.write(byArray3, n6, n62);
            }
        }
    }

    public void writeObject(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            ASN1OutputStream aSN1OutputStream = this;
            aSN1OutputStream.writePrimitive(aSN1Encodable.toASN1Primitive(), true);
            aSN1OutputStream.flushInternal();
            return;
        }
        throw new IOException("null object detected");
    }

    public void writeObject(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive != null) {
            ASN1OutputStream aSN1OutputStream = this;
            aSN1OutputStream.writePrimitive(aSN1Primitive, true);
            aSN1OutputStream.flushInternal();
            return;
        }
        throw new IOException("null object detected");
    }

    public void writePrimitive(ASN1Primitive aSN1Primitive, boolean bl) {
        aSN1Primitive.encode(this, bl);
    }

    public void close() {
        this.os.close();
    }

    public void flush() {
        this.os.flush();
    }

    public void flushInternal() {
    }

    public DEROutputStream getDERSubStream() {
        return new DEROutputStream(this.os);
    }

    public ASN1OutputStream getDLSubStream() {
        return new DLOutputStream(this.os);
    }
}

