/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1SequenceParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Iterable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ASN1Sequence
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    public ASN1Encodable[] elements;

    public static ASN1Sequence getInstance(Object object) {
        if (object != null && !(object instanceof ASN1Sequence)) {
            ASN1Primitive aSN1Primitive;
            if (object instanceof ASN1SequenceParser) {
                return ASN1Sequence.getInstance(((ASN1SequenceParser)object).toASN1Primitive());
            }
            if (object instanceof byte[]) {
                try {
                    return ASN1Sequence.getInstance(ASN1Primitive.fromByteArray((byte[])object));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(b.a(iOException, b.b.a("failed to construct sequence from byte[]: ")));
                }
            }
            if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1Sequence) {
                return (ASN1Sequence)aSN1Primitive;
            }
            throw new IllegalArgumentException(c.a(object, b.b.a("unknown object in getInstance: ")));
        }
        return (ASN1Sequence)object;
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        if (bl) {
            if (((ASN1TaggedObject)aSN1Primitive).isExplicit()) {
                return ASN1Sequence.getInstance(((ASN1TaggedObject)aSN1Primitive).getObject());
            }
            throw new IllegalArgumentException("object implicit - explicit expected.");
        }
        ASN1TaggedObject aSN1TaggedObject = aSN1Primitive;
        ASN1Primitive aSN1Primitive2 = aSN1TaggedObject.getObject();
        if (aSN1TaggedObject.isExplicit()) {
            if (aSN1Primitive instanceof BERTaggedObject) {
                return new BERSequence(aSN1Primitive2);
            }
            return new DLSequence(aSN1Primitive2);
        }
        if (aSN1Primitive2 instanceof ASN1Sequence) {
            ASN1TaggedObject aSN1TaggedObject2 = aSN1Primitive;
            aSN1Primitive = (ASN1Sequence)aSN1Primitive2;
            if (aSN1TaggedObject2 instanceof BERTaggedObject) {
                return aSN1Primitive;
            }
            return (ASN1Sequence)((ASN1Sequence)aSN1Primitive).toDLObject();
        }
        throw new IllegalArgumentException(b.b.a("unknown object in getInstance: ").append(aSN1Primitive.getClass().getName()).toString());
    }

    public ASN1Sequence() {
        this.elements = ASN1EncodableVector.EMPTY_ELEMENTS;
    }

    public ASN1Sequence(ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            ASN1Encodable[] aSN1EncodableArray = aSN1EncodableArray3;
            ASN1Encodable[] aSN1EncodableArray2 = new ASN1Encodable[1];
            ASN1Encodable[] aSN1EncodableArray3 = aSN1EncodableArray2;
            aSN1EncodableArray2[0] = aSN1Encodable;
            aSN1EncodableArray.elements = aSN1EncodableArray3;
            return;
        }
        throw new NullPointerException("'element' cannot be null");
    }

    public ASN1Sequence(ASN1EncodableVector aSN1EncodableVector) {
        if (aSN1EncodableVector != null) {
            this.elements = aSN1EncodableVector.takeElements();
            return;
        }
        throw new NullPointerException("'elementVector' cannot be null");
    }

    public ASN1Sequence(ASN1Encodable[] aSN1EncodableArray) {
        if (!Arrays.isNullOrContainsNull(aSN1EncodableArray)) {
            this.elements = ASN1EncodableVector.cloneElements(aSN1EncodableArray);
            return;
        }
        throw new NullPointerException("'elements' cannot be null, or contain null");
    }

    public ASN1Sequence(ASN1Encodable[] aSN1EncodableArray, boolean bl) {
        if (bl) {
            aSN1EncodableArray = ASN1EncodableVector.cloneElements(aSN1EncodableArray);
        }
        this.elements = aSN1EncodableArray;
    }

    public ASN1Encodable[] toArray() {
        return ASN1EncodableVector.cloneElements(this.elements);
    }

    public ASN1Encodable[] toArrayInternal() {
        return this.elements;
    }

    public Enumeration getObjects() {
        return new Enumeration(){
            private int pos = 0;

            @Override
            public boolean hasMoreElements() {
                return this.pos < ASN1Sequence.this.elements.length;
            }

            public Object nextElement() {
                int n3 = this.pos;
                ASN1Encodable[] aSN1EncodableArray = ASN1Sequence.this.elements;
                if (n3 < ASN1Sequence.this.elements.length) {
                    this.pos = n3 + 1;
                    return aSN1EncodableArray[n3];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public ASN1SequenceParser parser() {
        final int n3 = this.size();
        return new ASN1SequenceParser(){
            private int pos = 0;

            @Override
            public ASN1Encodable readObject() {
                int n32 = aSN1Encodable.pos;
                if (aSN1Encodable.n3 == n32) {
                    return null;
                }
                aSN1Encodable.pos = n32 + 1;
                ASN1Encodable aSN1Encodable = aSN1Encodable.ASN1Sequence.this.elements[n32];
                if (aSN1Encodable instanceof ASN1Sequence) {
                    return ((ASN1Sequence)aSN1Encodable).parser();
                }
                if (aSN1Encodable instanceof ASN1Set) {
                    return ((ASN1Set)aSN1Encodable).parser();
                }
                return aSN1Encodable;
            }

            @Override
            public ASN1Primitive getLoadedObject() {
                return ASN1Sequence.this;
            }

            @Override
            public ASN1Primitive toASN1Primitive() {
                return ASN1Sequence.this;
            }
        };
    }

    public ASN1Encodable getObjectAt(int n3) {
        return this.elements[n3];
    }

    public int size() {
        return this.elements.length;
    }

    @Override
    public int hashCode() {
        int n3 = this.elements.length;
        int n4 = n3 + 1;
        while ((n3 += -1) >= 0) {
            n4 = n4 * 257 ^ this.elements[n3].toASN1Primitive().hashCode();
        }
        return n4;
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Sequence)) {
            return false;
        }
        aSN1Primitive = (ASN1Sequence)aSN1Primitive;
        int n3 = this.size();
        if (((ASN1Sequence)aSN1Primitive).size() != n3) {
            return false;
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            ASN1Primitive aSN1Primitive2;
            ASN1Primitive aSN1Primitive3 = this.elements[i3].toASN1Primitive();
            if (aSN1Primitive3 == (aSN1Primitive2 = ((ASN1Sequence)aSN1Primitive).elements[i3].toASN1Primitive()) || aSN1Primitive3.asn1Equals(aSN1Primitive2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ASN1Primitive toDERObject() {
        return new DERSequence(this.elements, false);
    }

    @Override
    public ASN1Primitive toDLObject() {
        return new DLSequence(this.elements, false);
    }

    @Override
    public boolean isConstructed() {
        return true;
    }

    @Override
    public abstract void encode(ASN1OutputStream var1, boolean var2);

    public String toString() {
        StringBuffer stringBuffer;
        int n3 = this.size();
        if (n3 == 0) {
            return "[]";
        }
        StringBuffer stringBuffer2 = stringBuffer;
        new StringBuffer().append('[');
        int n4 = 0;
        while (true) {
            stringBuffer2.append(this.elements[n4]);
            if (++n4 >= n3) {
                StringBuffer stringBuffer3 = stringBuffer2;
                stringBuffer3.append(']');
                return stringBuffer3.toString();
            }
            stringBuffer2.append(", ");
        }
    }

    @Override
    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator<ASN1Encodable>(this.elements);
    }
}

