/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Exception;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERApplicationSpecificParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BEROctetStringParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSequenceParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERSetParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.BERTaggedObjectParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERExternalParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetStringParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLApplicationSpecific;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSequenceParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLSetParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DLTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DefiniteLengthInputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.InMemoryRepresentable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.IndefiniteLengthInputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.h;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;
    private final byte[][] tmpBuffers;

    public ASN1StreamParser(InputStream inputStream) {
        this(inputStream, StreamUtil.findLimit(inputStream));
    }

    public ASN1StreamParser(InputStream inputStream, int n3) {
        ASN1StreamParser aSN1StreamParser = this;
        this._in = inputStream;
        aSN1StreamParser._limit = n3;
        aSN1StreamParser.tmpBuffers = new byte[11][];
    }

    public ASN1StreamParser(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream;
        ASN1StreamParser aSN1StreamParser = byteArrayInputStream2;
        ByteArrayInputStream byteArrayInputStream2 = byteArrayInputStream;
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        aSN1StreamParser(byteArrayInputStream2, byArray.length);
    }

    private void set00Check(boolean bl) {
        InputStream inputStream = ((ASN1StreamParser)((Object)inputStream))._in;
        if (inputStream instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)inputStream).setEofOn00(bl);
        }
    }

    public ASN1Encodable readIndef(int n3) {
        if (n3 != 4) {
            if (n3 != 8) {
                if (n3 != 16) {
                    if (n3 == 17) {
                        return new BERSetParser(this);
                    }
                    throw new ASN1Exception(h.a(n3, b.a("unknown BER object encountered: 0x")));
                }
                return new BERSequenceParser(this);
            }
            return new DERExternalParser(this);
        }
        return new BEROctetStringParser(this);
    }

    public ASN1Encodable readImplicit(boolean bl, int n3) {
        InputStream inputStream;
        block11: {
            block12: {
                block13: {
                    block10: {
                        block7: {
                            block8: {
                                block9: {
                                    inputStream = this._in;
                                    if (inputStream instanceof IndefiniteLengthInputStream) {
                                        if (bl) {
                                            return this.readIndef(n3);
                                        }
                                        throw new IOException("indefinite-length primitive encoding encountered");
                                    }
                                    if (!bl) break block7;
                                    if (n3 == 4) break block8;
                                    if (n3 == 16) break block9;
                                    if (n3 == 17) {
                                        return new DLSetParser(this);
                                    }
                                    break block10;
                                }
                                return new DLSequenceParser(this);
                            }
                            return new BEROctetStringParser(this);
                        }
                        if (n3 == 4) break block11;
                        if (n3 == 16) break block12;
                        if (n3 == 17) break block13;
                    }
                    throw new ASN1Exception("implicit tagging not implemented");
                }
                throw new ASN1Exception("sequences must use constructed encoding (see X.690 8.9.1/8.10.1)");
            }
            throw new ASN1Exception("sets must use constructed encoding (see X.690 8.11.1/8.12.1)");
        }
        return new DEROctetStringParser((DefiniteLengthInputStream)inputStream);
    }

    public ASN1Primitive readTaggedObject(boolean bl, int n3) {
        DLTaggedObject dLTaggedObject;
        Object object;
        if (!bl) {
            DEROctetString dEROctetString;
            object = (DefiniteLengthInputStream)((ASN1StreamParser)object)._in;
            DEROctetString dEROctetString2 = dEROctetString;
            dEROctetString = new DEROctetString(((DefiniteLengthInputStream)object).toByteArray());
            return new DLTaggedObject(false, n3, dEROctetString2);
        }
        ASN1StreamParser aSN1StreamParser = object;
        object = aSN1StreamParser.readVector();
        if (aSN1StreamParser._in instanceof IndefiniteLengthInputStream) {
            BERTaggedObject bERTaggedObject;
            if (((ASN1EncodableVector)object).size() == 1) {
                BERTaggedObject bERTaggedObject2;
                bERTaggedObject = bERTaggedObject2;
                object = ((ASN1EncodableVector)object).get(0);
                bERTaggedObject2 = new BERTaggedObject(true, n3, (ASN1Encodable)object);
            } else {
                BERTaggedObject bERTaggedObject3;
                bERTaggedObject = bERTaggedObject3;
                object = BERFactory.createSequence((ASN1EncodableVector)object);
                bERTaggedObject3 = new BERTaggedObject(false, n3, (ASN1Encodable)object);
            }
            return bERTaggedObject;
        }
        if (((ASN1EncodableVector)object).size() == 1) {
            DLTaggedObject dLTaggedObject2;
            dLTaggedObject = dLTaggedObject2;
            object = ((ASN1EncodableVector)object).get(0);
            dLTaggedObject2 = new DLTaggedObject(true, n3, (ASN1Encodable)object);
        } else {
            DLTaggedObject dLTaggedObject3;
            dLTaggedObject = dLTaggedObject3;
            object = DLFactory.createSequence((ASN1EncodableVector)object);
            dLTaggedObject3 = new DLTaggedObject(false, n3, (ASN1Encodable)object);
        }
        return dLTaggedObject;
    }

    public ASN1Encodable readObject() {
        Object object;
        DefiniteLengthInputStream definiteLengthInputStream;
        int n3 = ((ASN1StreamParser)object)._in.read();
        if (n3 == -1) {
            return null;
        }
        ASN1StreamParser aSN1StreamParser = object;
        aSN1StreamParser.set00Check(false);
        int n4 = ASN1InputStream.readTagNumber(aSN1StreamParser._in, n3);
        boolean bl = (n3 & 0x20) != 0;
        ASN1StreamParser aSN1StreamParser2 = object;
        InputStream inputStream = aSN1StreamParser2._in;
        int n5 = aSN1StreamParser2._limit;
        boolean bl2 = n4 == 4 || n4 == 16 || n4 == 17 || n4 == 8;
        int n6 = ASN1InputStream.readLength(inputStream, n5, bl2);
        if (n6 < 0) {
            if (bl) {
                ASN1StreamParser aSN1StreamParser3;
                IndefiniteLengthInputStream indefiniteLengthInputStream;
                IndefiniteLengthInputStream indefiniteLengthInputStream2 = indefiniteLengthInputStream;
                ASN1StreamParser aSN1StreamParser4 = object;
                Object object2 = aSN1StreamParser4._in;
                indefiniteLengthInputStream = new IndefiniteLengthInputStream((InputStream)object2, aSN1StreamParser4._limit);
                object2 = aSN1StreamParser3;
                aSN1StreamParser3 = new ASN1StreamParser(indefiniteLengthInputStream2, ((ASN1StreamParser)object)._limit);
                if ((n3 & 0x40) != 0) {
                    return new BERApplicationSpecificParser(n4, (ASN1StreamParser)object2);
                }
                if ((n3 & 0x80) != 0) {
                    return new BERTaggedObjectParser(true, n4, (ASN1StreamParser)object2);
                }
                return ((ASN1StreamParser)object2).readIndef(n4);
            }
            throw new IOException("indefinite-length primitive encoding encountered");
        }
        DefiniteLengthInputStream definiteLengthInputStream2 = definiteLengthInputStream;
        ASN1StreamParser aSN1StreamParser5 = object;
        InputStream inputStream2 = aSN1StreamParser5._in;
        int n7 = aSN1StreamParser5._limit;
        definiteLengthInputStream = new DefiniteLengthInputStream(inputStream2, n6, n7);
        if ((n3 & 0x40) != 0) {
            object = definiteLengthInputStream2.toByteArray();
            return new DLApplicationSpecific(bl, n4, (byte[])object);
        }
        if ((n3 & 0x80) != 0) {
            ASN1StreamParser aSN1StreamParser6;
            object = aSN1StreamParser6;
            aSN1StreamParser6 = new ASN1StreamParser(definiteLengthInputStream2);
            return new BERTaggedObjectParser(bl, n4, (ASN1StreamParser)object);
        }
        if (bl) {
            ASN1StreamParser aSN1StreamParser7;
            if (n4 != 4) {
                ASN1StreamParser aSN1StreamParser8;
                if (n4 != 8) {
                    ASN1StreamParser aSN1StreamParser9;
                    if (n4 != 16) {
                        if (n4 == 17) {
                            ASN1StreamParser aSN1StreamParser10;
                            object = aSN1StreamParser10;
                            aSN1StreamParser10 = new ASN1StreamParser(definiteLengthInputStream2);
                            return new DLSetParser((ASN1StreamParser)object);
                        }
                        throw new IOException(f.a("unknown tag ", n4, " encountered"));
                    }
                    object = aSN1StreamParser9;
                    aSN1StreamParser9 = new ASN1StreamParser(definiteLengthInputStream2);
                    return new DLSequenceParser((ASN1StreamParser)object);
                }
                object = aSN1StreamParser8;
                aSN1StreamParser8 = new ASN1StreamParser(definiteLengthInputStream2);
                return new DERExternalParser((ASN1StreamParser)object);
            }
            object = aSN1StreamParser7;
            aSN1StreamParser7 = new ASN1StreamParser(definiteLengthInputStream2);
            return new BEROctetStringParser((ASN1StreamParser)object);
        }
        if (n4 != 4) {
            try {
                return ASN1InputStream.createPrimitiveDERObject(n4, definiteLengthInputStream2, ((ASN1StreamParser)object).tmpBuffers);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
            }
        }
        return new DEROctetStringParser(definiteLengthInputStream2);
    }

    public ASN1EncodableVector readVector() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1Encodable aSN1Encodable = this.readObject();
        if (aSN1Encodable == null) {
            return new ASN1EncodableVector(0);
        }
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        do {
            if (aSN1Encodable instanceof InMemoryRepresentable) {
                aSN1EncodableVector2.add(((InMemoryRepresentable)((Object)aSN1Encodable)).getLoadedObject());
                continue;
            }
            aSN1EncodableVector2.add(aSN1Encodable.toASN1Primitive());
        } while ((aSN1Encodable = this.readObject()) != null);
        return aSN1EncodableVector2;
    }
}

