/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ParsingException;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1StreamParser;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObjectParser;
import java.io.IOException;

public class BERTaggedObjectParser
implements ASN1TaggedObjectParser {
    private boolean _constructed;
    private int _tagNumber;
    private ASN1StreamParser _parser;

    public BERTaggedObjectParser(boolean bl, int n3, ASN1StreamParser aSN1StreamParser) {
        this._constructed = bl;
        this._tagNumber = n3;
        this._parser = aSN1StreamParser;
    }

    public boolean isConstructed() {
        return this._constructed;
    }

    @Override
    public int getTagNo() {
        return this._tagNumber;
    }

    @Override
    public ASN1Encodable getObjectParser(int n3, boolean bl) {
        if (bl) {
            if (this._constructed) {
                return this._parser.readObject();
            }
            throw new IOException("Explicit tags must be constructed (see X.690 8.14.2)");
        }
        return this._parser.readImplicit(this._constructed, n3);
    }

    @Override
    public ASN1Primitive getLoadedObject() {
        BERTaggedObjectParser bERTaggedObjectParser = this;
        boolean bl = bERTaggedObjectParser._constructed;
        return this._parser.readTaggedObject(bl, bERTaggedObjectParser._tagNumber);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException(iOException.getMessage());
        }
    }
}

