/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;

public class DERNumericString
extends ASN1Primitive
implements ASN1String {
    private final byte[] string;

    public static DERNumericString getInstance(Object object) {
        if (object != null && !(object instanceof DERNumericString)) {
            if (object instanceof byte[]) {
                try {
                    return (DERNumericString)ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(d.a(exception, b.a("encoding error in getInstance: ")));
                }
            }
            throw new IllegalArgumentException(c.a(object, b.a("illegal object in getInstance: ")));
        }
        return (DERNumericString)object;
    }

    public static DERNumericString getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        aSN1Primitive = aSN1Primitive.getObject();
        if (!bl && !(aSN1Primitive instanceof DERNumericString)) {
            return new DERNumericString(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return DERNumericString.getInstance(aSN1Primitive);
    }

    public DERNumericString(byte[] byArray) {
        this.string = byArray;
    }

    public DERNumericString(String string2) {
        this(string2, false);
    }

    public DERNumericString(String string2, boolean bl) {
        if (bl && !DERNumericString.isNumericString(string2)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = Strings.toByteArray(string2);
    }

    public static boolean isNumericString(String string2) {
        for (int i3 = string2.length() - 1; i3 >= 0; --i3) {
            char c3 = string2.charAt(i3);
            if (c3 > '\u007f') {
                return false;
            }
            if ('0' <= c3 && c3 <= '9' || c3 == ' ') {
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    public boolean isConstructed() {
        return false;
    }

    @Override
    public int encodedLength() {
        return StreamUtil.calculateBodyLength(this.string.length) + 1 + this.string.length;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        Object object = ((DERNumericString)object).string;
        aSN1OutputStream.writeEncoded(bl, 18, (byte[])object);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    public boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERNumericString)) {
            return false;
        }
        DERNumericString dERNumericString = dERNumericString2;
        DERNumericString dERNumericString2 = (DERNumericString)aSN1Primitive;
        return Arrays.areEqual(dERNumericString.string, dERNumericString2.string);
    }
}

