/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;

public class DERSequence
extends ASN1Sequence {
    private int bodyLength = -1;

    public static DERSequence convert(ASN1Sequence aSN1Sequence) {
        return (DERSequence)aSN1Sequence.toDERObject();
    }

    public DERSequence() {
    }

    public DERSequence(ASN1Encodable aSN1Encodable) {
        super(aSN1Encodable);
    }

    public DERSequence(ASN1EncodableVector aSN1EncodableVector) {
        super(aSN1EncodableVector);
    }

    public DERSequence(ASN1Encodable[] aSN1EncodableArray) {
        super(aSN1EncodableArray);
    }

    public DERSequence(ASN1Encodable[] aSN1EncodableArray, boolean bl) {
        super(aSN1EncodableArray, bl);
    }

    private int getBodyLength() {
        if (this.bodyLength < 0) {
            int n3 = this.elements.length;
            int n4 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                n4 = this.elements[i3].toASN1Primitive().toDERObject().encodedLength() + n4;
            }
            this.bodyLength = n4;
        }
        return this.bodyLength;
    }

    @Override
    public int encodedLength() {
        int n3 = this.getBodyLength();
        return StreamUtil.calculateBodyLength(n3) + 1 + n3;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        if (bl) {
            aSN1OutputStream.write(48);
        }
        DERSequence dERSequence = this;
        DEROutputStream dEROutputStream = aSN1OutputStream.getDERSubStream();
        int n3 = dERSequence.elements.length;
        if (dERSequence.bodyLength < 0 && n3 <= 16) {
            int n4 = 0;
            ASN1Primitive[] aSN1PrimitiveArray = new ASN1Primitive[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                ASN1Primitive aSN1Primitive;
                aSN1PrimitiveArray[i3] = aSN1Primitive = this.elements[i3].toASN1Primitive().toDERObject();
                n4 = aSN1Primitive.encodedLength() + n4;
            }
            this.bodyLength = n4;
            aSN1OutputStream.writeLength(n4);
            for (int i4 = 0; i4 < n3; ++i4) {
                aSN1PrimitiveArray[i4].encode(dEROutputStream, true);
            }
        } else {
            aSN1OutputStream.writeLength(this.getBodyLength());
            for (int i5 = 0; i5 < n3; ++i5) {
                this.elements[i5].toASN1Primitive().toDERObject().encode(dEROutputStream, true);
            }
        }
    }

    @Override
    public ASN1Primitive toDERObject() {
        return this;
    }

    @Override
    public ASN1Primitive toDLObject() {
        return this;
    }
}

