/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.StreamUtil;

public class DERSet
extends ASN1Set {
    private int bodyLength = -1;

    public static DERSet convert(ASN1Set aSN1Set) {
        return (DERSet)aSN1Set.toDERObject();
    }

    public DERSet() {
    }

    public DERSet(ASN1Encodable aSN1Encodable) {
        super(aSN1Encodable);
    }

    public DERSet(ASN1EncodableVector aSN1EncodableVector) {
        super(aSN1EncodableVector, true);
    }

    public DERSet(ASN1Encodable[] aSN1EncodableArray) {
        super(aSN1EncodableArray, true);
    }

    public DERSet(boolean bl, ASN1Encodable[] aSN1EncodableArray) {
        super(DERSet.checkSorted(bl), aSN1EncodableArray);
    }

    private int getBodyLength() {
        if (this.bodyLength < 0) {
            int n3 = this.elements.length;
            int n4 = 0;
            for (int i3 = 0; i3 < n3; ++i3) {
                n4 = this.elements[i3].toASN1Primitive().toDERObject().encodedLength() + n4;
            }
            this.bodyLength = n4;
        }
        return this.bodyLength;
    }

    private static boolean checkSorted(boolean bl) {
        if (bl) {
            return bl;
        }
        throw new IllegalStateException("DERSet elements should always be in sorted order");
    }

    @Override
    public int encodedLength() {
        int n3 = this.getBodyLength();
        return StreamUtil.calculateBodyLength(n3) + 1 + n3;
    }

    @Override
    public void encode(ASN1OutputStream aSN1OutputStream, boolean bl) {
        if (bl) {
            aSN1OutputStream.write(49);
        }
        DERSet dERSet = this;
        DEROutputStream dEROutputStream = aSN1OutputStream.getDERSubStream();
        int n3 = dERSet.elements.length;
        if (dERSet.bodyLength < 0 && n3 <= 16) {
            int n4 = 0;
            ASN1Primitive[] aSN1PrimitiveArray = new ASN1Primitive[n3];
            for (int i3 = 0; i3 < n3; ++i3) {
                ASN1Primitive aSN1Primitive;
                aSN1PrimitiveArray[i3] = aSN1Primitive = this.elements[i3].toASN1Primitive().toDERObject();
                n4 = aSN1Primitive.encodedLength() + n4;
            }
            this.bodyLength = n4;
            aSN1OutputStream.writeLength(n4);
            for (int i4 = 0; i4 < n3; ++i4) {
                aSN1PrimitiveArray[i4].encode(dEROutputStream, true);
            }
        } else {
            aSN1OutputStream.writeLength(this.getBodyLength());
            for (int i5 = 0; i5 < n3; ++i5) {
                this.elements[i5].toASN1Primitive().toDERObject().encode(dEROutputStream, true);
            }
        }
    }

    @Override
    public ASN1Primitive toDERObject() {
        if (!aSN1Primitive.isSorted) {
            ASN1Primitive aSN1Primitive = super.toDERObject();
        }
        return aSN1Primitive;
    }

    @Override
    public ASN1Primitive toDLObject() {
        return this;
    }
}

