/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.LimitedInputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.io.Streams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class DefiniteLengthInputStream
extends LimitedInputStream {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final int _originalLength;
    private int _remaining;

    public DefiniteLengthInputStream(InputStream inputStream, int n3, int n4) {
        super(inputStream, n4);
        if (n3 >= 0) {
            DefiniteLengthInputStream definiteLengthInputStream = this;
            definiteLengthInputStream._originalLength = n3;
            definiteLengthInputStream._remaining = n3;
            if (n3 == 0) {
                this.setParentEofDetect(true);
            }
            return;
        }
        throw new IllegalArgumentException("negative lengths not allowed");
    }

    public int getRemaining() {
        return this._remaining;
    }

    @Override
    public int read() {
        if (this._remaining == 0) {
            return -1;
        }
        int n3 = this._in.read();
        if (n3 >= 0) {
            if (--this._remaining == 0) {
                this.setParentEofDetect(true);
            }
            return n3;
        }
        throw new EOFException(b.a("DEF length ").append(this._originalLength).append(" object truncated by ").append(this._remaining).toString());
    }

    @Override
    public int read(byte[] byArray, int n3, int n4) {
        int n5 = this._remaining;
        if (n5 == 0) {
            return -1;
        }
        int n6 = this._in.read(byArray, n3, n4 = Math.min(n4, n5));
        if (n6 >= 0) {
            if ((this._remaining -= n6) == 0) {
                this.setParentEofDetect(true);
            }
            return n6;
        }
        throw new EOFException(b.a("DEF length ").append(this._originalLength).append(" object truncated by ").append(this._remaining).toString());
    }

    public void readAllIntoByteArray(byte[] byArray) {
        int n3 = this._remaining;
        if (n3 == byArray.length) {
            if (n3 == 0) {
                return;
            }
            DefiniteLengthInputStream definiteLengthInputStream = this;
            int n4 = definiteLengthInputStream._remaining;
            n3 = definiteLengthInputStream.getLimit();
            if (n4 < n3) {
                this._remaining = n4 - Streams.readFully(this._in, byArray);
                if (this._remaining == 0) {
                    this.setParentEofDetect(true);
                    return;
                }
                throw new EOFException(b.a("DEF length ").append(this._originalLength).append(" object truncated by ").append(this._remaining).toString());
            }
            throw new IOException(b.a("corrupted stream - out of bounds length found: ").append(this._remaining).append(" >= ").append(n3).toString());
        }
        throw new IllegalArgumentException("buffer length not right for data");
    }

    public byte[] toByteArray() {
        if (this._remaining == 0) {
            return EMPTY_BYTES;
        }
        DefiniteLengthInputStream definiteLengthInputStream = this;
        int n3 = definiteLengthInputStream._remaining;
        int n4 = definiteLengthInputStream.getLimit();
        if (n3 < n4) {
            byte[] byArray = new byte[n3];
            this._remaining = n3 - Streams.readFully(this._in, byArray);
            if (this._remaining == 0) {
                this.setParentEofDetect(true);
                return byArray;
            }
            throw new EOFException(b.a("DEF length ").append(this._originalLength).append(" object truncated by ").append(this._remaining).toString());
        }
        throw new IOException(b.a("corrupted stream - out of bounds length found: ").append(this._remaining).append(" >= ").append(n4).toString());
    }
}

