/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.anssi;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.anssi.ANSSIObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECParametersHolder;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;

public class ANSSINamedCurves {
    public static X9ECParametersHolder FRP256v1 = new X9ECParametersHolder(){

        @Override
        public X9ECParameters createParameters() {
            Object object = ANSSINamedCurves.fromHex("F1FD178C0B3AD58F10126DE8CE42435B3961ADBCABC8CA6DE8FCF353D86E9C03");
            Object object2 = ANSSINamedCurves.fromHex("F1FD178C0B3AD58F10126DE8CE42435B3961ADBCABC8CA6DE8FCF353D86E9C00");
            BigInteger bigInteger = ANSSINamedCurves.fromHex("EE353FCA5428A9300D4ABA754A44C00FDFEC0C9AE4B1A1803075ED967B7BB73F");
            BigInteger bigInteger2 = ANSSINamedCurves.fromHex("F1FD178C0B3AD58F10126DE8CE42435B53DC67E140D2BF941FFDD459C6D655E1");
            BigInteger bigInteger3 = BigInteger.valueOf(1L);
            object = ANSSINamedCurves.configureCurve(new ECCurve.Fp((BigInteger)object, (BigInteger)object2, bigInteger, bigInteger2, bigInteger3));
            object2 = ANSSINamedCurves.configureBasepoint((ECCurve)object, "04B6B3D4C356C139EB31183D4749D423958C27D2DCAF98B70164C97A2DD98F5CFF6142E0F7C8B204911F9271F0F3ECEF8C2701C307E8E4C9E183115A1554062CFB");
            return new X9ECParameters((ECCurve)object, (X9ECPoint)object2, bigInteger2, bigInteger3, null);
        }
    };
    public static final Hashtable objIds = new Hashtable();
    public static final Hashtable curves = new Hashtable();
    public static final Hashtable names = new Hashtable();

    private static X9ECPoint configureBasepoint(ECCurve eCCurve, String string2) {
        X9ECPoint x9ECPoint = new X9ECPoint(eCCurve, Hex.decodeStrict(string2));
        WNafUtil.configureBasepoint(x9ECPoint.getPoint());
        return x9ECPoint;
    }

    private static ECCurve configureCurve(ECCurve eCCurve) {
        return eCCurve;
    }

    private static BigInteger fromHex(String string2) {
        return new BigInteger(1, Hex.decodeStrict(string2));
    }

    public static void defineCurve(String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier, X9ECParametersHolder x9ECParametersHolder) {
        objIds.put(Strings.toLowerCase(string2), aSN1ObjectIdentifier);
        names.put(aSN1ObjectIdentifier, string2);
        curves.put(aSN1ObjectIdentifier, x9ECParametersHolder);
    }

    public static X9ECParameters getByName(String object) {
        return (object = ANSSINamedCurves.getOID((String)object)) == null ? null : ANSSINamedCurves.getByOID((ASN1ObjectIdentifier)object);
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier object) {
        return (object = (X9ECParametersHolder)curves.get(object)) == null ? null : ((X9ECParametersHolder)object).getParameters();
    }

    public static ASN1ObjectIdentifier getOID(String string2) {
        return (ASN1ObjectIdentifier)objIds.get(Strings.toLowerCase(string2));
    }

    public static String getName(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (String)names.get(aSN1ObjectIdentifier);
    }

    public static Enumeration getNames() {
        return names.elements();
    }

    static {
        X9ECParametersHolder x9ECParametersHolder = FRP256v1;
        ANSSINamedCurves.defineCurve("FRP256v1", ANSSIObjectIdentifiers.FRP256v1, x9ECParametersHolder);
    }
}

