/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate;

public class EncryptedPrivateKeyData
extends ASN1Object {
    private final EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
    private final Certificate[] certificateChain;

    public EncryptedPrivateKeyData(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, Certificate[] certificateArray) {
        Certificate[] certificateArray2 = certificateArray3;
        certificateArray3.encryptedPrivateKeyInfo = encryptedPrivateKeyInfo;
        Certificate[] certificateArray3 = new Certificate[certificateArray.length];
        certificateArray2.certificateChain = certificateArray3;
        int n3 = certificateArray.length;
        System.arraycopy(certificateArray, 0, certificateArray3, 0, n3);
    }

    private EncryptedPrivateKeyData(ASN1Sequence aSN1Sequence) {
        this.encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(aSN1Sequence.getObjectAt(0));
        aSN1Sequence = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
        this.certificateChain = new Certificate[aSN1Sequence.size()];
        int n3 = 0;
        while (true) {
            Certificate[] certificateArray = this.certificateChain;
            if (n3 == this.certificateChain.length) break;
            certificateArray[n3] = Certificate.getInstance(aSN1Sequence.getObjectAt(n3));
            ++n3;
        }
    }

    public static EncryptedPrivateKeyData getInstance(Object object) {
        if (object instanceof EncryptedPrivateKeyData) {
            return (EncryptedPrivateKeyData)object;
        }
        if (object != null) {
            return new EncryptedPrivateKeyData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public Certificate[] getCertificateChain() {
        Certificate[] certificateArray = certificateArray.certificateChain;
        Certificate[] certificateArray2 = new Certificate[certificateArray.certificateChain.length];
        int n3 = certificateArray.length;
        System.arraycopy(certificateArray, 0, certificateArray2, 0, n3);
        return certificateArray2;
    }

    public EncryptedPrivateKeyInfo getEncryptedPrivateKeyInfo() {
        return this.encryptedPrivateKeyInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(2);
        aSN1EncodableVector.add(this.encryptedPrivateKeyInfo);
        aSN1EncodableVector.add(new DERSequence(this.certificateChain));
        return new DERSequence(aSN1EncodableVector2);
    }
}

