/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERGeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERUTF8String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.ObjectDataSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import java.math.BigInteger;
import java.util.Date;

public class ObjectStoreData
extends ASN1Object {
    private final BigInteger version;
    private final AlgorithmIdentifier integrityAlgorithm;
    private final ASN1GeneralizedTime creationDate;
    private final ASN1GeneralizedTime lastModifiedDate;
    private final ObjectDataSequence objectDataSequence;
    private final String comment;

    public ObjectStoreData(AlgorithmIdentifier algorithmIdentifier, Date date, Date date2, ObjectDataSequence objectDataSequence, String string2) {
        ObjectStoreData objectStoreData = this;
        this.version = BigInteger.valueOf(1L);
        objectStoreData.integrityAlgorithm = algorithmIdentifier;
        objectStoreData.creationDate = new DERGeneralizedTime(date);
        objectStoreData.lastModifiedDate = new DERGeneralizedTime(date2);
        this.objectDataSequence = objectDataSequence;
        this.comment = string2;
    }

    private ObjectStoreData(ASN1Sequence object) {
        this.version = ASN1Integer.getInstance(((ASN1Sequence)object).getObjectAt(0)).getValue();
        this.integrityAlgorithm = AlgorithmIdentifier.getInstance(((ASN1Sequence)object).getObjectAt(1));
        this.creationDate = ASN1GeneralizedTime.getInstance(((ASN1Sequence)object).getObjectAt(2));
        this.lastModifiedDate = ASN1GeneralizedTime.getInstance(((ASN1Sequence)object).getObjectAt(3));
        this.objectDataSequence = ObjectDataSequence.getInstance(((ASN1Sequence)object).getObjectAt(4));
        object = ((ASN1Sequence)object).size() == 6 ? DERUTF8String.getInstance(((ASN1Sequence)object).getObjectAt(5)).getString() : null;
        this.comment = object;
    }

    public static ObjectStoreData getInstance(Object object) {
        if (object instanceof ObjectStoreData) {
            return (ObjectStoreData)object;
        }
        if (object != null) {
            return new ObjectStoreData(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public String getComment() {
        return this.comment;
    }

    public ASN1GeneralizedTime getCreationDate() {
        return this.creationDate;
    }

    public AlgorithmIdentifier getIntegrityAlgorithm() {
        return this.integrityAlgorithm;
    }

    public ASN1GeneralizedTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public ObjectDataSequence getObjectDataSequence() {
        return this.objectDataSequence;
    }

    public BigInteger getVersion() {
        return this.version;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector3 = aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector3(6);
        aSN1EncodableVector3.add(new ASN1Integer(((ObjectStoreData)((Object)string2)).version));
        aSN1EncodableVector2.add(((ObjectStoreData)((Object)string2)).integrityAlgorithm);
        aSN1EncodableVector2.add(((ObjectStoreData)((Object)string2)).creationDate);
        aSN1EncodableVector2.add(((ObjectStoreData)((Object)string2)).lastModifiedDate);
        aSN1EncodableVector.add(((ObjectStoreData)((Object)string2)).objectDataSequence);
        String string2 = ((ObjectStoreData)((Object)string2)).comment;
        if (string2 != null) {
            DERUTF8String dERUTF8String;
            DERUTF8String dERUTF8String2 = dERUTF8String;
            dERUTF8String = new DERUTF8String(string2);
            aSN1EncodableVector2.add(dERUTF8String2);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

