/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.PKIPublicationInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;

public class CMCPublicationInfo
extends ASN1Object {
    private final AlgorithmIdentifier hashAlg;
    private final ASN1Sequence certHashes;
    private final PKIPublicationInfo pubInfo;

    public CMCPublicationInfo(AlgorithmIdentifier object, byte[][] byArray, PKIPublicationInfo pKIPublicationInfo) {
        DERSequence dERSequence;
        ASN1EncodableVector aSN1EncodableVector;
        aSN1Object.hashAlg = object;
        object = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(byArray.length);
        for (int i3 = 0; i3 != byArray.length; ++i3) {
            ((ASN1EncodableVector)object).add(new DEROctetString(Arrays.clone(byArray[i3])));
        }
        CMCPublicationInfo cMCPublicationInfo = aSN1Object;
        ASN1Object aSN1Object = dERSequence;
        dERSequence = new DERSequence((ASN1EncodableVector)object);
        cMCPublicationInfo.certHashes = aSN1Object;
        cMCPublicationInfo.pubInfo = pKIPublicationInfo;
    }

    private CMCPublicationInfo(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 3) {
            this.hashAlg = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(0));
            this.certHashes = ASN1Sequence.getInstance(aSN1Sequence.getObjectAt(1));
            this.pubInfo = PKIPublicationInfo.getInstance(aSN1Sequence.getObjectAt(2));
            return;
        }
        throw new IllegalArgumentException("incorrect sequence size");
    }

    public static CMCPublicationInfo getInstance(Object object) {
        if (object instanceof CMCPublicationInfo) {
            return (CMCPublicationInfo)object;
        }
        if (object != null) {
            return new CMCPublicationInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.hashAlg;
    }

    public byte[][] getCertHashes() {
        int n3 = this.certHashes.size();
        byte[][] byArrayArray = new byte[n3][];
        for (int i3 = 0; i3 != n3; ++i3) {
            byArrayArray[i3] = a.a(this.certHashes, i3);
        }
        return byArrayArray;
    }

    public PKIPublicationInfo getPubInfo() {
        return this.pubInfo;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector2.add(this.hashAlg);
        aSN1EncodableVector2.add(this.certHashes);
        aSN1EncodableVector.add(this.pubInfo);
        return new DERSequence(aSN1EncodableVector2);
    }
}

