/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERUTF8String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CRLReason;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

public class RevokeRequest
extends ASN1Object {
    private final X500Name name;
    private final ASN1Integer serialNumber;
    private final CRLReason reason;
    private ASN1GeneralizedTime invalidityDate;
    private ASN1OctetString passphrase;
    private DERUTF8String comment;

    public RevokeRequest(X500Name x500Name, ASN1Integer aSN1Integer, CRLReason cRLReason, ASN1GeneralizedTime aSN1GeneralizedTime, ASN1OctetString aSN1OctetString, DERUTF8String dERUTF8String) {
        this.name = x500Name;
        this.serialNumber = aSN1Integer;
        this.reason = cRLReason;
        this.invalidityDate = aSN1GeneralizedTime;
        this.passphrase = aSN1OctetString;
        this.comment = dERUTF8String;
    }

    private RevokeRequest(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() >= 3 && aSN1Sequence.size() <= 6) {
            this.name = X500Name.getInstance(aSN1Sequence.getObjectAt(0));
            this.serialNumber = ASN1Integer.getInstance(aSN1Sequence.getObjectAt(1));
            this.reason = CRLReason.getInstance(aSN1Sequence.getObjectAt(2));
            int n3 = 3;
            if (aSN1Sequence.size() > n3 && aSN1Sequence.getObjectAt(n3).toASN1Primitive() instanceof ASN1GeneralizedTime) {
                int n4 = n3;
                n3 = 4;
                this.invalidityDate = ASN1GeneralizedTime.getInstance(aSN1Sequence.getObjectAt(n4));
            }
            if (aSN1Sequence.size() > n3 && aSN1Sequence.getObjectAt(n3).toASN1Primitive() instanceof ASN1OctetString) {
                this.passphrase = ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(n3++));
            }
            if (aSN1Sequence.size() > n3 && aSN1Sequence.getObjectAt(n3).toASN1Primitive() instanceof DERUTF8String) {
                this.comment = DERUTF8String.getInstance(aSN1Sequence.getObjectAt(n3));
            }
            return;
        }
        throw new IllegalArgumentException("incorrect sequence size");
    }

    public static RevokeRequest getInstance(Object object) {
        if (object instanceof RevokeRequest) {
            return (RevokeRequest)object;
        }
        if (object != null) {
            return new RevokeRequest(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public X500Name getName() {
        return this.name;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber.getValue();
    }

    public CRLReason getReason() {
        return this.reason;
    }

    public ASN1GeneralizedTime getInvalidityDate() {
        return this.invalidityDate;
    }

    public void setInvalidityDate(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.invalidityDate = aSN1GeneralizedTime;
    }

    public ASN1OctetString getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(ASN1OctetString aSN1OctetString) {
        this.passphrase = aSN1OctetString;
    }

    public DERUTF8String getComment() {
        return this.comment;
    }

    public void setComment(DERUTF8String dERUTF8String) {
        this.comment = dERUTF8String;
    }

    public byte[] getPassPhrase() {
        ASN1Object aSN1Object = ((RevokeRequest)aSN1Object).passphrase;
        if (aSN1Object != null) {
            return Arrays.clone(((ASN1OctetString)aSN1Object).getOctets());
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        DERUTF8String dERUTF8String;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(6);
        aSN1EncodableVector2.add(this.name);
        aSN1EncodableVector2.add(this.serialNumber);
        aSN1EncodableVector.add(this.reason);
        ASN1Primitive aSN1Primitive = this.invalidityDate;
        if (aSN1Primitive != null) {
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        if ((aSN1Primitive = this.passphrase) != null) {
            aSN1EncodableVector2.add(aSN1Primitive);
        }
        if ((dERUTF8String = this.comment) != null) {
            aSN1EncodableVector2.add(dERUTF8String);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

