/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Choice;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AttributeCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate;
import java.io.IOException;

public class CMPCertificate
extends ASN1Object
implements ASN1Choice {
    private Certificate x509v3PKCert;
    private int otherTagValue;
    private ASN1Object otherCert;

    public CMPCertificate(AttributeCertificate attributeCertificate) {
        this(1, attributeCertificate);
    }

    public CMPCertificate(int n3, ASN1Object aSN1Object) {
        this.otherTagValue = n3;
        this.otherCert = aSN1Object;
    }

    public CMPCertificate(Certificate certificate) {
        if (certificate.getVersionNumber() == 3) {
            this.x509v3PKCert = certificate;
            return;
        }
        throw new IllegalArgumentException("only version 3 certificates allowed");
    }

    public static CMPCertificate getInstance(Object object) {
        if (object != null && !(object instanceof CMPCertificate)) {
            if (object instanceof byte[]) {
                try {
                    object = ASN1Primitive.fromByteArray((byte[])object);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("Invalid encoding in CMPCertificate");
                }
            }
            if (object instanceof ASN1Sequence) {
                return new CMPCertificate(Certificate.getInstance(object));
            }
            if (object instanceof ASN1TaggedObject) {
                Object object2 = object = (ASN1TaggedObject)object;
                int n3 = ((ASN1TaggedObject)object2).getTagNo();
                return new CMPCertificate(n3, ((ASN1TaggedObject)object2).getObject());
            }
            throw new IllegalArgumentException(c.a(object, b.a("Invalid object: ")));
        }
        return (CMPCertificate)object;
    }

    public boolean isX509v3PKCert() {
        return this.x509v3PKCert != null;
    }

    public Certificate getX509v3PKCert() {
        return this.x509v3PKCert;
    }

    public AttributeCertificate getX509v2AttrCert() {
        return AttributeCertificate.getInstance(this.otherCert);
    }

    public int getOtherCertTag() {
        return this.otherTagValue;
    }

    public ASN1Object getOtherCert() {
        return this.otherCert;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1Object aSN1Object = this.otherCert;
        if (aSN1Object != null) {
            return new DERTaggedObject(true, this.otherTagValue, aSN1Object);
        }
        return this.x509v3PKCert.toASN1Primitive();
    }
}

