/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.CMPCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.CertifiedKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIStatusInfo;

public class KeyRecRepContent
extends ASN1Object {
    private PKIStatusInfo status;
    private CMPCertificate newSigCert;
    private ASN1Sequence caCerts;
    private ASN1Sequence keyPairHist;

    private KeyRecRepContent(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        this.status = PKIStatusInfo.getInstance(object.nextElement());
        while (object.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(object.nextElement());
            int n3 = aSN1TaggedObject.getTagNo();
            if (n3 != 0) {
                if (n3 != 1) {
                    if (n3 == 2) {
                        this.keyPairHist = ASN1Sequence.getInstance(aSN1TaggedObject.getObject());
                        continue;
                    }
                    throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a(aSN1TaggedObject, b.a("unknown tag number: ")));
                }
                this.caCerts = ASN1Sequence.getInstance(aSN1TaggedObject.getObject());
                continue;
            }
            this.newSigCert = CMPCertificate.getInstance(aSN1TaggedObject.getObject());
        }
    }

    public static KeyRecRepContent getInstance(Object object) {
        if (object instanceof KeyRecRepContent) {
            return (KeyRecRepContent)object;
        }
        if (object != null) {
            return new KeyRecRepContent(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n3, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            DERTaggedObject dERTaggedObject;
            ASN1Object aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, n3, aSN1Encodable);
            aSN1EncodableVector.add(aSN1Object);
        }
    }

    public PKIStatusInfo getStatus() {
        return this.status;
    }

    public CMPCertificate getNewSigCert() {
        return this.newSigCert;
    }

    public CMPCertificate[] getCaCerts() {
        ASN1Sequence aSN1Sequence = this.caCerts;
        if (aSN1Sequence == null) {
            return null;
        }
        int n3 = aSN1Sequence.size();
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            cMPCertificateArray[i3] = CMPCertificate.getInstance(this.caCerts.getObjectAt(i3));
        }
        return cMPCertificateArray;
    }

    public CertifiedKeyPair[] getKeyPairHist() {
        ASN1Sequence aSN1Sequence = this.keyPairHist;
        if (aSN1Sequence == null) {
            return null;
        }
        int n3 = aSN1Sequence.size();
        CertifiedKeyPair[] certifiedKeyPairArray = new CertifiedKeyPair[n3];
        for (int i3 = 0; i3 != n3; ++i3) {
            certifiedKeyPairArray[i3] = CertifiedKeyPair.getInstance(this.keyPairHist.getObjectAt(i3));
        }
        return certifiedKeyPairArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        KeyRecRepContent keyRecRepContent = aSN1Object;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(4);
        aSN1EncodableVector.add(aSN1Object.status);
        ASN1Object aSN1Object = keyRecRepContent.newSigCert;
        keyRecRepContent.addOptional(aSN1EncodableVector2, 0, aSN1Object);
        aSN1Object = keyRecRepContent.caCerts;
        keyRecRepContent.addOptional(aSN1EncodableVector2, 1, aSN1Object);
        aSN1Object = keyRecRepContent.keyPairHist;
        keyRecRepContent.addOptional(aSN1EncodableVector2, 2, aSN1Object);
        return new DERSequence(aSN1EncodableVector2);
    }
}

