/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.InfoTypeAndValue;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIFreeText;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;

public class PKIHeader
extends ASN1Object {
    public static final GeneralName NULL_NAME = new GeneralName(X500Name.getInstance(new DERSequence()));
    public static final int CMP_1999 = 1;
    public static final int CMP_2000 = 2;
    private ASN1Integer pvno;
    private GeneralName sender;
    private GeneralName recipient;
    private ASN1GeneralizedTime messageTime;
    private AlgorithmIdentifier protectionAlg;
    private ASN1OctetString senderKID;
    private ASN1OctetString recipKID;
    private ASN1OctetString transactionID;
    private ASN1OctetString senderNonce;
    private ASN1OctetString recipNonce;
    private PKIFreeText freeText;
    private ASN1Sequence generalInfo;

    private PKIHeader(ASN1Sequence object) {
        PKIHeader pKIHeader = this;
        object = ((ASN1Sequence)object).getObjects();
        pKIHeader.pvno = ASN1Integer.getInstance(object.nextElement());
        pKIHeader.sender = GeneralName.getInstance(object.nextElement());
        pKIHeader.recipient = GeneralName.getInstance(object.nextElement());
        block11: while (object.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object.nextElement();
            switch (aSN1TaggedObject.getTagNo()) {
                default: {
                    throw new IllegalArgumentException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmc.b.a(aSN1TaggedObject, b.a("unknown tag number: ")));
                }
                case 8: {
                    this.generalInfo = ASN1Sequence.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 7: {
                    this.freeText = PKIFreeText.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 6: {
                    this.recipNonce = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 5: {
                    this.senderNonce = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 4: {
                    this.transactionID = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 3: {
                    this.recipKID = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 2: {
                    this.senderKID = ASN1OctetString.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 1: {
                    this.protectionAlg = AlgorithmIdentifier.getInstance(aSN1TaggedObject, true);
                    continue block11;
                }
                case 0: 
            }
            this.messageTime = ASN1GeneralizedTime.getInstance(aSN1TaggedObject, true);
        }
    }

    public static PKIHeader getInstance(Object object) {
        if (object instanceof PKIHeader) {
            return (PKIHeader)object;
        }
        if (object != null) {
            return new PKIHeader(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public PKIHeader(int n3, GeneralName generalName, GeneralName generalName2) {
        this(new ASN1Integer(n3), generalName, generalName2);
    }

    private PKIHeader(ASN1Integer aSN1Integer, GeneralName generalName, GeneralName generalName2) {
        this.pvno = aSN1Integer;
        this.sender = generalName;
        this.recipient = generalName2;
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n3, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            DERTaggedObject dERTaggedObject;
            ASN1Object aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, n3, aSN1Encodable);
            aSN1EncodableVector.add(aSN1Object);
        }
    }

    public ASN1Integer getPvno() {
        return this.pvno;
    }

    public GeneralName getSender() {
        return this.sender;
    }

    public GeneralName getRecipient() {
        return this.recipient;
    }

    public ASN1GeneralizedTime getMessageTime() {
        return this.messageTime;
    }

    public AlgorithmIdentifier getProtectionAlg() {
        return this.protectionAlg;
    }

    public ASN1OctetString getSenderKID() {
        return this.senderKID;
    }

    public ASN1OctetString getRecipKID() {
        return this.recipKID;
    }

    public ASN1OctetString getTransactionID() {
        return this.transactionID;
    }

    public ASN1OctetString getSenderNonce() {
        return this.senderNonce;
    }

    public ASN1OctetString getRecipNonce() {
        return this.recipNonce;
    }

    public PKIFreeText getFreeText() {
        return this.freeText;
    }

    public InfoTypeAndValue[] getGeneralInfo() {
        ASN1Sequence aSN1Sequence = this.generalInfo;
        if (aSN1Sequence == null) {
            return null;
        }
        int n3 = aSN1Sequence.size();
        InfoTypeAndValue[] infoTypeAndValueArray = new InfoTypeAndValue[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            infoTypeAndValueArray[i3] = InfoTypeAndValue.getInstance(this.generalInfo.getObjectAt(i3));
        }
        return infoTypeAndValueArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        PKIHeader pKIHeader = aSN1Object;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(12);
        aSN1EncodableVector2.add(aSN1Object.pvno);
        aSN1EncodableVector2.add(aSN1Object.sender);
        aSN1EncodableVector.add(aSN1Object.recipient);
        ASN1Object aSN1Object = pKIHeader.messageTime;
        pKIHeader.addOptional(aSN1EncodableVector2, 0, aSN1Object);
        aSN1Object = pKIHeader.protectionAlg;
        pKIHeader.addOptional(aSN1EncodableVector2, 1, aSN1Object);
        aSN1Object = pKIHeader.senderKID;
        pKIHeader.addOptional(aSN1EncodableVector2, 2, aSN1Object);
        aSN1Object = pKIHeader.recipKID;
        pKIHeader.addOptional(aSN1EncodableVector2, 3, aSN1Object);
        aSN1Object = pKIHeader.transactionID;
        pKIHeader.addOptional(aSN1EncodableVector2, 4, aSN1Object);
        aSN1Object = pKIHeader.senderNonce;
        pKIHeader.addOptional(aSN1EncodableVector2, 5, aSN1Object);
        aSN1Object = pKIHeader.recipNonce;
        pKIHeader.addOptional(aSN1EncodableVector2, 6, aSN1Object);
        aSN1Object = pKIHeader.freeText;
        pKIHeader.addOptional(aSN1EncodableVector2, 7, aSN1Object);
        aSN1Object = pKIHeader.generalInfo;
        pKIHeader.addOptional(aSN1EncodableVector2, 8, aSN1Object);
        return new DERSequence(aSN1EncodableVector2);
    }
}

