/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.CMPCertificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIBody;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cmp.PKIHeader;

public class PKIMessage
extends ASN1Object {
    private PKIHeader header;
    private PKIBody body;
    private DERBitString protection;
    private ASN1Sequence extraCerts;

    private PKIMessage(ASN1Sequence object) {
        PKIMessage pKIMessage = this;
        object = ((ASN1Sequence)object).getObjects();
        pKIMessage.header = PKIHeader.getInstance(object.nextElement());
        pKIMessage.body = PKIBody.getInstance(object.nextElement());
        while (object.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)object.nextElement();
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.protection = DERBitString.getInstance(aSN1TaggedObject, true);
                continue;
            }
            this.extraCerts = ASN1Sequence.getInstance(aSN1TaggedObject, true);
        }
    }

    public static PKIMessage getInstance(Object object) {
        if (object instanceof PKIMessage) {
            return (PKIMessage)object;
        }
        if (object != null) {
            return new PKIMessage(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public PKIMessage(PKIHeader pKIHeader, PKIBody pKIBody, DERBitString dERBitString, CMPCertificate[] cMPCertificateArray) {
        aSN1Object.header = pKIHeader;
        aSN1Object.body = pKIBody;
        aSN1Object.protection = dERBitString;
        if (cMPCertificateArray != null) {
            DERSequence dERSequence;
            PKIMessage pKIMessage = aSN1Object;
            ASN1Object aSN1Object = dERSequence;
            dERSequence = new DERSequence(cMPCertificateArray);
            pKIMessage.extraCerts = aSN1Object;
        }
    }

    public PKIMessage(PKIHeader pKIHeader, PKIBody pKIBody, DERBitString dERBitString) {
        this(pKIHeader, pKIBody, dERBitString, null);
    }

    public PKIMessage(PKIHeader pKIHeader, PKIBody pKIBody) {
        this(pKIHeader, pKIBody, null, null);
    }

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n3, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            DERTaggedObject dERTaggedObject;
            ASN1Object aSN1Object = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, n3, aSN1Encodable);
            aSN1EncodableVector.add(aSN1Object);
        }
    }

    public PKIHeader getHeader() {
        return this.header;
    }

    public PKIBody getBody() {
        return this.body;
    }

    public DERBitString getProtection() {
        return this.protection;
    }

    public CMPCertificate[] getExtraCerts() {
        ASN1Sequence aSN1Sequence = this.extraCerts;
        if (aSN1Sequence == null) {
            return null;
        }
        int n3 = aSN1Sequence.size();
        CMPCertificate[] cMPCertificateArray = new CMPCertificate[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            cMPCertificateArray[i3] = CMPCertificate.getInstance(this.extraCerts.getObjectAt(i3));
        }
        return cMPCertificateArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        PKIMessage pKIMessage = aSN1Object;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(4);
        aSN1EncodableVector2.add(aSN1Object.header);
        aSN1EncodableVector.add(aSN1Object.body);
        ASN1Object aSN1Object = pKIMessage.protection;
        pKIMessage.addOptional(aSN1EncodableVector2, 0, aSN1Object);
        aSN1Object = pKIMessage.extraCerts;
        pKIMessage.addOptional(aSN1EncodableVector2, 1, aSN1Object);
        return new DERSequence(aSN1EncodableVector2);
    }
}

