/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSet;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.Attribute;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.Attributes;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class AttributeTable {
    private Hashtable attributes;

    public AttributeTable(Hashtable hashtable) {
        this.attributes = new Hashtable();
        this.attributes = this.copyTable(hashtable);
    }

    public AttributeTable(ASN1EncodableVector aSN1EncodableVector) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable;
        hashtable = new Hashtable();
        this.attributes = hashtable2;
        for (int i3 = 0; i3 != aSN1EncodableVector.size(); ++i3) {
            Attribute attribute = Attribute.getInstance(aSN1EncodableVector.get(i3));
            this.addAttribute(attribute.getAttrType(), attribute);
        }
    }

    public AttributeTable(ASN1Set aSN1Set) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable;
        hashtable = new Hashtable();
        this.attributes = hashtable2;
        for (int i3 = 0; i3 != aSN1Set.size(); ++i3) {
            Attribute attribute = Attribute.getInstance(aSN1Set.getObjectAt(i3));
            this.addAttribute(attribute.getAttrType(), attribute);
        }
    }

    public AttributeTable(Attribute attribute) {
        this.attributes = new Hashtable();
        this.addAttribute(attribute.getAttrType(), attribute);
    }

    public AttributeTable(Attributes attributes) {
        this(ASN1Set.getInstance(attributes.toASN1Primitive()));
    }

    private void addAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, Attribute attribute) {
        Object v2 = this.attributes.get(aSN1ObjectIdentifier);
        if (v2 == null) {
            this.attributes.put(aSN1ObjectIdentifier, attribute);
        } else {
            Vector<Object> vector;
            if (v2 instanceof Attribute) {
                Vector<Object> vector2;
                vector = vector2;
                new Vector<Object>().addElement(v2);
                vector.addElement(attribute);
            } else {
                vector = (Vector)v2;
                vector.addElement(attribute);
            }
            this.attributes.put(aSN1ObjectIdentifier, vector);
        }
    }

    private Hashtable copyTable(Hashtable hashtable) {
        Hashtable hashtable2;
        Hashtable hashtable3 = hashtable2;
        hashtable2 = new Hashtable();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k3 = enumeration.nextElement();
            hashtable3.put(k3, hashtable.get(k3));
        }
        return hashtable3;
    }

    public Attribute get(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        AttributeTable attributeTable = attributeTable.attributes.get(aSN1ObjectIdentifier);
        if (attributeTable instanceof Vector) {
            return (Attribute)((Vector)((Object)attributeTable)).elementAt(0);
        }
        return (Attribute)((Object)attributeTable);
    }

    public ASN1EncodableVector getAll(ASN1ObjectIdentifier object) {
        ASN1EncodableVector aSN1EncodableVector;
        AttributeTable attributeTable = aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        if ((object = attributeTable.attributes.get(object)) instanceof Vector) {
            object = ((Vector)object).elements();
            while (object.hasMoreElements()) {
                aSN1EncodableVector2.add((Attribute)object.nextElement());
            }
        } else if (object != null) {
            aSN1EncodableVector2.add((Attribute)object);
        }
        return aSN1EncodableVector2;
    }

    public int size() {
        int n3 = 0;
        Enumeration enumeration = this.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Object v2 = enumeration.nextElement();
            if (v2 instanceof Vector) {
                n3 = ((Vector)v2).size() + n3;
                continue;
            }
            ++n3;
        }
        return n3;
    }

    public Hashtable toHashtable() {
        AttributeTable attributeTable = this;
        return attributeTable.copyTable(attributeTable.attributes);
    }

    public ASN1EncodableVector toASN1EncodableVector() {
        ASN1EncodableVector aSN1EncodableVector;
        AttributeTable attributeTable = aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = attributeTable.attributes.elements();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof Vector) {
                object = ((Vector)object).elements();
                while (object.hasMoreElements()) {
                    aSN1EncodableVector2.add(Attribute.getInstance(object.nextElement()));
                }
                continue;
            }
            aSN1EncodableVector2.add(Attribute.getInstance(object));
        }
        return aSN1EncodableVector2;
    }

    public Attributes toASN1Structure() {
        return new Attributes(this.toASN1EncodableVector());
    }

    public AttributeTable add(ASN1ObjectIdentifier aSN1Primitive, ASN1Encodable aSN1Encodable) {
        DERSet dERSet;
        Attribute attribute;
        AttributeTable attributeTable = new AttributeTable(((AttributeTable)((Object)attribute2)).attributes);
        Attribute attribute2 = attribute;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = aSN1Primitive;
        aSN1Primitive = dERSet;
        dERSet = new DERSet(aSN1Encodable);
        attribute = new Attribute(aSN1ObjectIdentifier, (ASN1Set)aSN1Primitive);
        attributeTable.addAttribute((ASN1ObjectIdentifier)aSN1Primitive, attribute2);
        return attributeTable;
    }

    public AttributeTable remove(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        AttributeTable attributeTable = new AttributeTable(this.attributes);
        attributeTable.attributes.remove(aSN1ObjectIdentifier);
        return attributeTable;
    }
}

