/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.c;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.OtherKeyAttribute;

public class KEKIdentifier
extends ASN1Object {
    private ASN1OctetString keyIdentifier;
    private ASN1GeneralizedTime date;
    private OtherKeyAttribute other;

    public KEKIdentifier(byte[] byArray, ASN1GeneralizedTime aSN1GeneralizedTime, OtherKeyAttribute otherKeyAttribute) {
        DEROctetString dEROctetString;
        ASN1Object aSN1Object = dEROctetString;
        dEROctetString = new DEROctetString(byArray);
        v1.keyIdentifier = aSN1Object;
        v1.date = aSN1GeneralizedTime;
        v1.other = otherKeyAttribute;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private KEKIdentifier(ASN1Sequence aSN1Sequence) {
        this.keyIdentifier = (ASN1OctetString)aSN1Sequence.getObjectAt(0);
        int n3 = aSN1Sequence.size();
        if (n3 == 1) return;
        if (n3 != 2) {
            if (n3 != 3) throw new IllegalArgumentException("Invalid KEKIdentifier");
            this.date = (ASN1GeneralizedTime)aSN1Sequence.getObjectAt(1);
            this.other = OtherKeyAttribute.getInstance(aSN1Sequence.getObjectAt(2));
            return;
        } else if (aSN1Sequence.getObjectAt(1) instanceof ASN1GeneralizedTime) {
            this.date = (ASN1GeneralizedTime)aSN1Sequence.getObjectAt(1);
            return;
        } else {
            this.other = OtherKeyAttribute.getInstance(aSN1Sequence.getObjectAt(1));
        }
    }

    public static KEKIdentifier getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return KEKIdentifier.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static KEKIdentifier getInstance(Object object) {
        if (object != null && !(object instanceof KEKIdentifier)) {
            if (object instanceof ASN1Sequence) {
                return new KEKIdentifier((ASN1Sequence)object);
            }
            throw new IllegalArgumentException(c.a(object, b.a("Invalid KEKIdentifier: ")));
        }
        return (KEKIdentifier)object;
    }

    public ASN1OctetString getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public ASN1GeneralizedTime getDate() {
        return this.date;
    }

    public OtherKeyAttribute getOther() {
        return this.other;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        OtherKeyAttribute otherKeyAttribute;
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(3);
        aSN1EncodableVector.add(this.keyIdentifier);
        ASN1GeneralizedTime aSN1GeneralizedTime = this.date;
        if (aSN1GeneralizedTime != null) {
            aSN1EncodableVector2.add(aSN1GeneralizedTime);
        }
        if ((otherKeyAttribute = this.other) != null) {
            aSN1EncodableVector2.add(otherKeyAttribute);
        }
        return new DERSequence(aSN1EncodableVector2);
    }
}

