/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.OriginatorIdentifierOrKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KeyAgreeRecipientInfo
extends ASN1Object {
    private ASN1Integer version;
    private OriginatorIdentifierOrKey originator;
    private ASN1OctetString ukm;
    private AlgorithmIdentifier keyEncryptionAlgorithm;
    private ASN1Sequence recipientEncryptedKeys;

    public KeyAgreeRecipientInfo(OriginatorIdentifierOrKey originatorIdentifierOrKey, ASN1OctetString aSN1OctetString, AlgorithmIdentifier algorithmIdentifier, ASN1Sequence aSN1Sequence) {
        ASN1Integer aSN1Integer;
        ASN1Object aSN1Object = aSN1Integer;
        aSN1Integer = new ASN1Integer(3L);
        v1.version = aSN1Object;
        v1.originator = originatorIdentifierOrKey;
        v1.ukm = aSN1OctetString;
        v1.keyEncryptionAlgorithm = algorithmIdentifier;
        v1.recipientEncryptedKeys = aSN1Sequence;
    }

    public KeyAgreeRecipientInfo(ASN1Sequence aSN1Sequence) {
        this.version = (ASN1Integer)aSN1Sequence.getObjectAt(0);
        int n3 = 2;
        this.originator = OriginatorIdentifierOrKey.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(1), true);
        if (aSN1Sequence.getObjectAt(n3) instanceof ASN1TaggedObject) {
            int n4 = n3;
            n3 = 3;
            this.ukm = ASN1OctetString.getInstance((ASN1TaggedObject)aSN1Sequence.getObjectAt(n4), true);
        }
        int n5 = n3;
        int n6 = n5 + 1;
        this.keyEncryptionAlgorithm = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(n5));
        this.recipientEncryptedKeys = (ASN1Sequence)aSN1Sequence.getObjectAt(n6);
    }

    public static KeyAgreeRecipientInfo getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return KeyAgreeRecipientInfo.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static KeyAgreeRecipientInfo getInstance(Object object) {
        if (object instanceof KeyAgreeRecipientInfo) {
            return (KeyAgreeRecipientInfo)object;
        }
        if (object != null) {
            return new KeyAgreeRecipientInfo(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public OriginatorIdentifierOrKey getOriginator() {
        return this.originator;
    }

    public ASN1OctetString getUserKeyingMaterial() {
        return this.ukm;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public ASN1Sequence getRecipientEncryptedKeys() {
        return this.recipientEncryptedKeys;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector2(5);
        aSN1EncodableVector.add(this.version);
        ASN1Object aSN1Object = this.originator;
        aSN1EncodableVector.add(new DERTaggedObject(true, 0, aSN1Object));
        aSN1Object = this.ukm;
        if (aSN1Object != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(true, 1, aSN1Object);
            aSN1EncodableVector2.add(dERTaggedObject2);
        }
        aSN1EncodableVector2.add(this.keyEncryptionAlgorithm);
        aSN1EncodableVector2.add(this.recipientEncryptedKeys);
        return new DERSequence(aSN1EncodableVector2);
    }
}

