/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1EncodableVector;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERTaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.CertTemplate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.crmf.OptionalValidity;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extensions;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509Extensions;

public class CertTemplateBuilder {
    private ASN1Integer version;
    private ASN1Integer serialNumber;
    private AlgorithmIdentifier signingAlg;
    private X500Name issuer;
    private OptionalValidity validity;
    private X500Name subject;
    private SubjectPublicKeyInfo publicKey;
    private DERBitString issuerUID;
    private DERBitString subjectUID;
    private Extensions extensions;

    private void addOptional(ASN1EncodableVector aSN1EncodableVector, int n3, boolean bl, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable != null) {
            DERTaggedObject dERTaggedObject;
            DERTaggedObject dERTaggedObject2 = dERTaggedObject;
            dERTaggedObject = new DERTaggedObject(bl, n3, aSN1Encodable);
            aSN1EncodableVector.add(dERTaggedObject2);
        }
    }

    public CertTemplateBuilder setVersion(int n3) {
        this.version = new ASN1Integer(n3);
        return this;
    }

    public CertTemplateBuilder setSerialNumber(ASN1Integer aSN1Integer) {
        this.serialNumber = aSN1Integer;
        return this;
    }

    public CertTemplateBuilder setSigningAlg(AlgorithmIdentifier algorithmIdentifier) {
        this.signingAlg = algorithmIdentifier;
        return this;
    }

    public CertTemplateBuilder setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
        return this;
    }

    public CertTemplateBuilder setValidity(OptionalValidity optionalValidity) {
        this.validity = optionalValidity;
        return this;
    }

    public CertTemplateBuilder setSubject(X500Name x500Name) {
        this.subject = x500Name;
        return this;
    }

    public CertTemplateBuilder setPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.publicKey = subjectPublicKeyInfo;
        return this;
    }

    public CertTemplateBuilder setIssuerUID(DERBitString dERBitString) {
        this.issuerUID = dERBitString;
        return this;
    }

    public CertTemplateBuilder setSubjectUID(DERBitString dERBitString) {
        this.subjectUID = dERBitString;
        return this;
    }

    public CertTemplateBuilder setExtensions(X509Extensions x509Extensions) {
        return this.setExtensions(Extensions.getInstance(x509Extensions));
    }

    public CertTemplateBuilder setExtensions(Extensions extensions) {
        this.extensions = extensions;
        return this;
    }

    public CertTemplate build() {
        ASN1EncodableVector aSN1EncodableVector;
        CertTemplateBuilder certTemplateBuilder = aSN1EncodableVector2;
        ASN1EncodableVector aSN1EncodableVector2 = aSN1EncodableVector;
        aSN1EncodableVector = new ASN1EncodableVector(10);
        ASN1Object aSN1Object = certTemplateBuilder.version;
        certTemplateBuilder.addOptional(aSN1EncodableVector2, 0, false, aSN1Object);
        aSN1Object = certTemplateBuilder.serialNumber;
        certTemplateBuilder.addOptional(aSN1EncodableVector2, 1, false, aSN1Object);
        aSN1Object = certTemplateBuilder.signingAlg;
        certTemplateBuilder.addOptional(aSN1EncodableVector2, 2, false, aSN1Object);
        aSN1Object = certTemplateBuilder.issuer;
        certTemplateBuilder.addOptional(aSN1EncodableVector2, 3, true, aSN1Object);
        aSN1Object = certTemplateBuilder.validity;
        certTemplateBuilder.addOptional(aSN1EncodableVector2, 4, false, aSN1Object);
        aSN1Object = certTemplateBuilder.subject;
        certTemplateBuilder.addOptional(aSN1EncodableVector2, 5, true, aSN1Object);
        aSN1Object = certTemplateBuilder.publicKey;
        certTemplateBuilder.addOptional(aSN1EncodableVector2, 6, false, aSN1Object);
        aSN1Object = certTemplateBuilder.issuerUID;
        certTemplateBuilder.addOptional(aSN1EncodableVector2, 7, false, aSN1Object);
        aSN1Object = certTemplateBuilder.subjectUID;
        certTemplateBuilder.addOptional(aSN1EncodableVector2, 8, false, aSN1Object);
        aSN1Object = certTemplateBuilder.extensions;
        certTemplateBuilder.addOptional(aSN1EncodableVector2, 9, false, aSN1Object);
        return CertTemplate.getInstance(new DERSequence(aSN1EncodableVector2));
    }
}

